import { world } from "@minecraft/server";

function getScore(objectiveName, player) {
    return world.scoreboard.getObjective(objectiveName)?.getScore(player.scoreboardIdentity)
}

world.afterEvents.itemUse.subscribe((event) => {
    if (event.itemStack.typeId == "zk:lightlesswavebarrage") {
        world.getAllPlayers().forEach(player => {
            let mana = getScore('mana', player)
            if (mana >= 20) {
                world.getAllPlayers().forEach(player => {
                    let ticks = getScore('stcd', player)
                    if (ticks >= 500) {
                        player.runCommandAsync("function lwbarrage")
                    }
                    else if (ticks < 500) {
                        player.runCommandAsync("function darkcdntfr")
                    }
                })
            }
            else if (mana < 20) {
                player.runCommandAsync("function nmana")
            }
        })
    }
})