import { world } from "@minecraft/server";

function getScore(objectiveName, player) {
    return world.scoreboard.getObjective(objectiveName)?.getScore(player.scoreboardIdentity)
}

world.afterEvents.itemUse.subscribe((event) => {
    if (event.itemStack.typeId == "zk:darkdimensionslash") {
        world.getAllPlayers().forEach(player => {
            let mana = getScore('mana', player)
            if (mana >= 14) {
                world.getAllPlayers().forEach(player => {
                    let ticks = getScore('utcd', player)
                    if (ticks >= 300) {
                        player.runCommandAsync("function darkslash")
                    }
                    else if (ticks < 300) {
                        player.runCommandAsync("function darkcdntfr")
                    }
                })
            }
            else if (mana < 14) {
                player.runCommandAsync("function nmana")
            }
        })
    }
})