import { world } from "@minecraft/server";

function getScore(objectiveName, player) {
    return world.scoreboard.getObjective(objectiveName)?.getScore(player.scoreboardIdentity)
}

world.afterEvents.itemUse.subscribe((event) => {
    if (event.itemStack.typeId == "zk:darkshot") {
        world.getAllPlayers().forEach(player => {
            let mana = getScore('mana', player)
            if (mana >= 2) {
                world.getAllPlayers().forEach(player => {
                    let ticks = getScore('bscd', player)
                    if (ticks >= 30) {
                        player.runCommandAsync("function darkshot")
                    }
                    else if (ticks < 30) {
                        player.runCommandAsync("function darkcdntfr")
                    }
                })
            }
            else if (mana < 2) {
                player.runCommandAsync("function nmana")
            }
        })
    }
})