import { world } from "@minecraft/server";

function getScore(objectiveName, player) {
    return world.scoreboard.getObjective(objectiveName)?.getScore(player.scoreboardIdentity)
}

world.afterEvents.itemUse.subscribe((event) => {
    if (event.itemStack.typeId == "zk:darknesscoat") {
        world.getAllPlayers().forEach(player => {
            let mana = getScore('mana', player)
            if (mana >= 14) {
                world.getAllPlayers().forEach(player => {
                    let ticks = getScore('stwcd', player)
                    if (ticks >= 240) {
                        player.runCommandAsync("function darkcoat")
                    }
                    else if (ticks < 240) {
                        player.runCommandAsync("function darkcdntfr")
                    }
                })
            }
            else if (mana < 14) {
                player.runCommandAsync("function nmana")
            }
        })
    }
})