import { world } from "@minecraft/server";

function getScore(objectiveName, player) {
    return world.scoreboard.getObjective(objectiveName)?.getScore(player.scoreboardIdentity)
}

world.afterEvents.itemUse.subscribe((event) => {
    if (event.itemStack.typeId == "zk:darkareai") {
        world.getAllPlayers().forEach(player => {
            let mana = getScore('mana', player)
            if (mana >= 15) {
                world.getAllPlayers().forEach(player => {
                    let ticks = getScore('stwcd', player)
                    if (ticks >= 280) {
                        player.runCommandAsync("function darkarea")
                    }
                    else if (ticks < 280) {
                        player.runCommandAsync("function darkcdntfr")
                    }
                })
            }
            else if (mana < 15) {
                player.runCommandAsync("function nmana")
            }
        })
    }
})