/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.utils;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;

public class StructureUtils {
    public static Direction getRandomDir(Random rand) {
        return Direction.func_176731_b((int)rand.nextInt(4));
    }

    public static int getLowestHeight(IWorld world, int x, int z, int xSize, int zSize) {
        int h0 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
        int h1 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x + xSize, z);
        int h2 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z + zSize);
        int h3 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x + xSize, z + zSize);
        return Math.min(Math.min(h0, h1), Math.min(h2, h3));
    }

    public static BlockPos getSurfaceStructurePosition(@Nonnull ChunkGenerator<?> generator, int size, Rotation rotation, int chunkX, int chunkZ) {
        int xOffset = size * 16;
        int zOffset = size * 16;
        int x = chunkX << 4;
        int z = chunkZ << 4;
        int i1 = generator.func_222531_c(x, z, Heightmap.Type.WORLD_SURFACE_WG);
        int j1 = generator.func_222531_c(x, z + zOffset, Heightmap.Type.WORLD_SURFACE_WG);
        int k1 = generator.func_222531_c(x + xOffset, z, Heightmap.Type.WORLD_SURFACE_WG);
        int l1 = generator.func_222531_c(x + xOffset, z + zOffset, Heightmap.Type.WORLD_SURFACE_WG);
        int minHeight = Math.min(Math.min(i1, j1), Math.min(k1, l1));
        return new BlockPos(x + xOffset / 2, minHeight - 2, z + zOffset / 2);
    }
}

