/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class RayTraceContext {
    private final Vec3d field_222254_a;
    private final Vec3d field_222255_b;
    private final BlockMode field_222256_c;
    private final FluidMode field_222257_d;
    private final ISelectionContext field_222258_e;

    public RayTraceContext(Vec3d startVecIn, Vec3d endVecIn, BlockMode blockModeIn, FluidMode fluidModeIn, @Nullable Entity entityIn) {
        this.field_222254_a = startVecIn;
        this.field_222255_b = endVecIn;
        this.field_222256_c = blockModeIn;
        this.field_222257_d = fluidModeIn;
        this.field_222258_e = entityIn == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a(entityIn);
    }

    public Vec3d func_222250_a() {
        return this.field_222255_b;
    }

    public Vec3d func_222253_b() {
        return this.field_222254_a;
    }

    public VoxelShape func_222251_a(BlockState p_222251_1_, IBlockReader p_222251_2_, BlockPos p_222251_3_) {
        return this.field_222256_c.get(p_222251_1_, p_222251_2_, p_222251_3_, this.field_222258_e);
    }

    public VoxelShape func_222252_a(IFluidState p_222252_1_, IBlockReader p_222252_2_, BlockPos p_222252_3_) {
        return this.field_222257_d.func_222248_a(p_222252_1_) ? p_222252_1_.func_215676_d(p_222252_2_, p_222252_3_) : VoxelShapes.func_197880_a();
    }

    public static interface IVoxelProvider {
        public VoxelShape get(BlockState var1, IBlockReader var2, BlockPos var3, ISelectionContext var4);
    }

    public static enum FluidMode {
        NONE(p_222247_0_ -> false),
        SOURCE_ONLY(IFluidState::func_206889_d),
        ANY(p_222246_0_ -> !p_222246_0_.func_206888_e());

        private final Predicate<IFluidState> field_222249_d;

        private FluidMode(Predicate<IFluidState> fluidTestIn) {
            this.field_222249_d = fluidTestIn;
        }

        public boolean func_222248_a(IFluidState state) {
            return this.field_222249_d.test(state);
        }
    }

    public static enum BlockMode implements IVoxelProvider
    {
        COLLIDER(BlockState::func_215685_b),
        OUTLINE(BlockState::func_215700_a);

        private final IVoxelProvider field_222245_c;

        private BlockMode(IVoxelProvider providerIn) {
            this.field_222245_c = providerIn;
        }

        @Override
        public VoxelShape get(BlockState p_get_1_, IBlockReader p_get_2_, BlockPos p_get_3_, ISelectionContext p_get_4_) {
            return this.field_222245_c.get(p_get_1_, p_get_2_, p_get_3_, p_get_4_);
        }
    }
}

