/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.common.util.ReverseTagWrapper;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.GameData;

public class Item
extends ForgeRegistryEntry<Item>
implements IItemProvider,
IForgeItem {
    public static final Map<Block, Item> field_179220_a = GameData.getBlockItemMap();
    private static final IItemPropertyGetter field_185046_b = (p_210306_0_, p_210306_1_, p_210306_2_) -> p_210306_0_.func_77951_h() ? 1.0f : 0.0f;
    private static final IItemPropertyGetter field_185047_c = (p_210307_0_, p_210307_1_, p_210307_2_) -> MathHelper.func_76131_a((float)((float)p_210307_0_.func_77952_i() / (float)p_210307_0_.func_77958_k()), (float)0.0f, (float)1.0f);
    private static final IItemPropertyGetter field_185048_d = (p_210305_0_, p_210305_1_, p_210305_2_) -> p_210305_2_ != null && p_210305_2_.func_184591_cq() != HandSide.RIGHT ? 1.0f : 0.0f;
    private static final IItemPropertyGetter field_185049_e = (p_210308_0_, p_210308_1_, p_210308_2_) -> p_210308_2_ instanceof PlayerEntity ? ((PlayerEntity)p_210308_2_).func_184811_cZ().func_185143_a(p_210308_0_.func_77973_b(), 0.0f) : 0.0f;
    private static final IItemPropertyGetter field_219973_e = (p_219969_0_, p_219969_1_, p_219969_2_) -> p_219969_0_.func_77942_o() ? (float)p_219969_0_.func_77978_p().func_74762_e("CustomModelData") : 0.0f;
    protected static final UUID field_111210_e = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID field_185050_h = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    protected static final Random field_77697_d = new Random();
    public final Map<ResourceLocation, IItemPropertyGetter> field_185051_m = Maps.newHashMap();
    protected final ItemGroup field_77701_a;
    private final Rarity field_208075_l;
    private final int field_77777_bU;
    private final int field_77699_b;
    private final Item field_77700_c;
    @Nullable
    private String field_77774_bZ;
    @Nullable
    private final Food field_219974_q;
    @Nullable
    private final Supplier<ItemStackTileEntityRenderer> ister;
    private final Map<ToolType, Integer> toolClasses = Maps.newHashMap();
    private final ReverseTagWrapper<Item> reverseTags = new ReverseTagWrapper((Object)this, ItemTags::getGeneration, ItemTags::func_199903_a);
    protected final boolean canRepair;

    public static int func_150891_b(Item itemIn) {
        return itemIn == null ? 0 : Registry.field_212630_s.func_148757_b((Object)itemIn);
    }

    public static Item func_150899_d(int id) {
        return (Item)((Object)Registry.field_212630_s.func_148745_a(id));
    }

    @Deprecated
    public static Item func_150898_a(Block blockIn) {
        return field_179220_a.getOrDefault((Object)blockIn, Items.field_190931_a);
    }

    public Item(Properties properties) {
        this.func_185043_a(new ResourceLocation("lefthanded"), field_185048_d);
        this.func_185043_a(new ResourceLocation("cooldown"), field_185049_e);
        this.func_185043_a(new ResourceLocation("custom_model_data"), field_219973_e);
        this.field_77701_a = properties.field_200923_d;
        this.field_208075_l = properties.field_208104_e;
        this.field_77700_c = properties.field_200922_c;
        this.field_77699_b = properties.field_200921_b;
        this.field_77777_bU = properties.field_200920_a;
        this.field_219974_q = properties.field_221541_f;
        if (this.field_77699_b > 0) {
            this.func_185043_a(new ResourceLocation("damaged"), field_185046_b);
            this.func_185043_a(new ResourceLocation("damage"), field_185047_c);
        }
        this.canRepair = properties.canRepair;
        this.toolClasses.putAll(properties.toolClasses);
        Object tmp = properties.ister == null ? null : DistExecutor.callWhenOn((Dist)Dist.CLIENT, (Supplier)properties.ister);
        this.ister = tmp == null ? null : () -> (ItemStackTileEntityRenderer)tmp;
    }

    public void func_219972_a(World worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IItemPropertyGetter func_185045_a(ResourceLocation key) {
        return this.field_185051_m.get(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_185040_i() {
        return !this.field_185051_m.isEmpty();
    }

    public boolean func_179215_a(CompoundNBT nbt) {
        return false;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public Item func_199767_j() {
        return this;
    }

    public final void func_185043_a(ResourceLocation key, IItemPropertyGetter getter) {
        this.field_185051_m.put(key, getter);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return 1.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (this.func_219971_r()) {
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            if (playerIn.func_71043_e(this.func_219967_s().func_221468_d())) {
                playerIn.func_184598_c(handIn);
                return ActionResult.func_226249_b_((Object)((Object)itemstack));
            }
            return ActionResult.func_226251_d_((Object)((Object)itemstack));
        }
        return ActionResult.func_226250_c_((Object)((Object)playerIn.func_184586_b(handIn)));
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        return this.func_219971_r() ? entityLiving.func_213357_a(worldIn, stack) : stack;
    }

    @Deprecated
    public final int func_77639_j() {
        return this.field_77777_bU;
    }

    @Deprecated
    public final int func_77612_l() {
        return this.field_77699_b;
    }

    public boolean func_77645_m() {
        return this.field_77699_b > 0;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return false;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return false;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent func_200296_o() {
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]);
    }

    public String toString() {
        return Registry.field_212630_s.func_177774_c((Object)this).func_110623_a();
    }

    protected String func_195935_o() {
        if (this.field_77774_bZ == null) {
            this.field_77774_bZ = Util.func_200697_a((String)"item", (ResourceLocation)Registry.field_212630_s.func_177774_c((Object)this));
        }
        return this.field_77774_bZ;
    }

    public String func_77658_a() {
        return this.func_195935_o();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    @Deprecated
    public final Item func_77668_q() {
        return this.field_77700_c;
    }

    @Deprecated
    public boolean func_77634_r() {
        return this.field_77700_c != null;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
    }

    public boolean func_77643_m_() {
        return false;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() ? UseAction.EAT : UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        if (stack.func_77973_b().func_219971_r()) {
            return this.func_219967_s().func_221465_e() ? 16 : 32;
        }
        return 0;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent(this.func_77667_c(stack), new Object[0]);
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77948_v();
    }

    public Rarity func_77613_e(ItemStack stack) {
        if (!stack.func_77948_v()) {
            return this.field_208075_l;
        }
        switch (this.field_208075_l) {
            case COMMON: 
            case UNCOMMON: {
                return Rarity.RARE;
            }
            case RARE: {
                return Rarity.EPIC;
            }
        }
        return this.field_208075_l;
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemStackLimit(stack) == 1 && this.func_77645_m();
    }

    protected static RayTraceResult func_219968_a(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, player));
    }

    public int func_77619_b() {
        return 0;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack(this));
        }
    }

    protected boolean func_194125_a(ItemGroup group) {
        if (this.getCreativeTabs().stream().anyMatch(tab -> tab == group)) {
            return true;
        }
        ItemGroup itemgroup = this.func_77640_w();
        return itemgroup != null && (group == ItemGroup.field_78027_g || group == itemgroup);
    }

    @Nullable
    public final ItemGroup func_77640_w() {
        return this.field_77701_a;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Deprecated
    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return HashMultimap.create();
    }

    public boolean isRepairable(ItemStack stack) {
        return this.canRepair && this.func_77645_m();
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        return this.toolClasses.keySet();
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return this.toolClasses.getOrDefault(tool, -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final ItemStackTileEntityRenderer getItemStackTileEntityRenderer() {
        ItemStackTileEntityRenderer renderer = this.ister != null ? this.ister.get() : null;
        return renderer != null ? renderer : ItemStackTileEntityRenderer.field_147719_a;
    }

    public Set<ResourceLocation> getTags() {
        return this.reverseTags.getTagNames();
    }

    public boolean func_219970_i(ItemStack stack) {
        return stack.func_77973_b() == Items.field_222114_py;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_190903_i() {
        return new ItemStack(this);
    }

    public boolean func_206844_a(Tag<Item> tagIn) {
        return tagIn.func_199685_a_(this);
    }

    public boolean func_219971_r() {
        return this.field_219974_q != null;
    }

    @Nullable
    public Food func_219967_s() {
        return this.field_219974_q;
    }

    public SoundEvent func_225520_U__() {
        return SoundEvents.field_187664_bz;
    }

    public SoundEvent func_225519_S__() {
        return SoundEvents.field_187537_bA;
    }

    public static class Properties {
        private int field_200920_a = 64;
        private int field_200921_b;
        private Item field_200922_c;
        private ItemGroup field_200923_d;
        private Rarity field_208104_e = Rarity.COMMON;
        private Food field_221541_f;
        private boolean canRepair = true;
        private Map<ToolType, Integer> toolClasses = Maps.newHashMap();
        private Supplier<Callable<ItemStackTileEntityRenderer>> ister;

        public Properties func_221540_a(Food foodIn) {
            this.field_221541_f = foodIn;
            return this;
        }

        public Properties func_200917_a(int maxStackSizeIn) {
            if (this.field_200921_b > 0) {
                throw new RuntimeException("Unable to have damage AND stack.");
            }
            this.field_200920_a = maxStackSizeIn;
            return this;
        }

        public Properties func_200915_b(int maxDamageIn) {
            return this.field_200921_b == 0 ? this.func_200918_c(maxDamageIn) : this;
        }

        public Properties func_200918_c(int maxDamageIn) {
            this.field_200921_b = maxDamageIn;
            this.field_200920_a = 1;
            return this;
        }

        public Properties func_200919_a(Item containerItemIn) {
            this.field_200922_c = containerItemIn;
            return this;
        }

        public Properties func_200916_a(ItemGroup groupIn) {
            this.field_200923_d = groupIn;
            return this;
        }

        public Properties func_208103_a(Rarity rarityIn) {
            this.field_208104_e = rarityIn;
            return this;
        }

        public Properties setNoRepair() {
            this.canRepair = false;
            return this;
        }

        public Properties addToolType(ToolType type, int level) {
            this.toolClasses.put(type, level);
            return this;
        }

        public Properties setISTER(Supplier<Callable<ItemStackTileEntityRenderer>> ister) {
            this.ister = ister;
            return this;
        }
    }
}

