/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class CampfireBlock
extends ContainerBlock
implements IWaterLoggable {
    protected static final VoxelShape field_220100_a = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 7.0, 16.0);
    public static final BooleanProperty field_220101_b = BlockStateProperties.field_208190_q;
    public static final BooleanProperty field_220102_c = BlockStateProperties.field_222516_y;
    public static final BooleanProperty field_220103_d = BlockStateProperties.field_208198_y;
    public static final DirectionProperty field_220104_e = BlockStateProperties.field_208157_J;
    private static final VoxelShape field_226912_f_ = Block.func_208617_a(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);

    public CampfireBlock(Block.Properties propertiesIn) {
        super(propertiesIn);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_220101_b, Boolean.valueOf(true)))).func_206870_a((IProperty)field_220102_c, Boolean.valueOf(false)))).func_206870_a((IProperty)field_220103_d, Boolean.valueOf(false)))).func_206870_a((IProperty)field_220104_e, (Comparable)((Object)Direction.NORTH))));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack;
        CampfireTileEntity campfiretileentity;
        Optional optional;
        TileEntity tileentity;
        if (((Boolean)state.func_177229_b((IProperty)field_220101_b)).booleanValue() && (tileentity = worldIn.func_175625_s(pos)) instanceof CampfireTileEntity && (optional = (campfiretileentity = (CampfireTileEntity)tileentity).func_213980_a(itemstack = player.func_184586_b(handIn))).isPresent()) {
            if (!worldIn.field_72995_K && campfiretileentity.func_213984_a(player.field_71075_bZ.field_75098_d ? itemstack.func_77946_l() : itemstack, ((CampfireCookingRecipe)optional.get()).func_222137_e())) {
                player.func_195066_a(Stats.field_219736_at);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_70045_F() && ((Boolean)state.func_177229_b((IProperty)field_220101_b)).booleanValue() && entityIn instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)entityIn)) {
            entityIn.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CampfireTileEntity) {
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, (NonNullList)((CampfireTileEntity)tileentity).func_213985_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos;
        World iworld = context.func_195991_k();
        boolean flag = iworld.func_204610_c(blockpos = context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.func_176223_P().func_206870_a((IProperty)field_220103_d, Boolean.valueOf(flag)))).func_206870_a((IProperty)field_220102_c, Boolean.valueOf(this.func_220099_j(iworld.func_180495_p(blockpos.func_177977_b())))))).func_206870_a((IProperty)field_220101_b, Boolean.valueOf(!flag)))).func_206870_a((IProperty)field_220104_e, (Comparable)((Object)context.func_195992_f())));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_220103_d)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == Direction.DOWN ? (BlockState)((Object)stateIn.func_206870_a((IProperty)field_220102_c, Boolean.valueOf(this.func_220099_j(facingState)))) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private boolean func_220099_j(BlockState stateIn) {
        return stateIn.func_177230_c() == Blocks.field_150407_cf;
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_220101_b) != false ? super.func_149750_m(state) : 0;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_220100_a;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_220101_b)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, rand.nextFloat() / 2.0f, 5.0E-5, rand.nextFloat() / 2.0f);
                }
            }
        }
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            boolean flag = (Boolean)state.func_177229_b((IProperty)field_220101_b);
            if (flag) {
                if (worldIn.func_201670_d()) {
                    for (int i = 0; i < 20; ++i) {
                        CampfireBlock.func_220098_a(worldIn.func_201672_e(), pos, (Boolean)state.func_177229_b((IProperty)field_220102_c), true);
                    }
                } else {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                TileEntity tileentity = worldIn.func_175625_s(pos);
                if (tileentity instanceof CampfireTileEntity) {
                    ((CampfireTileEntity)tileentity).func_213986_d();
                }
            }
            worldIn.func_180501_a(pos, (BlockState)((Object)((BlockState)((Object)state.func_206870_a((IProperty)field_220103_d, Boolean.valueOf(true)))).func_206870_a((IProperty)field_220101_b, Boolean.valueOf(false))), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a(worldIn));
            return true;
        }
        return false;
    }

    @Nullable
    private Entity func_226913_a_(Entity p_226913_1_) {
        if (p_226913_1_ instanceof AbstractFireballEntity) {
            return ((AbstractFireballEntity)p_226913_1_).field_70235_a;
        }
        return p_226913_1_ instanceof AbstractArrowEntity ? ((AbstractArrowEntity)p_226913_1_).func_212360_k() : null;
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, Entity projectile) {
        if (!worldIn.field_72995_K) {
            boolean flag;
            boolean bl = flag = projectile instanceof AbstractFireballEntity || projectile instanceof AbstractArrowEntity && projectile.func_70027_ad();
            if (flag) {
                boolean flag1;
                Entity entity = this.func_226913_a_(projectile);
                boolean bl2 = flag1 = entity == null || entity instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entity);
                if (flag1 && !((Boolean)state.func_177229_b((IProperty)field_220101_b)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)field_220103_d)).booleanValue()) {
                    BlockPos blockpos = hit.func_216350_a();
                    worldIn.func_180501_a(blockpos, (BlockState)((Object)state.func_206870_a((IProperty)BlockStateProperties.field_208190_q, Boolean.valueOf(true))), 11);
                }
            }
        }
    }

    public static void func_220098_a(World worldIn, BlockPos pos, boolean isSignalFire, boolean spawnExtraSmoke) {
        Random random = worldIn.func_201674_k();
        BasicParticleType basicparticletype = isSignalFire ? ParticleTypes.field_218418_af : ParticleTypes.field_218417_ae;
        worldIn.func_217404_b((IParticleData)basicparticletype, true, (double)pos.func_177958_n() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + random.nextDouble() + random.nextDouble(), (double)pos.func_177952_p() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean func_226914_b_(World p_226914_0_, BlockPos p_226914_1_, int p_226914_2_) {
        for (int i = 1; i <= p_226914_2_; ++i) {
            BlockPos blockpos = p_226914_1_.func_177979_c(i);
            BlockState blockstate = p_226914_0_.func_180495_p(blockpos);
            if (CampfireBlock.func_226915_i_(blockstate)) {
                return true;
            }
            boolean flag = VoxelShapes.func_197879_c((VoxelShape)field_226912_f_, (VoxelShape)blockstate.func_215685_b((IBlockReader)((Object)p_226914_0_), p_226914_1_, ISelectionContext.func_216377_a()), (IBooleanFunction)IBooleanFunction.field_223238_i_);
            if (!flag) continue;
            BlockState blockstate1 = p_226914_0_.func_180495_p(blockpos.func_177977_b());
            return CampfireBlock.func_226915_i_(blockstate1);
        }
        return false;
    }

    private static boolean func_226915_i_(BlockState p_226915_0_) {
        return p_226915_0_.func_177230_c() == Blocks.field_222433_lV && (Boolean)p_226915_0_.func_177229_b((IProperty)field_220101_b) != false;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_220103_d) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)((Object)state.func_206870_a((IProperty)field_220104_e, (Comparable)((Object)rot.func_185831_a((Direction)((Object)state.func_177229_b((IProperty)field_220104_e))))));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)((Object)state.func_177229_b((IProperty)field_220104_e))));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_220101_b, field_220102_c, field_220103_d, field_220104_e});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CampfireTileEntity();
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

