/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.theloader;

import com.teamacronymcoders.theloader.TheLoader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;

public class AlwaysEnabledFolderPackFinder
implements IPackFinder {
    private static final FileFilter FILE_FILTER = p_195731_0_ -> {
        boolean lvt_1_1_ = p_195731_0_.isFile() && p_195731_0_.getName().endsWith(".zip");
        boolean lvt_2_1_ = p_195731_0_.isDirectory() && new File(p_195731_0_, "pack.mcmeta").isFile();
        return lvt_1_1_ || lvt_2_1_;
    };
    private final File folder;

    public AlwaysEnabledFolderPackFinder(File folder) {
        this.folder = folder;
    }

    @ParametersAreNonnullByDefault
    public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> packInfo, ResourcePackInfo.IFactory<T> factory) {
        File[] packFiles;
        if (!this.folder.isDirectory()) {
            try {
                Files.createDirectories(this.folder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                TheLoader.LOGGER.error("Failed to Setup Directory for Pack", (Throwable)e);
            }
        }
        if ((packFiles = this.folder.listFiles(FILE_FILTER)) != null) {
            for (File packFile : packFiles) {
                String packName = "the_loader/" + packFile.getName();
                ResourcePackInfo resourcePackInfo = ResourcePackInfo.func_195793_a((String)packName, (boolean)true, this.makePackSupplier(packFile), factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP);
                if (resourcePackInfo == null) continue;
                packInfo.put(packName, resourcePackInfo);
            }
        }
    }

    private Supplier<IResourcePack> makePackSupplier(File file) {
        return file.isDirectory() ? () -> new FolderPack(file) : () -> new FilePack(file);
    }
}

