/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.BinomialRange;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootPredicateManager
extends JsonReloadListener {
    private static final Logger field_227510_a_ = LogManager.getLogger();
    private static final Gson field_227511_b_ = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(BinomialRange.class, (Object)new BinomialRange.Serializer()).registerTypeAdapter(ConstantRange.class, (Object)new ConstantRange.Serializer()).registerTypeHierarchyAdapter(ILootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private Map<ResourceLocation, ILootCondition> field_227512_c_ = ImmutableMap.of();

    public LootPredicateManager() {
        super(field_227511_b_, "predicates");
    }

    @Nullable
    public ILootCondition func_227517_a_(ResourceLocation resourceLocation) {
        return this.field_227512_c_.get(resourceLocation);
    }

    @Override
    protected void func_212853_a_(Map<ResourceLocation, JsonObject> map, IResourceManager iResourceManager, IProfiler iProfiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((resourceLocation, jsonObject) -> {
            try {
                ILootCondition iLootCondition = (ILootCondition)field_227511_b_.fromJson((JsonElement)jsonObject, ILootCondition.class);
                builder.put(resourceLocation, (Object)iLootCondition);
            }
            catch (Exception exception) {
                field_227510_a_.error("Couldn't parse loot table {}", resourceLocation, (Object)exception);
            }
        });
        ImmutableMap \u26032 = builder.build();
        ValidationTracker \u26033 = new ValidationTracker(LootParameterSets.field_216266_g, ((Map)\u26032)::get, resourceLocation -> null);
        \u26032.forEach((resourceLocation, iLootCondition) -> iLootCondition.func_225580_a_(\u26033.func_227535_b_("{" + resourceLocation + "}", (ResourceLocation)resourceLocation)));
        \u26033.func_227527_a_().forEach((string, string2) -> field_227510_a_.warn("Found validation problem in " + string + ": " + string2));
        this.field_227512_c_ = \u26032;
    }

    public Set<ResourceLocation> func_227513_a_() {
        return Collections.unmodifiableSet(this.field_227512_c_.keySet());
    }
}

