/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.chunk.storage.ChunkLoaderUtil;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilSaveConverter {
    private static final Logger field_151480_b = LogManager.getLogger();

    static boolean func_215792_a(Path path, DataFixer dataFixer, String string, IProgressUpdate iProgressUpdate) {
        iProgressUpdate.func_73718_a(0);
        ArrayList arrayList = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        File \u26032 = new File(path.toFile(), string);
        File \u26033 = DimensionType.field_223228_b_.func_212679_a(\u26032);
        File \u26034 = DimensionType.field_223229_c_.func_212679_a(\u26032);
        field_151480_b.info("Scanning folders...");
        AnvilSaveConverter.func_215789_a(\u26032, arrayList);
        if (\u26033.exists()) {
            AnvilSaveConverter.func_215789_a(\u26033, \u2603);
        }
        if (\u26034.exists()) {
            AnvilSaveConverter.func_215789_a(\u26034, \u2603);
        }
        int \u26035 = arrayList.size() + \u2603.size() + \u2603.size();
        field_151480_b.info("Total conversion count is {}", (Object)\u26035);
        WorldInfo \u26036 = SaveFormat.func_215779_a(path, dataFixer, string);
        BiomeProviderType<SingleBiomeProviderSettings, SingleBiomeProvider> \u26037 = BiomeProviderType.field_205461_c;
        BiomeProviderType<OverworldBiomeProviderSettings, OverworldBiomeProvider> \u26038 = BiomeProviderType.field_206859_d;
        BiomeProvider \u26039 = \u26036 != null && \u26036.func_76067_t() == WorldType.field_77138_c ? \u26037.func_205457_a(\u26037.func_226840_a_(\u26036).func_205436_a(Biomes.field_76772_c)) : \u26038.func_205457_a(\u26038.func_226840_a_(\u26036));
        AnvilSaveConverter.func_215794_a(new File(\u26032, "region"), arrayList, \u26039, 0, \u26035, iProgressUpdate);
        AnvilSaveConverter.func_215794_a(new File(\u26033, "region"), \u2603, \u26037.func_205457_a(\u26037.func_226840_a_(\u26036).func_205436_a(Biomes.field_76778_j)), arrayList.size(), \u26035, iProgressUpdate);
        AnvilSaveConverter.func_215794_a(new File(\u26034, "region"), \u2603, \u26037.func_205457_a(\u26037.func_226840_a_(\u26036).func_205436_a(Biomes.field_76779_k)), arrayList.size() + \u2603.size(), \u26035, iProgressUpdate);
        \u26036.func_76078_e(19133);
        if (\u26036.func_76067_t() == WorldType.field_77136_e) {
            \u26036.func_76085_a(WorldType.field_77137_b);
        }
        AnvilSaveConverter.func_215790_a(path, string);
        SaveHandler \u260310 = SaveFormat.func_215783_a(path, dataFixer, string, null);
        \u260310.func_75761_a(\u26036);
        return true;
    }

    private static void func_215790_a(Path path, String string) {
        File file = new File(path.toFile(), string);
        if (!file.exists()) {
            field_151480_b.warn("Unable to create level.dat_mcr backup");
            return;
        }
        \u2603 = new File(file, "level.dat");
        if (!\u2603.exists()) {
            field_151480_b.warn("Unable to create level.dat_mcr backup");
            return;
        }
        \u2603 = new File(file, "level.dat_mcr");
        if (!\u2603.renameTo(\u2603)) {
            field_151480_b.warn("Unable to create level.dat_mcr backup");
        }
    }

    private static void func_215794_a(File file, Iterable<File> iterable, BiomeProvider biomeProvider, int n, int n2, IProgressUpdate iProgressUpdate) {
        for (File file2 : iterable) {
            AnvilSaveConverter.func_215793_a(file, file2, biomeProvider, n, n2, iProgressUpdate);
            int n3 = (int)Math.round(100.0 * (double)(++n) / (double)n2);
            iProgressUpdate.func_73718_a(n3);
        }
    }

    private static void func_215793_a(File file, File file2, BiomeProvider biomeProvider, int n3, int n2, IProgressUpdate iProgressUpdate) {
        String string = file2.getName();
        try (RegionFile regionFile = new RegionFile(file2, file);){
            regionFile2 = new RegionFile(new File(file, string.substring(0, string.length() - ".mcr".length()) + ".mca"), file);
            Throwable throwable = null;
            try {
                for (int i = 0; i < 32; ++i) {
                    int n3;
                    for (\u2603 = 0; \u2603 < 32; ++\u2603) {
                        Object object;
                        ChunkPos chunkPos = new ChunkPos(i, \u2603);
                        if (!regionFile.func_222667_d(chunkPos) || regionFile2.func_222667_d(chunkPos)) continue;
                        try {
                            object = regionFile.func_222666_a(chunkPos);
                            Throwable throwable2 = null;
                            try {
                                if (object == null) {
                                    field_151480_b.warn("Failed to fetch input stream for chunk {}", (Object)chunkPos);
                                    continue;
                                }
                                CompoundNBT compoundNBT = CompressedStreamTools.func_74794_a((DataInputStream)object);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (object != null) {
                                    if (throwable2 != null) {
                                        try {
                                            ((FilterInputStream)object).close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                    } else {
                                        ((FilterInputStream)object).close();
                                    }
                                }
                            }
                        }
                        catch (IOException iOException) {
                            field_151480_b.warn("Failed to read data for chunk {}", (Object)chunkPos, (Object)iOException);
                            continue;
                        }
                        object = compoundNBT.func_74775_l("Level");
                        ChunkLoaderUtil.AnvilConverterData \u26032 = ChunkLoaderUtil.func_76691_a((CompoundNBT)object);
                        CompoundNBT \u26033 = new CompoundNBT();
                        CompoundNBT \u26034 = new CompoundNBT();
                        \u26033.func_218657_a("Level", \u26034);
                        ChunkLoaderUtil.func_76690_a(\u26032, \u26034, biomeProvider);
                        try (DataOutputStream \u26035 = regionFile2.func_222661_c(chunkPos);){
                            CompressedStreamTools.func_74800_a(\u26033, \u26035);
                            continue;
                        }
                    }
                    \u2603 = (int)Math.round(100.0 * (double)(n3 * 1024) / (double)(n2 * 1024));
                    \u2603 = (int)Math.round(100.0 * (double)((i + 1) * 32 + n3 * 1024) / (double)(n2 * 1024));
                    if (\u2603 <= \u2603) continue;
                    iProgressUpdate.func_73718_a(\u2603);
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                RegionFile regionFile2;
                if (regionFile2 != null) {
                    if (throwable != null) {
                        try {
                            regionFile2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        regionFile2.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            field_151480_b.error("Failed to upgrade region file {}", (Object)file2, (Object)iOException);
        }
    }

    private static void func_215789_a(File file2, Collection<File> collection) {
        File file3 = new File(file2, "region");
        File[] \u26032 = file3.listFiles((file, string) -> string.endsWith(".mcr"));
        if (\u26032 != null) {
            Collections.addAll(collection, \u26032);
        }
    }
}

