/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public abstract class NoiseChunkGenerator<T extends GenerationSettings>
extends ChunkGenerator<T> {
    private static final float[] field_222561_h = Util.func_200696_a(new float[13824], fArray -> {
        for (int i = 0; i < 24; ++i) {
            for (\u2603 = 0; \u2603 < 24; ++\u2603) {
                for (\u2603 = 0; \u2603 < 24; ++\u2603) {
                    fArray[i * 24 * 24 + \u2603 * 24 + \u2603] = (float)NoiseChunkGenerator.func_222554_b(\u2603 - 12, \u2603 - 12, i - 12);
                }
            }
        }
    });
    private static final BlockState field_222562_i = Blocks.field_150350_a.func_176223_P();
    private final int field_222563_j;
    private final int field_222564_k;
    private final int field_222565_l;
    private final int field_222566_m;
    private final int field_222567_n;
    protected final SharedSeedRandom field_222558_e;
    private final OctavesNoiseGenerator field_222568_o;
    private final OctavesNoiseGenerator field_222569_p;
    private final OctavesNoiseGenerator field_222570_q;
    private final INoiseGenerator field_222571_r;
    protected final BlockState field_222559_f;
    protected final BlockState field_222560_g;

    public NoiseChunkGenerator(IWorld iWorld, BiomeProvider biomeProvider, int n, int n2, int n3, T t, boolean bl) {
        super(iWorld, biomeProvider, t);
        this.field_222563_j = n2;
        this.field_222564_k = n;
        this.field_222559_f = ((GenerationSettings)t).func_205532_l();
        this.field_222560_g = ((GenerationSettings)t).func_205533_m();
        this.field_222565_l = 16 / this.field_222564_k;
        this.field_222566_m = n3 / this.field_222563_j;
        this.field_222567_n = 16 / this.field_222564_k;
        this.field_222558_e = new SharedSeedRandom(this.field_222541_b);
        this.field_222568_o = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);
        this.field_222569_p = new OctavesNoiseGenerator(this.field_222558_e, 15, 0);
        this.field_222570_q = new OctavesNoiseGenerator(this.field_222558_e, 7, 0);
        this.field_222571_r = bl ? new PerlinNoiseGenerator(this.field_222558_e, 3, 0) : new OctavesNoiseGenerator(this.field_222558_e, 3, 0);
    }

    private double func_222552_a(int n, int n2, int n3, double d, double d2, double d3, double d4) {
        \u2603 = 0.0;
        \u2603 = 0.0;
        \u2603 = 0.0;
        \u2603 = 1.0;
        for (int i = 0; i < 16; ++i) {
            double d5 = OctavesNoiseGenerator.func_215461_a((double)n * d * \u2603);
            \u2603 = OctavesNoiseGenerator.func_215461_a((double)n2 * d2 * \u2603);
            \u2603 = OctavesNoiseGenerator.func_215461_a((double)n3 * d * \u2603);
            \u2603 = d2 * \u2603;
            ImprovedNoiseGenerator \u26032 = this.field_222568_o.func_215463_a(i);
            if (\u26032 != null) {
                \u2603 += \u26032.func_215456_a(d5, \u2603, \u2603, \u2603, (double)n2 * \u2603) / \u2603;
            }
            if ((\u2603 = this.field_222569_p.func_215463_a(i)) != null) {
                \u2603 += \u2603.func_215456_a(d5, \u2603, \u2603, \u2603, (double)n2 * \u2603) / \u2603;
            }
            if (i < 8 && (\u2603 = this.field_222570_q.func_215463_a(i)) != null) {
                \u2603 += \u2603.func_215456_a(OctavesNoiseGenerator.func_215461_a((double)n * d3 * \u2603), OctavesNoiseGenerator.func_215461_a((double)n2 * d4 * \u2603), OctavesNoiseGenerator.func_215461_a((double)n3 * d3 * \u2603), d4 * \u2603, (double)n2 * d4 * \u2603) / \u2603;
            }
            \u2603 /= 2.0;
        }
        return MathHelper.func_151238_b(\u2603 / 512.0, \u2603 / 512.0, (\u2603 / 10.0 + 1.0) / 2.0);
    }

    protected double[] func_222547_b(int n, int n2) {
        double[] dArray = new double[this.field_222566_m + 1];
        this.func_222548_a(dArray, n, n2);
        return dArray;
    }

    protected void func_222546_a(double[] dArray, int n, int n2, double d, double d2, double d3, double d4, int n3, int n4) {
        double[] dArray2 = this.func_222549_a(n, n2);
        double \u26032 = dArray2[0];
        double \u26033 = dArray2[1];
        double \u26034 = this.func_222551_g();
        double \u26035 = this.func_222553_h();
        for (int i = 0; i < this.func_222550_i(); ++i) {
            double d5 = this.func_222552_a(n, i, n2, d, d2, d3, d4);
            d5 -= this.func_222545_a(\u26032, \u26033, i);
            if ((double)i > \u26034) {
                d5 = MathHelper.func_151238_b(d5, n4, ((double)i - \u26034) / (double)n3);
            } else if ((double)i < \u26035) {
                d5 = MathHelper.func_151238_b(d5, -30.0, (\u26035 - (double)i) / (\u26035 - 1.0));
            }
            dArray[i] = d5;
        }
    }

    protected abstract double[] func_222549_a(int var1, int var2);

    protected abstract double func_222545_a(double var1, double var3, int var5);

    protected double func_222551_g() {
        return this.func_222550_i() - 4;
    }

    protected double func_222553_h() {
        return 0.0;
    }

    @Override
    public int func_222529_a(int n, int n2, Heightmap.Type type) {
        int n3 = Math.floorDiv(n, this.field_222564_k);
        \u2603 = Math.floorDiv(n2, this.field_222564_k);
        \u2603 = Math.floorMod(n, this.field_222564_k);
        \u2603 = Math.floorMod(n2, this.field_222564_k);
        double \u26032 = (double)\u2603 / (double)this.field_222564_k;
        double \u26033 = (double)\u2603 / (double)this.field_222564_k;
        double[][] \u26034 = new double[][]{this.func_222547_b(n3, \u2603), this.func_222547_b(n3, \u2603 + 1), this.func_222547_b(n3 + 1, \u2603), this.func_222547_b(n3 + 1, \u2603 + 1)};
        \u2603 = this.func_222530_f();
        for (\u2603 = this.field_222566_m - 1; \u2603 >= 0; --\u2603) {
            double d = \u26034[0][\u2603];
            \u2603 = \u26034[1][\u2603];
            \u2603 = \u26034[2][\u2603];
            \u2603 = \u26034[3][\u2603];
            \u2603 = \u26034[0][\u2603 + 1];
            \u2603 = \u26034[1][\u2603 + 1];
            \u2603 = \u26034[2][\u2603 + 1];
            \u2603 = \u26034[3][\u2603 + 1];
            for (int i = this.field_222563_j - 1; i >= 0; --i) {
                double d2 = (double)i / (double)this.field_222563_j;
                \u2603 = MathHelper.func_219807_a(d2, \u26032, \u26033, d, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
                int \u26035 = \u2603 * this.field_222563_j + i;
                if (!(\u2603 > 0.0) && \u26035 >= \u2603) continue;
                BlockState \u26036 = \u2603 > 0.0 ? this.field_222559_f : this.field_222560_g;
                if (!type.func_222684_d().test(\u26036)) continue;
                return \u26035 + 1;
            }
        }
        return 0;
    }

    protected abstract void func_222548_a(double[] var1, int var2, int var3);

    public int func_222550_i() {
        return this.field_222566_m + 1;
    }

    @Override
    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk iChunk2) {
        IChunk iChunk2;
        ChunkPos chunkPos = iChunk2.func_76632_l();
        int \u26032 = chunkPos.field_77276_a;
        int \u26033 = chunkPos.field_77275_b;
        SharedSeedRandom \u26034 = new SharedSeedRandom();
        \u26034.func_202422_a(\u26032, \u26033);
        \u2603 = iChunk2.func_76632_l();
        int \u26035 = \u2603.func_180334_c();
        int \u26036 = \u2603.func_180333_d();
        double \u26037 = 0.0625;
        BlockPos.Mutable \u26038 = new BlockPos.Mutable();
        for (int i = 0; i < 16; ++i) {
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                \u2603 = \u26035 + i;
                \u2603 = \u26036 + \u2603;
                \u2603 = iChunk2.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i, \u2603) + 1;
                double d = this.field_222571_r.func_215460_a((double)\u2603 * 0.0625, (double)\u2603 * 0.0625, 0.0625, (double)i * 0.0625) * 15.0;
                worldGenRegion.func_226691_t_(\u26038.func_181079_c(\u26035 + i, \u2603, \u26036 + \u2603)).func_206854_a(\u26034, iChunk2, \u2603, \u2603, \u2603, d, ((GenerationSettings)this.func_201496_a_()).func_205532_l(), ((GenerationSettings)this.func_201496_a_()).func_205533_m(), this.func_222530_f(), this.field_222540_a.func_72905_C());
            }
        }
        this.func_222555_a(iChunk2, \u26034);
    }

    protected void func_222555_a(IChunk iChunk, Random random) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int \u26032 = iChunk.func_76632_l().func_180334_c();
        int \u26033 = iChunk.func_76632_l().func_180333_d();
        Object \u26034 = this.func_201496_a_();
        int \u26035 = ((GenerationSettings)\u26034).func_214968_u();
        int \u26036 = ((GenerationSettings)\u26034).func_214967_t();
        for (BlockPos blockPos : BlockPos.func_191531_b(\u26032, 0, \u26033, \u26032 + 15, 0, \u26033 + 15)) {
            int n;
            if (\u26036 > 0) {
                for (n = \u26036; n >= \u26036 - 4; --n) {
                    if (n < \u26036 - random.nextInt(5)) continue;
                    iChunk.func_177436_a(mutable.func_181079_c(blockPos.func_177958_n(), n, blockPos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
            if (\u26035 >= 256) continue;
            for (n = \u26035 + 4; n >= \u26035; --n) {
                if (n > \u26035 + random.nextInt(5)) continue;
                iChunk.func_177436_a(mutable.func_181079_c(blockPos.func_177958_n(), n, blockPos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    @Override
    public void func_222537_b(IWorld iWorld, IChunk iChunk2) {
        IChunk iChunk2;
        Object \u26037;
        ChunkPos \u26035;
        Object \u260310;
        int n = this.func_222530_f();
        ObjectArrayList \u26032 = new ObjectArrayList(10);
        ObjectArrayList \u26033 = new ObjectArrayList(32);
        ChunkPos \u26034 = iChunk2.func_76632_l();
        \u2603 = \u26034.field_77276_a;
        \u2603 = \u26034.field_77275_b;
        \u2603 = \u2603 << 4;
        \u2603 = \u2603 << 4;
        for (Structure<?> structure : Feature.field_214488_aQ) {
            \u260310 = structure.func_143025_a();
            \u260311 = iChunk2.func_201578_b((String)\u260310).iterator();
            while (\u260311.hasNext()) {
                long l = \u260311.nextLong();
                \u26035 = new ChunkPos(l);
                IChunk \u26036 = iWorld.func_212866_a_(\u26035.field_77276_a, \u26035.field_77275_b);
                \u26037 = \u26036.func_201585_a((String)\u260310);
                if (\u26037 == null || !((StructureStart)\u26037).func_75069_d()) continue;
                for (StructurePiece structurePiece : ((StructureStart)\u26037).func_186161_c()) {
                    if (!structurePiece.func_214810_a(\u26034, 12) || !(structurePiece instanceof AbstractVillagePiece)) continue;
                    AbstractVillagePiece abstractVillagePiece = (AbstractVillagePiece)structurePiece;
                    JigsawPattern.PlacementBehaviour \u26038 = abstractVillagePiece.func_214826_b().func_214854_c();
                    if (\u26038 == JigsawPattern.PlacementBehaviour.RIGID) {
                        \u26032.add((Object)abstractVillagePiece);
                    }
                    for (JigsawJunction jigsawJunction : abstractVillagePiece.func_214829_e()) {
                        int n2 = jigsawJunction.func_214895_a();
                        \u2603 = jigsawJunction.func_214893_c();
                        if (n2 <= \u2603 - 12 || \u2603 <= \u2603 - 12 || n2 >= \u2603 + 15 + 12 || \u2603 >= \u2603 + 15 + 12) continue;
                        \u26033.add((Object)jigsawJunction);
                    }
                }
            }
        }
        double[][][] dArray = new double[2][this.field_222567_n + 1][this.field_222566_m + 1];
        for (int i = 0; i < this.field_222567_n + 1; ++i) {
            dArray[0][i] = new double[this.field_222566_m + 1];
            this.func_222548_a(dArray[0][i], \u2603 * this.field_222565_l, \u2603 * this.field_222567_n + i);
            dArray[1][i] = new double[this.field_222566_m + 1];
        }
        ChunkPrimer \u26039 = (ChunkPrimer)iChunk2;
        \u260310 = \u26039.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Object \u260311 = \u26039.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable \u260312 = new BlockPos.Mutable();
        ObjectListIterator \u260313 = \u26032.iterator();
        \u26035 = \u26033.iterator();
        for (int i = 0; i < this.field_222565_l; ++i) {
            for (\u2603 = 0; \u2603 < this.field_222567_n + 1; ++\u2603) {
                this.func_222548_a(dArray[1][\u2603], \u2603 * this.field_222565_l + i + 1, \u2603 * this.field_222567_n + \u2603);
            }
            for (\u2603 = 0; \u2603 < this.field_222567_n; ++\u2603) {
                ChunkSection chunkSection = \u26039.func_217332_a(15);
                chunkSection.func_222635_a();
                for (int j = this.field_222566_m - 1; j >= 0; --j) {
                    double d = dArray[0][\u2603][j];
                    \u2603 = dArray[0][\u2603 + 1][j];
                    \u2603 = dArray[1][\u2603][j];
                    \u2603 = dArray[1][\u2603 + 1][j];
                    \u2603 = dArray[0][\u2603][j + 1];
                    \u2603 = dArray[0][\u2603 + 1][j + 1];
                    \u2603 = dArray[1][\u2603][j + 1];
                    \u2603 = dArray[1][\u2603 + 1][j + 1];
                    for (int k = this.field_222563_j - 1; k >= 0; --k) {
                        \u2603 = j * this.field_222563_j + k;
                        \u2603 = \u2603 & 0xF;
                        \u2603 = \u2603 >> 4;
                        if (chunkSection.func_222632_g() >> 4 != \u2603) {
                            chunkSection.func_222637_b();
                            chunkSection = \u26039.func_217332_a(\u2603);
                            chunkSection.func_222635_a();
                        }
                        double \u260314 = (double)k / (double)this.field_222563_j;
                        double \u260315 = MathHelper.func_219803_d(\u260314, d, \u2603);
                        double \u260316 = MathHelper.func_219803_d(\u260314, \u2603, \u2603);
                        double \u260317 = MathHelper.func_219803_d(\u260314, \u2603, \u2603);
                        double \u260318 = MathHelper.func_219803_d(\u260314, \u2603, \u2603);
                        for (\u2603 = 0; \u2603 < this.field_222564_k; ++\u2603) {
                            \u2603 = \u2603 + i * this.field_222564_k + \u2603;
                            \u2603 = \u2603 & 0xF;
                            double d2 = (double)\u2603 / (double)this.field_222564_k;
                            \u2603 = MathHelper.func_219803_d(d2, \u260315, \u260316);
                            \u2603 = MathHelper.func_219803_d(d2, \u260317, \u260318);
                            for (int i2 = 0; i2 < this.field_222564_k; ++i2) {
                                int \u260321;
                                int \u260320;
                                \u2603 = \u2603 + \u2603 * this.field_222564_k + i2;
                                \u2603 = \u2603 & 0xF;
                                double d3 = (double)i2 / (double)this.field_222564_k;
                                \u2603 = MathHelper.func_219803_d(d3, \u2603, \u2603);
                                \u2603 = MathHelper.func_151237_a(\u2603 / 200.0, -1.0, 1.0);
                                \u2603 = \u2603 / 2.0 - \u2603 * \u2603 * \u2603 / 24.0;
                                while (\u260313.hasNext()) {
                                    Object object = (AbstractVillagePiece)\u260313.next();
                                    MutableBoundingBox \u260319 = ((StructurePiece)object).func_74874_b();
                                    \u260320 = Math.max(0, Math.max(\u260319.field_78897_a - \u2603, \u2603 - \u260319.field_78893_d));
                                    \u260321 = \u2603 - (\u260319.field_78895_b + ((AbstractVillagePiece)object).func_214830_d());
                                    int \u260322 = Math.max(0, Math.max(\u260319.field_78896_c - \u2603, \u2603 - \u260319.field_78892_f));
                                    \u2603 += NoiseChunkGenerator.func_222556_a(\u260320, \u260321, \u260322) * 0.8;
                                }
                                \u260313.back(\u26032.size());
                                while (\u26035.hasNext()) {
                                    object = (JigsawJunction)\u26035.next();
                                    int \u260323 = \u2603 - ((JigsawJunction)object).func_214895_a();
                                    \u260320 = \u2603 - ((JigsawJunction)object).func_214896_b();
                                    \u260321 = \u2603 - ((JigsawJunction)object).func_214893_c();
                                    \u2603 += NoiseChunkGenerator.func_222556_a(\u260323, \u260320, \u260321) * 0.4;
                                }
                                \u26035.back(\u26033.size());
                                object = \u2603 > 0.0 ? this.field_222559_f : (\u2603 < n ? this.field_222560_g : field_222562_i);
                                if (object == field_222562_i) continue;
                                if (((BlockState)object).func_185906_d() != 0) {
                                    \u260312.func_181079_c(\u2603, \u2603, \u2603);
                                    \u26039.func_201637_h(\u260312);
                                }
                                chunkSection.func_177484_a(\u2603, \u2603, \u2603, (BlockState)object, false);
                                ((Heightmap)\u260310).func_202270_a(\u2603, \u2603, \u2603, (BlockState)object);
                                ((Heightmap)\u260311).func_202270_a(\u2603, \u2603, \u2603, (BlockState)object);
                            }
                        }
                    }
                }
                chunkSection.func_222637_b();
            }
            \u26037 = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = (double[][])\u26037;
        }
    }

    private static double func_222556_a(int n, int n2, int n3) {
        \u2603 = n + 12;
        \u2603 = n2 + 12;
        \u2603 = n3 + 12;
        if (\u2603 < 0 || \u2603 >= 24) {
            return 0.0;
        }
        if (\u2603 < 0 || \u2603 >= 24) {
            return 0.0;
        }
        if (\u2603 < 0 || \u2603 >= 24) {
            return 0.0;
        }
        return field_222561_h[\u2603 * 24 * 24 + \u2603 * 24 + \u2603];
    }

    private static double func_222554_b(int n, int n2, int n3) {
        double d = n * n + n3 * n3;
        \u2603 = (double)n2 + 0.5;
        \u2603 = \u2603 * \u2603;
        \u2603 = Math.pow(Math.E, -(\u2603 / 16.0 + d / 16.0));
        \u2603 = -\u2603 * MathHelper.func_181161_i(\u2603 / 2.0 + d / 2.0) / 2.0;
        return \u2603 * \u2603;
    }
}

