/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.RegionFileCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IOWorker
implements AutoCloseable {
    private static final Logger field_227080_a_ = LogManager.getLogger();
    private final Thread field_227081_b_;
    private final AtomicBoolean field_227082_c_ = new AtomicBoolean();
    private final Queue<Runnable> field_227083_d_ = Queues.newConcurrentLinkedQueue();
    private final RegionFileCache field_227084_e_;
    private final Map<ChunkPos, Entry> field_227085_f_ = Maps.newLinkedHashMap();
    private boolean field_227086_g_ = true;
    private CompletableFuture<Void> field_227087_h_ = new CompletableFuture();

    IOWorker(RegionFileCache regionFileCache, String string) {
        this.field_227084_e_ = regionFileCache;
        this.field_227081_b_ = new Thread(this::func_227107_d_);
        this.field_227081_b_.setName(string + " IO worker");
        this.field_227081_b_.start();
    }

    public CompletableFuture<Void> func_227093_a_(ChunkPos chunkPos, CompoundNBT compoundNBT) {
        return this.func_227099_a_(completableFuture -> () -> {
            Entry entry = this.field_227085_f_.computeIfAbsent(chunkPos, chunkPos -> new Entry());
            entry.field_227113_a_ = compoundNBT;
            entry.field_227114_b_.whenComplete((void_, throwable) -> {
                if (throwable != null) {
                    completableFuture.completeExceptionally((Throwable)throwable);
                } else {
                    completableFuture.complete(null);
                }
            });
        });
    }

    @Nullable
    public CompoundNBT func_227090_a_(ChunkPos chunkPos) throws IOException {
        CompletableFuture completableFuture2 = this.func_227099_a_(completableFuture -> () -> {
            Entry entry = this.field_227085_f_.get(chunkPos);
            if (entry != null) {
                completableFuture.complete(entry.field_227113_a_);
            } else {
                try {
                    CompoundNBT compoundNBT = this.field_227084_e_.func_219099_e(chunkPos);
                    completableFuture.complete(compoundNBT);
                }
                catch (Exception exception) {
                    field_227080_a_.warn("Failed to read chunk {}", (Object)chunkPos, (Object)exception);
                    completableFuture.completeExceptionally(exception);
                }
            }
        });
        try {
            return (CompoundNBT)completableFuture2.join();
        }
        catch (CompletionException \u26032) {
            if (\u26032.getCause() instanceof IOException) {
                throw (IOException)\u26032.getCause();
            }
            throw \u26032;
        }
    }

    private CompletableFuture<Void> func_227100_b_() {
        return this.func_227099_a_(completableFuture -> () -> {
            this.field_227086_g_ = false;
            this.field_227087_h_ = completableFuture;
        });
    }

    public CompletableFuture<Void> func_227088_a_() {
        return this.func_227099_a_(completableFuture -> () -> {
            CompletableFuture<Void> completableFuture2 = CompletableFuture.allOf((CompletableFuture[])this.field_227085_f_.values().stream().map(entry -> ((Entry)entry).field_227114_b_).toArray(CompletableFuture[]::new));
            completableFuture2.whenComplete((object, throwable) -> completableFuture.complete(null));
        });
    }

    private <T> CompletableFuture<T> func_227099_a_(Function<CompletableFuture<T>, Runnable> function) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.field_227083_d_.add(function.apply(completableFuture));
        LockSupport.unpark(this.field_227081_b_);
        return completableFuture;
    }

    private void func_227105_c_() {
        LockSupport.park("waiting for tasks");
    }

    private void func_227107_d_() {
        try {
            while (this.field_227086_g_) {
                boolean bl = this.func_227112_h_();
                \u2603 = this.func_227109_e_();
                if (bl || \u2603) continue;
                this.func_227105_c_();
            }
            this.func_227112_h_();
            this.func_227110_f_();
        }
        finally {
            this.func_227111_g_();
        }
    }

    private boolean func_227109_e_() {
        Iterator<Map.Entry<ChunkPos, Entry>> iterator = this.field_227085_f_.entrySet().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Map.Entry<ChunkPos, Entry> \u26032 = iterator.next();
        iterator.remove();
        this.func_227091_a_(\u26032.getKey(), \u26032.getValue());
        return true;
    }

    private void func_227110_f_() {
        this.field_227085_f_.forEach(this::func_227091_a_);
        this.field_227085_f_.clear();
    }

    private void func_227091_a_(ChunkPos chunkPos, Entry entry) {
        try {
            this.field_227084_e_.func_219100_a(chunkPos, entry.field_227113_a_);
            entry.field_227114_b_.complete(null);
        }
        catch (Exception exception) {
            field_227080_a_.error("Failed to store chunk {}", (Object)chunkPos, (Object)exception);
            entry.field_227114_b_.completeExceptionally(exception);
        }
    }

    private void func_227111_g_() {
        try {
            this.field_227084_e_.close();
            this.field_227087_h_.complete(null);
        }
        catch (Exception exception) {
            field_227080_a_.error("Failed to close storage", (Throwable)exception);
            this.field_227087_h_.completeExceptionally(exception);
        }
    }

    private boolean func_227112_h_() {
        boolean bl = false;
        while ((\u2603 = this.field_227083_d_.poll()) != null) {
            bl = true;
            \u2603.run();
        }
        return bl;
    }

    @Override
    public void close() throws IOException {
        if (!this.field_227082_c_.compareAndSet(false, true)) {
            return;
        }
        try {
            this.func_227100_b_().join();
        }
        catch (CompletionException completionException) {
            if (completionException.getCause() instanceof IOException) {
                throw (IOException)completionException.getCause();
            }
            throw completionException;
        }
    }

    static class Entry {
        private CompoundNBT field_227113_a_;
        private final CompletableFuture<Void> field_227114_b_ = new CompletableFuture();

        private Entry() {
        }
    }
}

