/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import com.google.common.collect.AbstractIterator;
import doggytalents.common.util.RadialCoordinateIterator;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WorldUtil {
    public static Iterable<BlockPos> getAllInBoxMutable(final int x1, final int y1, final int z1, final int x2, final int y2, final int z2) {
        return () -> new AbstractIterator<BlockPos>(){
            final RadialCoordinateIterator coordinateIterator;
            final BlockPos.Mutable mutablePos;
            {
                this.coordinateIterator = new RadialCoordinateIterator(x1, y1, z1, x2, y2, z2);
                this.mutablePos = new BlockPos.Mutable();
            }

            protected BlockPos computeNext() {
                return this.coordinateIterator.hasNext() ? this.mutablePos.func_181079_c(this.coordinateIterator.getX(), this.coordinateIterator.getY(), this.coordinateIterator.getZ()) : (BlockPos)this.endOfData();
            }
        };
    }

    @Nullable
    public static <T extends TileEntity> T getTileEntity(IBlockReader worldIn, BlockPos posIn, Class<T> type) {
        TileEntity tileEntity = worldIn.func_175625_s(posIn);
        if (tileEntity != null && tileEntity.getClass().isAssignableFrom(type)) {
            return (T)tileEntity;
        }
        return null;
    }

    @Nullable
    public static <T extends Entity> T getCachedEntity(World worldIn, Class<T> type, @Nullable T cached, @Nullable UUID uuid) {
        if ((cached == null || cached.field_70128_L) && uuid != null && worldIn instanceof ServerWorld) {
            Entity entity = ((ServerWorld)worldIn).func_217461_a(uuid);
            if (entity != null && entity.getClass().isAssignableFrom(type)) {
                return (T)entity;
            }
            return null;
        }
        return cached;
    }

    public static Optional<BlockPos> toImmutable(BlockPos pos) {
        return pos != null ? Optional.of(pos.func_185334_h()) : Optional.empty();
    }

    public static Optional<BlockPos> toImmutable(Optional<BlockPos> pos) {
        return pos.map(BlockPos::func_185334_h);
    }
}

