/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyTalents2;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NBTUtil {
    public static void putUniqueId(CompoundNBT compound, String key, @Nullable UUID uuid) {
        if (uuid != null) {
            compound.func_186854_a(key, uuid);
        }
    }

    @Nullable
    public static UUID getUniqueId(CompoundNBT compound, String key) {
        if (compound.func_186855_b(key)) {
            return compound.func_186857_a(key);
        }
        return null;
    }

    public static void putResourceLocation(CompoundNBT compound, String key, @Nullable ResourceLocation rl) {
        if (rl != null) {
            compound.func_74778_a(key, rl.toString());
        }
    }

    @Nullable
    public static ResourceLocation getResourceLocation(CompoundNBT compound, String key) {
        if (compound.func_150297_b(key, 8)) {
            return ResourceLocation.func_208304_a((String)compound.func_74779_i(key));
        }
        return null;
    }

    @Nullable
    public static void putVec3d(CompoundNBT compound, @Nullable Vec3d vec3d) {
        if (vec3d != null) {
            compound.func_74780_a("x", vec3d.func_82615_a());
            compound.func_74780_a("y", vec3d.func_82617_b());
            compound.func_74780_a("z", vec3d.func_82616_c());
        }
    }

    @Nullable
    public static Vec3d getVec3d(CompoundNBT compound) {
        if (compound.func_150297_b("x", 99) && compound.func_150297_b("y", 99) && compound.func_150297_b("z", 99)) {
            return new Vec3d(compound.func_74769_h("x"), compound.func_74769_h("y"), compound.func_74769_h("z"));
        }
        return null;
    }

    public static void putTextComponent(CompoundNBT compound, String key, @Nullable ITextComponent component) {
        if (component != null) {
            compound.func_74778_a(key, ITextComponent.Serializer.func_150696_a((ITextComponent)component));
        }
    }

    @Nullable
    public static ITextComponent getTextComponent(CompoundNBT compound, String key) {
        if (compound.func_150297_b(key, 8)) {
            return ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i(key));
        }
        return null;
    }

    @Nullable
    public static <T extends IForgeRegistryEntry<T>> T getRegistryValue(CompoundNBT compound, String key, IForgeRegistry<T> registry) {
        ResourceLocation rl = NBTUtil.getResourceLocation(compound, key);
        if (rl != null) {
            if (registry.containsKey(rl)) {
                return (T)registry.getValue(rl);
            }
            DoggyTalents2.LOGGER.warn("Unable to load registry value in registry {} with resource location {}", (Object)registry.getRegistryName(), (Object)rl);
        } else {
            DoggyTalents2.LOGGER.warn("Unable to load resource location in NBT:{}, for {} registry", (Object)key, (Object)registry.getRegistryName());
        }
        return null;
    }

    public static <T extends IForgeRegistryEntry<T>> void putRegistryValue(CompoundNBT compound, String key, T value) {
        if (value != null) {
            NBTUtil.putResourceLocation(compound, key, value.getRegistryName());
        }
    }

    public static void putBlockPos(CompoundNBT compound, @Nullable BlockPos vec3d) {
        if (vec3d != null) {
            compound.func_74768_a("x", vec3d.func_177958_n());
            compound.func_74768_a("y", vec3d.func_177956_o());
            compound.func_74768_a("z", vec3d.func_177952_p());
        }
    }

    @Nullable
    public static BlockPos getBlockPos(CompoundNBT compound) {
        if (compound.func_150297_b("x", 99) && compound.func_150297_b("y", 99) && compound.func_150297_b("z", 99)) {
            return new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
        }
        return null;
    }

    public static void putBlockPos(CompoundNBT compound, String key, Optional<BlockPos> vec3d) {
        if (vec3d.isPresent()) {
            CompoundNBT posNBT = new CompoundNBT();
            NBTUtil.putBlockPos(posNBT, vec3d.get());
            compound.func_218657_a(key, (INBT)posNBT);
        }
    }

    public static Optional<BlockPos> getBlockPos(CompoundNBT compound, String key) {
        if (compound.func_150297_b(key, 10)) {
            return Optional.of(NBTUtil.getBlockPos(compound.func_74775_l(key)));
        }
        return Optional.empty();
    }

    public static void putBlockPos(CompoundNBT compound, String key, @Nullable BlockPos vec3d) {
        if (vec3d != null) {
            CompoundNBT posNBT = new CompoundNBT();
            NBTUtil.putBlockPos(posNBT, vec3d);
            compound.func_218657_a(key, (INBT)posNBT);
        }
    }

    public static void writeItemStack(CompoundNBT compound, String key, ItemStack stackIn) {
        if (!stackIn.func_190926_b()) {
            compound.func_218657_a(key, (INBT)stackIn.func_77955_b(new CompoundNBT()));
        }
    }

    @Nonnull
    public static ItemStack readItemStack(CompoundNBT compound, String key) {
        if (compound.func_150297_b(key, 10)) {
            return ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l(key));
        }
        return ItemStack.field_190927_a;
    }

    public static Optional<DimensionType> readDimensionType(CompoundNBT compound, String key) {
        ResourceLocation loc = NBTUtil.getResourceLocation(compound, key);
        return Registry.field_212622_k.func_218349_b(loc);
    }
}

