/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.feature.FoodHandler;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.inferface.IDogFoodHandler;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryUtil {
    public static boolean feedDogFrom(AbstractDogEntity dogIn, @Nullable Entity entity, IItemHandlerModifiable source) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stack = source.getStackInSlot(i).func_77946_l();
            Optional<IDogFoodHandler> foodHandler = FoodHandler.getMatch(dogIn, stack, entity);
            if (!foodHandler.isPresent()) continue;
            boolean response = foodHandler.get().consume(dogIn, stack, entity);
            source.setStackInSlot(i, stack);
            return response;
        }
        return false;
    }

    public static Pair<ItemStack, Integer> findStack(IItemHandler source, Predicate<ItemStack> searchCriteria) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stack = source.getStackInSlot(i);
            if (!searchCriteria.test(stack)) continue;
            return Pair.of((Object)stack.func_77946_l(), (Object)i);
        }
        return null;
    }

    public static void transferStacks(IItemHandlerModifiable source, IItemHandler target) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stack = source.getStackInSlot(i);
            source.setStackInSlot(i, InventoryUtil.addItem(target, stack));
        }
    }

    public static ItemStack addItem(IItemHandler target, ItemStack remaining) {
        for (int i = 0; i < target.getSlots(); ++i) {
            if (target.isItemValid(i, remaining)) {
                remaining = target.insertItem(i, remaining, false);
            }
            if (remaining.func_190926_b()) break;
        }
        return remaining;
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inv.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }
}

