/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import java.util.Comparator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;

public class EntityUtil {
    public static double getFollowRange(LivingEntity entityIn) {
        IAttributeInstance rangeAttribute = entityIn.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return rangeAttribute == null ? 16.0 : rangeAttribute.func_111126_e();
    }

    public static boolean tryToTeleportNearEntity(LivingEntity entityIn, PathNavigator navigator, LivingEntity target, int radius) {
        return EntityUtil.tryToTeleportNearEntity(entityIn, navigator, new BlockPos((Entity)target), radius);
    }

    public static boolean tryToTeleportNearEntity(LivingEntity entityIn, PathNavigator navigator, BlockPos targetPos, int radius) {
        for (int i = 0; i < 10; ++i) {
            int j = EntityUtil.getRandomNumber(entityIn, -radius, radius);
            int k = EntityUtil.getRandomNumber(entityIn, -1, 1);
            int l = EntityUtil.getRandomNumber(entityIn, -radius, radius);
            boolean flag = EntityUtil.tryToTeleportToLocation(entityIn, navigator, targetPos, targetPos.func_177958_n() + j, targetPos.func_177956_o() + k, targetPos.func_177952_p() + l);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean tryToTeleportToLocation(LivingEntity entityIn, PathNavigator navigator, BlockPos targetPos, int x, int y, int z) {
        if ((double)Math.abs(x - targetPos.func_177958_n()) < 2.0 && (double)Math.abs(z - targetPos.func_177952_p()) < 2.0) {
            return false;
        }
        if (!EntityUtil.isTeleportFriendlyBlock(entityIn, new BlockPos(x, y, z), false)) {
            return false;
        }
        entityIn.func_70012_b((double)((float)x + 0.5f), (double)y, (double)((float)z + 0.5f), entityIn.field_70177_z, entityIn.field_70125_A);
        navigator.func_75499_g();
        return true;
    }

    private static boolean isTeleportFriendlyBlock(LivingEntity entityIn, BlockPos pos, boolean teleportToLeaves) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_227480_b_((IBlockReader)entityIn.field_70170_p, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        if (pathnodetype != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = entityIn.field_70170_p.func_180495_p(pos.func_177977_b());
        if (!teleportToLeaves && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.func_177973_b((Vec3i)new BlockPos((Entity)entityIn));
        return entityIn.field_70170_p.func_226665_a__((Entity)entityIn, entityIn.func_174813_aQ().func_186670_a(blockpos));
    }

    public static int getRandomNumber(LivingEntity entityIn, int minIn, int maxIn) {
        return entityIn.func_70681_au().nextInt(maxIn - minIn + 1) + minIn;
    }

    public static boolean isHolding(@Nullable Entity entity, Item item, Predicate<CompoundNBT> nbtPredicate) {
        return EntityUtil.isHolding(entity, (ItemStack stack) -> stack.func_77973_b() == item && stack.func_77942_o() && nbtPredicate.test(stack.func_77978_p()));
    }

    public static boolean isHolding(@Nullable Entity entity, Item item) {
        return EntityUtil.isHolding(entity, (ItemStack stack) -> stack.func_77973_b() == item);
    }

    public static boolean isHolding(@Nullable Entity entity, Predicate<ItemStack> matcher) {
        if (entity == null) {
            return false;
        }
        for (ItemStack stack : entity.func_184214_aD()) {
            if (!matcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Entity> T getClosestTo(Entity center, Iterable<T> entities) {
        return EntityUtil.getClosestTo(center.func_213303_ch(), entities);
    }

    public static <T extends Entity> T getClosestTo(Vec3d posVec, Iterable<T> entities) {
        double smallestDist = Double.MAX_VALUE;
        Entity closest = null;
        for (Entity entity : entities) {
            double distance = posVec.func_72436_e(entity.func_213303_ch());
            if (!(distance < smallestDist)) continue;
            closest = entity;
            smallestDist = distance;
        }
        return (T)closest;
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Vec3d vec3d;

        public Sorter(Entity entityIn) {
            this.vec3d = entityIn.func_213303_ch();
        }

        public Sorter(Vec3d vec3d) {
            this.vec3d = vec3d;
        }

        @Override
        public int compare(Entity entity1, Entity entity2) {
            double d0 = this.vec3d.func_72436_e(entity1.func_213303_ch());
            double d1 = this.vec3d.func_72436_e(entity2.func_213303_ch());
            return Double.compare(d0, d1);
        }
    }
}

