/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyBlocks;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.util.NBTUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedUtil {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    public static void setBedVariant(DogBedTileEntity dogBedTileEntity, ItemStack stack) {
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        dogBedTileEntity.setCasing((ICasingMaterial)((Object)materials.getLeft()));
        dogBedTileEntity.setBedding((IBeddingMaterial)((Object)materials.getRight()));
    }

    public static ItemStack createRandomBed() {
        ICasingMaterial casing = DogBedUtil.pickRandom(DoggyTalentsAPI.CASING_MATERIAL);
        IBeddingMaterial bedding = DogBedUtil.pickRandom(DoggyTalentsAPI.BEDDING_MATERIAL);
        return DogBedUtil.createItemStack(casing, bedding);
    }

    public static Pair<ICasingMaterial, IBeddingMaterial> getMaterials(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("doggytalents");
        if (tag != null) {
            ICasingMaterial casingId = NBTUtil.getRegistryValue(tag, "casingId", DoggyTalentsAPI.CASING_MATERIAL);
            IBeddingMaterial beddingId = NBTUtil.getRegistryValue(tag, "beddingId", DoggyTalentsAPI.BEDDING_MATERIAL);
            return Pair.of((Object)((Object)casingId), (Object)((Object)beddingId));
        }
        return Pair.of(null, null);
    }

    public static ItemStack createItemStack(ICasingMaterial casingId, IBeddingMaterial beddingId) {
        ItemStack stack = new ItemStack((IItemProvider)DoggyBlocks.DOG_BED.get(), 1);
        CompoundNBT tag = stack.func_190925_c("doggytalents");
        NBTUtil.putRegistryValue(tag, "casingId", casingId);
        NBTUtil.putRegistryValue(tag, "beddingId", beddingId);
        return stack;
    }

    public static ICasingMaterial getCasingFromStack(IForgeRegistry<ICasingMaterial> registry, ItemStack stack) {
        for (ICasingMaterial m : registry.getValues()) {
            if (!m.getIngredient().test(stack)) continue;
            return m;
        }
        return null;
    }

    public static IBeddingMaterial getBeddingFromStack(IForgeRegistry<IBeddingMaterial> registry, ItemStack stack) {
        for (IBeddingMaterial m : registry.getValues()) {
            if (!m.getIngredient().test(stack)) continue;
            return m;
        }
        return null;
    }

    public static <T extends IForgeRegistryEntry<T>> T pickRandom(IForgeRegistry<T> registry) {
        Collection values = registry.getValues();
        List list = values instanceof List ? (List)values : new ArrayList(values);
        return (T)((IForgeRegistryEntry)list.get(RANDOM.nextInt(list.size())));
    }
}

