/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.DoggyTalents2;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.accessory.Band;
import doggytalents.common.entity.accessory.Clothing;
import doggytalents.common.entity.accessory.Collar;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.accessory.Glasses;
import doggytalents.common.entity.serializers.DimensionDependantArg;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.Util;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BackwardsComp {
    public static final ResourceLocation DOGGY_BEAM = Util.getResource("attackbeam");
    public static final ResourceLocation COMMAND_EMBLEM = Util.getResource("command_emblem");
    private static Map<String, String> OLD_NEW_BED = Maps.newHashMap();
    private static Map<String, Supplier<? extends Talent>> OLD_NEW_TALENT = Maps.newHashMap();

    public static Optional<String> getBedMaterialMapping(String oldId) {
        return Optional.ofNullable(OLD_NEW_BED.get(oldId));
    }

    public static Optional<Supplier<? extends Talent>> getTalentMap(String oldId) {
        return Optional.ofNullable(OLD_NEW_TALENT.get(oldId));
    }

    public static void readTalentMapping(CompoundNBT compound, List<TalentInstance> talentMap) {
        block4: {
            block3: {
                if (!compound.func_150297_b("talents", 8)) break block3;
                String[] split = compound.func_74779_i("talents").split(":");
                if (split.length <= 0 || split.length % 2 != 0) break block4;
                for (int i = 0; i < split.length; i += 2) {
                    int levelIndex = i + 1;
                    BackwardsComp.getTalentMap(split[i]).ifPresent(talent -> {
                        int level = 0;
                        try {
                            level = Integer.valueOf(split[levelIndex]);
                        }
                        catch (Exception e) {
                            return;
                        }
                        if (talent != null) {
                            talentMap.add(((Talent)((Object)((Object)talent.get()))).getDefault(level));
                        }
                    });
                }
                break block4;
            }
            if (compound.func_150297_b("talent_level_list", 9)) {
                ListNBT list = compound.func_150295_c("talent_level_list", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT talentCompound = list.func_150305_b(i);
                    Talent talent2 = NBTUtil.getRegistryValue(talentCompound, "talent", DoggyTalentsAPI.TALENTS);
                    if (talent2 == null) continue;
                    int level = talentCompound.func_74762_e("level");
                    talentMap.add(talent2.getDefault(level));
                }
            }
        }
    }

    public static void readAccessories(CompoundNBT compound, List<AccessoryInstance> accessories) {
        int value;
        if (compound.func_150297_b("radioCollar", 1) && compound.func_74767_n("radioCollar")) {
            accessories.add(((Band)DoggyAccessories.RADIO_BAND.get()).getDefault());
        }
        if (compound.func_150297_b("sunglasses", 1) && compound.func_74767_n("sunglasses")) {
            accessories.add(((Glasses)DoggyAccessories.SUNGLASSES.get()).getDefault());
        }
        if (compound.func_150297_b("capeData", 99)) {
            value = compound.func_74762_e("capeData");
            if (value >= 0) {
                accessories.add(((DyeableAccessory)DoggyAccessories.DYEABLE_CAPE.get()).create(value));
            } else if (value >= -1) {
                accessories.add(((DyeableAccessory)DoggyAccessories.DYEABLE_CAPE.get()).getDefault());
            } else if (value == -3) {
                accessories.add(((Clothing)DoggyAccessories.CAPE.get()).getDefault());
            } else if (value == -4) {
                accessories.add(((Clothing)DoggyAccessories.LEATHER_JACKET_CLOTHING.get()).getDefault());
            }
        }
        if (compound.func_150297_b("collarColour", 99)) {
            value = compound.func_74762_e("collarColour");
            if (value >= 0) {
                accessories.add(((DyeableAccessory)DoggyAccessories.DYEABLE_COLLAR.get()).create(value));
            } else if (value >= -1) {
                accessories.add(((DyeableAccessory)DoggyAccessories.DYEABLE_COLLAR.get()).getDefault());
            } else if (value == -3) {
                accessories.add(((Collar)DoggyAccessories.GOLDEN_COLLAR.get()).getDefault());
            } else if (value == -4) {
                accessories.add(((Collar)DoggyAccessories.SPOTTED_COLLAR.get()).getDefault());
            } else if (value == -5) {
                accessories.add(((Collar)DoggyAccessories.MULTICOLORED_COLLAR.get()).getDefault());
            }
        }
    }

    public static void readMode(CompoundNBT compound, Consumer<EnumMode> consumer) {
        consumer.accept(EnumMode.byIndex(compound.func_74762_e("mode")));
    }

    public static void readDogTexture(CompoundNBT compound, Consumer<String> consumer) {
        if (compound.func_150297_b("doggyTex", 99)) {
            int value = compound.func_74762_e("doggyTex");
            String[] textures = new String[]{"bad647ebc2ac822563eaedaa3cb64881d8d7fd24", "c22b2f6d7a902c13d2f9c377f360127b6ae2dd65", "bea8cace65c013ca9cdae76b0664f4176502e4fb", "df167655cf5db4147e28d6920862636ce94c22cd", "b82d3e99a8ef342fbdc5f5a3f6c91b3940f80f55", "84426b389b050105b2cc8883a28e21ded8502d15", "7281214e5b1c928e124de44af6040d34100ef11e", "7229d8e7b8e5a291d2d8edb7082e43974bc409f9", "40cde1ba3ab392860432d00042dde4ea5ae2accd", "7a50feaf4e5d9a332946afa66731430282adaf06", "9846a3d8b29589e2ed125b5ce8b8fe398ee4b389", "62b05471528c8268c5de6ec514ba801eea812e99", "9a6c7833aebe88d09e2c4807cf9ab7b2107ce23b", "b4b0b25d37c7790b886e5feafcc794e13d801d2f", "08bf1e51a9a64e1b82518360c05fddd711ba0071"};
            if (value >= 0 && value < textures.length) {
                consumer.accept(textures[value]);
            }
        }
    }

    public static void readHasBone(CompoundNBT compound, Consumer<ItemStack> consumer) {
        if (compound.func_150297_b("hasBone", 1) && compound.func_74767_n("hasBone")) {
            int variant = compound.func_74762_e("boneVariant");
            if (variant == 0) {
                consumer.accept(new ItemStack((IItemProvider)DoggyItems.THROW_BONE.get()));
            } else if (variant == 1) {
                consumer.accept(new ItemStack((IItemProvider)DoggyItems.THROW_STICK.get()));
            }
        }
    }

    public static void readBowlLocations(CompoundNBT compound, DimensionDependantArg<Optional<BlockPos>> bowlsData) {
        if (compound.func_150297_b("bowlPosX", 99)) {
            bowlsData.put(DimensionType.field_223227_a_, Optional.of(new BlockPos(compound.func_74762_e("bowlPosX"), compound.func_74762_e("bowlPosY"), compound.func_74762_e("bowlPosZ"))));
        }
    }

    public static void readBedLocations(CompoundNBT compound, DimensionDependantArg<Optional<BlockPos>> bedsData) {
        if (compound.func_150297_b("bedPosX", 99)) {
            bedsData.put(DimensionType.field_223227_a_, Optional.of(new BlockPos(compound.func_74762_e("bedPosX"), compound.func_74762_e("bedPosY"), compound.func_74762_e("bedPosZ"))));
        }
    }

    @SubscribeEvent
    public void remapMissingEntities(RegistryEvent.MissingMappings<EntityType<?>> event) {
        ImmutableList mappings = event.getAllMappings();
        if (mappings == null) {
            DoggyTalents2.LOGGER.warn("Failed to attempt to remap missing mapppings.");
            return;
        }
        mappings.forEach(mapping -> {
            if (Objects.equals(mapping.key, DOGGY_BEAM)) {
                mapping.remap(DoggyEntityTypes.DOG_BEAM.get());
                DoggyTalents2.LOGGER.debug("Remapped Dog Beam id");
            }
        });
    }

    @SubscribeEvent
    public void remapMissingItems(RegistryEvent.MissingMappings<Item> event) {
        ImmutableList mappings = event.getAllMappings();
        if (mappings == null) {
            DoggyTalents2.LOGGER.warn("Failed to attempt to remap missing mapppings.");
            return;
        }
        mappings.forEach(mapping -> {
            if (Objects.equals(mapping.key, COMMAND_EMBLEM)) {
                mapping.remap(DoggyItems.WHISTLE.get());
                DoggyTalents2.LOGGER.debug("Remapped Command Emblem to Whistle");
            }
        });
    }

    public static void putBeddingMapping(String current, String ... previous) {
        for (String old : previous) {
            OLD_NEW_BED.put(old, current);
        }
    }

    public static void init() {
        BackwardsComp.putBeddingMapping("minecraft:white_wool", "minecraft:wool.0", "minecraft_white_wool");
        BackwardsComp.putBeddingMapping("minecraft:orange_wool", "minecraft:wool.1", "minecraft_orange_wool");
        BackwardsComp.putBeddingMapping("minecraft:magenta_wool", "minecraft:wool.2", "minecraft_magenta_wool");
        BackwardsComp.putBeddingMapping("minecraft:light_blue_wool", "minecraft:wool.3", "minecraft_light_blue_wool");
        BackwardsComp.putBeddingMapping("minecraft:yellow_wool", "minecraft:wool.4", "minecraft_yellow_wool");
        BackwardsComp.putBeddingMapping("minecraft:lime_wool", "minecraft:wool.5", "minecraft_lime_wool");
        BackwardsComp.putBeddingMapping("minecraft:pink_wool", "minecraft:wool.6", "minecraft_pink_wool");
        BackwardsComp.putBeddingMapping("minecraft:gray_wool", "minecraft:wool.7", "minecraft_gray_wool");
        BackwardsComp.putBeddingMapping("minecraft:light_gray_wool", "minecraft:wool.8", "minecraft_light_gray_wool");
        BackwardsComp.putBeddingMapping("minecraft:cyan_wool", "minecraft:wool.9", "minecraft_cyan_wool");
        BackwardsComp.putBeddingMapping("minecraft:purple_wool", "minecraft:wool.10", "minecraft_purple_wool");
        BackwardsComp.putBeddingMapping("minecraft:blue_wool", "minecraft:wool.11", "minecraft_blue_wool");
        BackwardsComp.putBeddingMapping("minecraft:brown_wool", "minecraft:wool.12", "minecraft_brown_wool");
        BackwardsComp.putBeddingMapping("minecraft:green_wool", "minecraft:wool.13", "minecraft_green_wool");
        BackwardsComp.putBeddingMapping("minecraft:red_wool", "minecraft:wool.14", "minecraft_red_wool");
        BackwardsComp.putBeddingMapping("minecraft:black_wool", "minecraft:wool.15", "minecraft_black_wool");
        BackwardsComp.putBeddingMapping("minecraft:oak_planks", "minecraft:planks.0", "minecraft_oak_planks");
        BackwardsComp.putBeddingMapping("minecraft:spruce_planks", "minecraft:planks.1", "minecraft_spruce_planks");
        BackwardsComp.putBeddingMapping("minecraft:birch_planks", "minecraft:planks.2", "minecraft_birch_planks");
        BackwardsComp.putBeddingMapping("minecraft:jungle_planks", "minecraft:planks.3", "minecraft_jungle_planks");
        BackwardsComp.putBeddingMapping("minecraft:acacia_planks", "minecraft:planks.4", "minecraft_acacia_planks");
        BackwardsComp.putBeddingMapping("minecraft:dark_oak_planks", "minecraft:planks.5", "minecraft_dark_oak_planks");
        OLD_NEW_TALENT.put("bedfinder", (Supplier<? extends Talent>)DoggyTalents.BED_FINDER);
        OLD_NEW_TALENT.put("blackpelt", (Supplier<? extends Talent>)DoggyTalents.BLACK_PELT);
        OLD_NEW_TALENT.put("creepersweeper", (Supplier<? extends Talent>)DoggyTalents.CREEPER_SWEEPER);
        OLD_NEW_TALENT.put("doggydash", (Supplier<? extends Talent>)DoggyTalents.DOGGY_DASH);
        OLD_NEW_TALENT.put("fisherdog", (Supplier<? extends Talent>)DoggyTalents.FISHER_DOG);
        OLD_NEW_TALENT.put("guarddog", (Supplier<? extends Talent>)DoggyTalents.GUARD_DOG);
        OLD_NEW_TALENT.put("happyeater", (Supplier<? extends Talent>)DoggyTalents.HAPPY_EATER);
        OLD_NEW_TALENT.put("hellhound", (Supplier<? extends Talent>)DoggyTalents.HELL_HOUND);
        OLD_NEW_TALENT.put("hunterdog", (Supplier<? extends Talent>)DoggyTalents.HUNTER_DOG);
        OLD_NEW_TALENT.put("packpuppy", (Supplier<? extends Talent>)DoggyTalents.PACK_PUPPY);
        OLD_NEW_TALENT.put("pestfighter", (Supplier<? extends Talent>)DoggyTalents.PEST_FIGHTER);
        OLD_NEW_TALENT.put("pillowpaw", (Supplier<? extends Talent>)DoggyTalents.PILLOW_PAW);
        OLD_NEW_TALENT.put("poisonfang", (Supplier<? extends Talent>)DoggyTalents.POISON_FANG);
        OLD_NEW_TALENT.put("puppyeyes", (Supplier<? extends Talent>)DoggyTalents.PUPPY_EYES);
        OLD_NEW_TALENT.put("quickhealer", (Supplier<? extends Talent>)DoggyTalents.QUICK_HEALER);
        OLD_NEW_TALENT.put("rescuedog", (Supplier<? extends Talent>)DoggyTalents.RESCUE_DOG);
        OLD_NEW_TALENT.put("roaringgale", (Supplier<? extends Talent>)DoggyTalents.ROARING_GALE);
        OLD_NEW_TALENT.put("shepherddog", (Supplier<? extends Talent>)DoggyTalents.SHEPHERD_DOG);
        OLD_NEW_TALENT.put("swimmerdog", (Supplier<? extends Talent>)DoggyTalents.SWIMMER_DOG);
        OLD_NEW_TALENT.put("wolfmount", (Supplier<? extends Talent>)DoggyTalents.WOLF_MOUNT);
    }
}

