/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.feature.DataKey;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.util.EntityUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ShepherdDogTalent
extends TalentInstance {
    private static DataKey<EntityAIShepherdDog> SHEPHERD_AI = DataKey.make();

    public ShepherdDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDogEntity dogIn) {
        if (!dogIn.hasData(SHEPHERD_AI)) {
            EntityAIShepherdDog shepherdAI = new EntityAIShepherdDog(dogIn, 1.0, 8.0f, entity -> !(entity instanceof TameableEntity));
            dogIn.field_70714_bg.func_75776_a(7, (Goal)shepherdAI);
            dogIn.setData(SHEPHERD_AI, (Object)shepherdAI);
        }
    }

    public static int getMaxFollowers(int level) {
        switch (level) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
        }
        return 0;
    }

    public static class EntityAIShepherdDog
    extends Goal {
        protected final AbstractDogEntity dog;
        private final World world;
        private final double followSpeed;
        private final float maxDist;
        private final PathNavigator dogPathfinder;
        private final Predicate<ItemStack> holdingPred;
        private final Predicate<AnimalEntity> predicate;
        private final Comparator<Entity> sorter;
        private int timeToRecalcPath;
        private LivingEntity owner;
        protected List<AnimalEntity> targets;
        private float oldWaterCost;
        private int MAX_FOLLOW = 5;

        public EntityAIShepherdDog(AbstractDogEntity dogIn, double speedIn, float range, @Nullable Predicate<AnimalEntity> targetSelector) {
            this.dog = dogIn;
            this.world = dogIn.field_70170_p;
            this.dogPathfinder = dogIn.func_70661_as();
            this.followSpeed = speedIn;
            this.maxDist = range;
            this.predicate = entity -> {
                double d0 = EntityUtil.getFollowRange((LivingEntity)this.dog);
                if (entity.func_82150_aj()) {
                    return false;
                }
                if (targetSelector != null && !targetSelector.test((AnimalEntity)entity)) {
                    return false;
                }
                return (double)entity.func_70032_d((Entity)this.dog) > d0 ? false : entity.func_70685_l((Entity)this.dog);
            };
            this.holdingPred = stack -> stack.func_77973_b() == DoggyItems.WHISTLE.get();
            this.sorter = new EntityUtil.Sorter((Entity)dogIn);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.dog.getMode() != EnumMode.DOCILE) {
                return false;
            }
            if (this.dog.getLevel((Supplier)DoggyTalents.SHEPHERD_DOG) <= 0) {
                return false;
            }
            LivingEntity owner = this.dog.func_70902_q();
            if (owner == null) {
                return false;
            }
            if (owner instanceof PlayerEntity && ((PlayerEntity)owner).func_175149_v()) {
                return false;
            }
            if (!EntityUtil.isHolding((Entity)owner, (Item)DoggyItems.WHISTLE.get(), nbt -> nbt.func_74764_b("mode") && nbt.func_74762_e("mode") == 4)) {
                return false;
            }
            List list = this.world.func_175647_a(AnimalEntity.class, this.dog.func_174813_aQ().func_72314_b(12.0, 4.0, 12.0), this.predicate);
            Collections.sort(list, this.sorter);
            if (list.isEmpty()) {
                return false;
            }
            this.MAX_FOLLOW = ShepherdDogTalent.getMaxFollowers(this.dog.getLevel((Supplier)DoggyTalents.SHEPHERD_DOG));
            this.targets = list.subList(0, Math.min(this.MAX_FOLLOW, list.size()));
            this.owner = owner;
            return true;
        }

        public boolean func_75253_b() {
            if (this.dog.getMode() != EnumMode.DOCILE) {
                return false;
            }
            if (this.dog.getLevel((Supplier)DoggyTalents.SHEPHERD_DOG) <= 0) {
                return false;
            }
            if (!EntityUtil.isHolding((Entity)this.owner, (Item)DoggyItems.WHISTLE.get(), nbt -> nbt.func_74764_b("mode") && nbt.func_74762_e("mode") == 4)) {
                return false;
            }
            return !this.targets.isEmpty();
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.dog.func_184643_a(PathNodeType.WATER);
            this.dog.func_184644_a(PathNodeType.WATER, 0.0f);
        }

        public void func_75246_d() {
            if (!this.dog.func_70906_o() && --this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (this.targets.size() < this.MAX_FOLLOW) {
                    List list = this.world.func_175647_a(AnimalEntity.class, this.dog.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0), this.predicate);
                    list.removeAll(this.targets);
                    Collections.sort(list, this.sorter);
                    this.targets.addAll(list.subList(0, Math.min(this.MAX_FOLLOW - this.targets.size(), list.size())));
                }
                Collections.sort(this.targets, this.sorter);
                boolean teleport = this.owner.func_70032_d((Entity)this.targets.get(0)) > 16.0f;
                for (AnimalEntity animalEntity : this.targets) {
                    double distanceAway = animalEntity.func_70032_d((Entity)this.owner);
                    animalEntity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)animalEntity.func_70646_bf());
                    if (teleport) {
                        if (animalEntity.func_110167_bD() || animalEntity.func_184218_aH()) continue;
                        EntityUtil.tryToTeleportNearEntity((LivingEntity)animalEntity, animalEntity.func_70661_as(), this.owner, 4);
                        continue;
                    }
                    if (distanceAway >= 5.0) {
                        if (animalEntity.func_70661_as().func_75497_a((Entity)this.owner, 1.2) || animalEntity.func_110167_bD() || animalEntity.func_184218_aH() || !(distanceAway >= 20.0)) continue;
                        EntityUtil.tryToTeleportNearEntity((LivingEntity)animalEntity, animalEntity.func_70661_as(), this.owner, 4);
                        continue;
                    }
                    animalEntity.func_70661_as().func_75499_g();
                }
                Vec3d vec = Vec3d.field_186680_a;
                for (AnimalEntity target : this.targets) {
                    vec = vec.func_178787_e(target.func_174791_d());
                }
                vec = vec.func_186678_a(1.0 / (double)this.targets.size());
                double d = vec.field_72450_a - this.owner.func_226277_ct_();
                double dPosZ = vec.field_72449_c - this.owner.func_226281_cx_();
                double size = Math.sqrt(d * d + dPosZ * dPosZ);
                double j3 = vec.field_72450_a + d / size * (double)(2 + this.targets.size() / 16);
                double k3 = vec.field_72449_c + dPosZ / size * (double)(2 + this.targets.size() / 16);
                if (teleport) {
                    EntityUtil.tryToTeleportNearEntity((LivingEntity)this.dog, this.dogPathfinder, new BlockPos(j3, this.dog.func_226278_cu_(), k3), 1);
                }
                this.dog.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.dog.func_70646_bf());
                if (!this.dogPathfinder.func_75492_a(j3, this.owner.func_174813_aQ().field_72338_b, k3, this.followSpeed) && this.dog.func_70092_e(j3, this.owner.func_174813_aQ().field_72338_b, k3) > 144.0 && !this.dog.func_110167_bD() && !this.dog.func_184218_aH()) {
                    EntityUtil.tryToTeleportNearEntity((LivingEntity)this.dog, this.dogPathfinder, new BlockPos(j3, this.dog.func_226278_cu_(), k3), 4);
                }
                if (this.dog.func_70032_d((Entity)this.owner) > 40.0f) {
                    EntityUtil.tryToTeleportNearEntity((LivingEntity)this.dog, this.dogPathfinder, this.owner, 2);
                }
                if (this.dog.func_70681_au().nextFloat() < 0.15f) {
                    this.dog.func_184185_a(SoundEvents.field_187857_gE, this.dog.func_70599_aP() + 1.0f, (this.dog.func_70681_au().nextFloat() - this.dog.func_70681_au().nextFloat()) * 0.1f + 0.9f);
                }
                ArrayList<AnimalEntity> toRemove = new ArrayList<AnimalEntity>();
                for (AnimalEntity target : this.targets) {
                    if (target.func_70089_S() && !((double)target.func_70032_d((Entity)this.dog) > 25.0)) continue;
                    toRemove.add(target);
                }
                this.targets.removeAll(toRemove);
            }
        }

        public void func_75251_c() {
            this.owner = null;
            for (AnimalEntity target : this.targets) {
                target.func_70661_as().func_75499_g();
            }
            this.dogPathfinder.func_75499_g();
            this.dog.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        }
    }
}

