/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.util.EntityUtil;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PuppyEyesTalent
extends TalentInstance {
    private int cooldown;

    public PuppyEyesTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public TalentInstance copy() {
        PuppyEyesTalent inst = new PuppyEyesTalent(this.getTalent(), this.level);
        inst.cooldown = this.cooldown;
        return inst;
    }

    @Override
    public void init(AbstractDogEntity dogIn) {
        this.cooldown = dogIn.field_70173_aa;
    }

    @Override
    public void writeToNBT(AbstractDogEntity dogIn, CompoundNBT compound) {
        super.writeToNBT(dogIn, compound);
        int timeLeft = this.cooldown - dogIn.field_70173_aa;
        compound.func_74768_a("cooldown", timeLeft);
    }

    @Override
    public void readFromNBT(AbstractDogEntity dogIn, CompoundNBT compound) {
        super.readFromNBT(dogIn, compound);
        this.cooldown = dogIn.field_70173_aa + compound.func_74762_e("cooldown");
    }

    @Override
    public void onRead(AbstractDogEntity dogIn, CompoundNBT compound) {
        if (compound.func_74764_b("charmercharge")) {
            this.cooldown = dogIn.field_70173_aa + compound.func_74762_e("charmercharge");
        }
    }

    @Override
    public void livingTick(AbstractDogEntity dogIn) {
        if (dogIn.field_70173_aa % 40 != 0) {
            return;
        }
        if (dogIn.field_70170_p.field_72995_K || !dogIn.func_70909_n()) {
            return;
        }
        if (this.level() <= 0) {
            return;
        }
        int timeLeft = this.cooldown - dogIn.field_70173_aa;
        if (timeLeft <= 0) {
            LivingEntity owner = dogIn.func_70902_q();
            if (owner == null) {
                return;
            }
            LivingEntity villager = this.getClosestVisibleVillager(dogIn, 5.0);
            if (villager != null) {
                int rewardId = dogIn.func_70681_au().nextInt(this.level()) + (this.level() >= 5 ? 1 : 0);
                if (rewardId == 0) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.1.line.1", new Object[]{dogIn.getGenderPronoun()}));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.1.line.2", new Object[]{dogIn.getGenderSubject()}));
                    villager.func_199702_a((IItemProvider)Items.field_151147_al, 2);
                } else if (rewardId == 1) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.2.line.1", new Object[]{dogIn.getGenderTitle()}));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.2.line.2", new Object[]{dogIn.getGenderTitle()}));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.2.line.3", new Object[]{dogIn.getGenderTitle()}));
                    villager.func_199702_a((IItemProvider)Items.field_151147_al, 5);
                } else if (rewardId == 2) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.3.line.1", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.3.line.2", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.3.line.3", new Object[0]));
                    villager.func_199702_a((IItemProvider)Items.field_151042_j, 3);
                } else if (rewardId == 3) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.4.line.1", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.4.line.2", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.4.line.3", new Object[0]));
                    villager.func_199702_a((IItemProvider)Items.field_151043_k, 2);
                } else if (rewardId == 4) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.5.line.1", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.5.line.2", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.5.line.3", new Object[0]));
                    villager.func_199702_a((IItemProvider)Items.field_151045_i, 1);
                } else if (rewardId == 5) {
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.6.line.1", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.6.line.2", new Object[0]));
                    owner.func_145747_a((ITextComponent)new TranslationTextComponent("talent.doggytalents.puppy_eyes.msg.6.line.3", new Object[0]));
                    villager.func_199702_a((IItemProvider)Items.field_151034_e, 1);
                    villager.func_199702_a((IItemProvider)Blocks.field_150414_aQ, 1);
                    villager.func_199702_a((IItemProvider)Items.field_151123_aH, 3);
                    villager.func_199702_a((IItemProvider)Items.field_151147_al, 5);
                }
                this.cooldown = dogIn.field_70173_aa + (this.level() >= 5 ? 24000 : 48000);
            }
        }
    }

    public LivingEntity getClosestVisibleVillager(AbstractDogEntity dogIn, double radiusIn) {
        List list = dogIn.field_70170_p.func_175647_a(AbstractVillagerEntity.class, dogIn.func_174813_aQ().func_72314_b(radiusIn, radiusIn, radiusIn), village -> village.func_70685_l((Entity)dogIn));
        return (LivingEntity)EntityUtil.getClosestTo((Entity)dogIn, list);
    }
}

