/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.config.ConfigValues;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.util.InventoryUtil;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class PackPuppyTalent
extends TalentInstance {
    @CapabilityInject(value=PackPuppyItemHandler.class)
    public static Capability<PackPuppyItemHandler> PACK_PUPPY_CAPABILITY = null;
    private PackPuppyItemHandler packPuppyHandler;
    private LazyOptional<?> lazyPackPuppyHandler;
    public static Predicate<ItemEntity> SHOULD_PICKUP_ENTITY_ITEM = entity -> entity.func_70089_S() && !entity.func_174874_s() && !entity.func_92059_d().func_77973_b().func_206844_a(DoggyTags.PACK_PUPPY_BLACKLIST);

    public PackPuppyTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
        PackPuppyItemHandler handler;
        this.packPuppyHandler = handler = new PackPuppyItemHandler();
        this.lazyPackPuppyHandler = LazyOptional.of(() -> handler);
    }

    public PackPuppyItemHandler inventory() {
        return this.packPuppyHandler;
    }

    @Override
    public void tick(AbstractDogEntity dogIn) {
        List list;
        if (dogIn.func_70089_S() && !dogIn.field_70170_p.field_72995_K && this.level() >= 5 && !(list = dogIn.field_70170_p.func_175647_a(ItemEntity.class, dogIn.func_174813_aQ().func_72314_b(2.5, 1.0, 2.5), SHOULD_PICKUP_ENTITY_ITEM)).isEmpty()) {
            for (ItemEntity entityItem : list) {
                ItemStack remaining = InventoryUtil.addItem((IItemHandler)this.packPuppyHandler, entityItem.func_92059_d());
                if (!remaining.func_190926_b()) {
                    entityItem.func_92058_a(remaining);
                    continue;
                }
                entityItem.func_70106_y();
                dogIn.func_184185_a(SoundEvents.field_187638_cR, 0.25f, ((dogIn.field_70170_p.field_73012_v.nextFloat() - dogIn.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    @Override
    public ActionResultType processInteract(AbstractDogEntity dogIn, World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (dogIn.func_70909_n() && this.level() > 0 && playerIn.func_225608_bj_() && stack.func_190926_b() && dogIn.canInteract((LivingEntity)playerIn)) {
            if (!playerIn.field_70170_p.field_72995_K) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("talent.doggytalents.pack_puppy.version_migration", new Object[0]), false);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void set(AbstractDogEntity dog, int preLevel) {
        if (preLevel > 0 && this.level == 0) {
            this.dropInventory(dog);
        }
    }

    @Override
    public void dropInventory(AbstractDogEntity dogIn) {
        for (int i = 0; i < this.packPuppyHandler.getSlots(); ++i) {
            InventoryHelper.func_180173_a((World)dogIn.field_70170_p, (double)dogIn.func_226277_ct_(), (double)dogIn.func_226278_cu_(), (double)dogIn.func_226281_cx_(), (ItemStack)this.packPuppyHandler.getStackInSlot(i));
            this.packPuppyHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public void writeToNBT(AbstractDogEntity dogIn, CompoundNBT compound) {
        super.writeToNBT(dogIn, compound);
        compound.func_197643_a(this.packPuppyHandler.serializeNBT());
    }

    @Override
    public void readFromNBT(AbstractDogEntity dogIn, CompoundNBT compound) {
        super.readFromNBT(dogIn, compound);
        this.packPuppyHandler.deserializeNBT(compound);
    }

    @Override
    public void onRead(AbstractDogEntity dogIn, CompoundNBT compound) {
        this.packPuppyHandler.deserializeNBT(compound);
    }

    @Override
    public <T> LazyOptional<T> getCapability(AbstractDogEntity dogIn, Capability<T> cap, Direction side) {
        if (cap == PACK_PUPPY_CAPABILITY) {
            return this.lazyPackPuppyHandler;
        }
        return null;
    }

    @Override
    public void invalidateCapabilities(AbstractDogEntity dogIn) {
        this.lazyPackPuppyHandler.invalidate();
    }

    @Override
    public boolean hasRenderer() {
        return ConfigValues.RENDER_CHEST;
    }

    public static boolean hasInventory(AbstractDogEntity dogIn) {
        return dogIn.func_70089_S() && dogIn.getTalent((Supplier)DoggyTalents.PACK_PUPPY).isPresent();
    }
}

