/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyItems;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.registry.Accessory;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.IDogData;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public class DogLocationData
implements IDogData {
    private final DogLocationStorage storage;
    private final UUID uuid;
    @Nullable
    private UUID ownerId;
    @Nullable
    private Vec3d position;
    @Nullable
    private ResourceLocation dimension;
    @Nullable
    private ITextComponent name;
    @Nullable
    private ITextComponent ownerName;
    @Nullable
    private EnumGender gender;
    private boolean hasRadarCollar;
    private DogEntity dog;
    private LivingEntity owner;
    private DimensionType dimensionType;

    protected DogLocationData(DogLocationStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getDogId() {
        return this.uuid;
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String getDogName() {
        return this.name == null ? "" : this.name.getString();
    }

    @Override
    public String getOwnerName() {
        return this.ownerName == null ? "" : this.ownerName.getString();
    }

    public void populate(DogEntity dogIn) {
        this.update(dogIn);
    }

    public void update(DogEntity dogIn) {
        this.ownerId = dogIn.func_184753_b();
        this.position = dogIn.func_174791_d();
        this.dimension = dogIn.field_70170_p.func_201675_m().func_186058_p().getRegistryName();
        this.name = dogIn.func_200200_C_();
        this.ownerName = dogIn.getOwnersName().orElse(null);
        this.gender = dogIn.getGender();
        this.hasRadarCollar = dogIn.getAccessory((Accessory)DoggyAccessories.RADIO_BAND.get()).isPresent();
        this.dog = dogIn;
        this.storage.func_76185_a();
    }

    public void read(CompoundNBT compound) {
        this.ownerId = NBTUtil.getUniqueId(compound, "ownerId");
        this.position = NBTUtil.getVec3d(compound);
        this.dimension = NBTUtil.getResourceLocation(compound, "dimension");
        this.name = NBTUtil.getTextComponent(compound, "name_text_component");
        if (compound.func_150297_b("gender", 8)) {
            this.gender = EnumGender.bySaveName(compound.func_74779_i("gender"));
        }
        this.hasRadarCollar = compound.func_74767_n("collar");
    }

    public CompoundNBT write(CompoundNBT compound) {
        NBTUtil.putUniqueId(compound, "ownerId", this.ownerId);
        NBTUtil.putVec3d(compound, this.position);
        NBTUtil.putResourceLocation(compound, "dimension", this.dimension);
        NBTUtil.putTextComponent(compound, "name_text_component", this.name);
        if (this.gender != null) {
            compound.func_74778_a("gender", this.gender.getSaveName());
        }
        compound.func_74757_a("collar", this.hasRadarCollar);
        return compound;
    }

    public static DogLocationData from(DogLocationStorage storageIn, DogEntity dogIn) {
        DogLocationData locationData = new DogLocationData(storageIn, dogIn.func_110124_au());
        locationData.populate(dogIn);
        return locationData;
    }

    @Nullable
    public LivingEntity getOwner(ServerWorld worldIn) {
        boolean flag = false;
        for (ServerWorld world : worldIn.func_73046_m().func_212370_w()) {
            LivingEntity possibleOwner = WorldUtil.getCachedEntity((World)world, LivingEntity.class, this.owner, this.ownerId);
            if (possibleOwner == null) continue;
            this.owner = possibleOwner;
            flag = true;
            break;
        }
        if (!flag) {
            this.owner = null;
        }
        return this.owner;
    }

    @Nullable
    public DogEntity getDog(ServerWorld worldIn) {
        boolean flag = false;
        for (ServerWorld world : worldIn.func_73046_m().func_212370_w()) {
            DogEntity possibleDog = WorldUtil.getCachedEntity((World)world, DogEntity.class, this.dog, this.uuid);
            if (possibleDog == null) continue;
            this.dog = possibleDog;
            flag = true;
            break;
        }
        if (!flag) {
            this.dog = null;
        }
        return this.dog;
    }

    public boolean shouldDisplay(World worldIn, PlayerEntity playerIn, Hand handIn) {
        return this.hasRadarCollar || playerIn.func_184812_l_() || playerIn.func_184586_b(handIn).func_77973_b() == DoggyItems.CREATIVE_RADAR.get();
    }

    @Nullable
    public ITextComponent getName(World worldIn) {
        return this.name;
    }

    @Nullable
    public Vec3d getPos() {
        return this.position;
    }

    @Nullable
    public DimensionType getDimension() {
        if (this.dimensionType == null || !this.dimensionType.getRegistryName().equals((Object)this.dimension)) {
            this.dimensionType = (DimensionType)Registry.field_212622_k.func_218349_b(this.dimension).orElseGet(null);
        }
        return this.dimensionType;
    }

    public String toString() {
        return "DogLocationData [uuid=" + this.uuid + ", owner=" + this.ownerId + ", position=" + this.position + ", dimension=" + this.dimension + ", name=" + this.name + ", gender=" + (Object)((Object)this.gender) + ", hasRadarCollar=" + this.hasRadarCollar + "]";
    }
}

