/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.DogEntity;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogObeyData;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class DogObeyPacket
extends DogPacket<DogObeyData> {
    @Override
    public void encode(DogObeyData data, PacketBuffer buf) {
        super.encode(data, buf);
        buf.writeBoolean(data.obeyOthers);
    }

    @Override
    public DogObeyData decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        boolean obeyOthers = buf.readBoolean();
        return new DogObeyData(entityId, obeyOthers);
    }

    @Override
    public void handleDog(DogEntity dogIn, DogObeyData data, Supplier<NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        dogIn.setWillObeyOthers(data.obeyOthers);
    }
}

