/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.recipe;

import doggytalents.DoggyRecipeSerializers;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.util.DogBedUtil;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DogBedRecipe
extends SpecialRecipe
implements IShapedRecipe<CraftingInventory> {
    public DogBedRecipe(ResourceLocation resource) {
        super(resource);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ForgeRegistryEntry beddingId = null;
        ForgeRegistryEntry casingId = null;
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                ForgeRegistryEntry id;
                if (col == 1 && row < 2) {
                    id = DogBedUtil.getBeddingFromStack(DoggyTalentsAPI.BEDDING_MATERIAL, inv.func_70301_a(row * inv.func_174922_i() + col));
                    if (id == null) {
                        return false;
                    }
                    if (beddingId == null) {
                        beddingId = id;
                        continue;
                    }
                    if (beddingId == id) continue;
                    return false;
                }
                id = DogBedUtil.getCasingFromStack(DoggyTalentsAPI.CASING_MATERIAL, inv.func_70301_a(row * inv.func_174922_i() + col));
                if (id == null) {
                    return false;
                }
                if (casingId == null) {
                    casingId = id;
                    continue;
                }
                if (casingId == id) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        IBeddingMaterial beddingId = DogBedUtil.getBeddingFromStack(DoggyTalentsAPI.BEDDING_MATERIAL, inv.func_70301_a(1));
        ICasingMaterial casingId = DogBedUtil.getCasingFromStack(DoggyTalentsAPI.CASING_MATERIAL, inv.func_70301_a(0));
        return DogBedUtil.createItemStack(casingId, beddingId);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)DoggyRecipeSerializers.DOG_BED.get();
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 3;
    }
}

