/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.inventory.container.slot.DogInventorySlot;
import doggytalents.common.talent.PackPuppyTalent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class DogInventoriesContainer
extends Container {
    private World world;
    private PlayerEntity player;
    private IntReferenceHolder position;
    private IntArray trackableArray;
    private final List<DogInventorySlot> dogSlots = new ArrayList<DogInventorySlot>();
    private int possibleSlots = 0;

    public DogInventoriesContainer(int windowId, PlayerInventory playerInventory, IntArray trackableArray) {
        super((ContainerType)DoggyContainerTypes.DOG_INVENTORIES.get(), windowId);
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.player = playerInventory.field_70458_d;
        this.position = IntReferenceHolder.func_221492_a();
        DogInventoriesContainer.func_216959_a((IIntArray)trackableArray, (int)1);
        this.func_216958_a(this.position);
        this.trackableArray = trackableArray;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, col, 8 + col * 18, 142));
        }
        this.addDogSlots();
    }

    public void addDogSlots() {
        int TOTAL_COLUMNS = 9;
        int page = this.position.func_221495_b();
        int drawingColumn = 0;
        for (int i = 0; i < this.trackableArray.func_221478_a(); ++i) {
            DogEntity dog;
            PackPuppyItemHandler packInventory;
            int entityId = this.trackableArray.func_221476_a(i);
            Entity entity = this.world.func_73045_a(entityId);
            if (!(entity instanceof DogEntity) || (packInventory = (PackPuppyItemHandler)(dog = (DogEntity)entity).getTalent((Supplier)DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class).inventory()).orElse(null)) == null) continue;
            int level = MathHelper.func_76125_a((int)dog.getLevel((Supplier)DoggyTalents.PACK_PUPPY), (int)0, (int)5);
            int numCols = MathHelper.func_76125_a((int)level, (int)0, (int)Math.max(0, 9));
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < numCols; ++col) {
                    DogInventorySlot slot = new DogInventorySlot(dog, this.player, (IItemHandler)packInventory, drawingColumn + col, row, col, col * 3 + row, 8 + 18 * (drawingColumn + col - page), 18 * row + 18);
                    this.addDogSlot(slot);
                    int adjustedColumn = slot.getOverallColumn() - page;
                    if (adjustedColumn - page >= 0 && adjustedColumn - page < 9) continue;
                    slot.setEnabled(false);
                }
            }
            this.possibleSlots += level;
            drawingColumn += numCols;
        }
    }

    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        if (id == 0) {
            for (int i = 0; i < this.dogSlots.size(); ++i) {
                DogInventorySlot slot = this.dogSlots.get(i);
                DogInventorySlot newSlot = new DogInventorySlot(slot, 8 + 18 * (slot.getOverallColumn() - data));
                this.replaceDogSlot(i, newSlot);
                int adjustedColumn = slot.getOverallColumn() - data;
                if (adjustedColumn >= 0 && adjustedColumn < 9) continue;
                newSlot.setEnabled(false);
            }
        }
    }

    private void addDogSlot(DogInventorySlot slotIn) {
        this.func_75146_a((Slot)slotIn);
        this.dogSlots.add(slotIn);
    }

    private void replaceDogSlot(int i, DogInventorySlot slotIn) {
        this.dogSlots.set(i, slotIn);
        this.field_75151_b.set(slotIn.field_75222_d, slotIn);
    }

    public int getTotalNumColumns() {
        return this.possibleSlots;
    }

    public int getPage() {
        return this.position.func_221495_b();
    }

    public void setPage(int page) {
        this.position.func_221494_a(page);
    }

    public List<DogInventorySlot> getSlots() {
        return this.dogSlots;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity player, int i) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int startIndex = this.field_75151_b.size() - this.dogSlots.size() + this.position.func_221495_b() * 3;
            int endIndex = Math.min(startIndex + 27, this.field_75151_b.size());
            if (i >= this.field_75151_b.size() - this.dogSlots.size() && i < this.field_75151_b.size() ? !this.func_75135_a(itemstack1, 0, this.field_75151_b.size() - this.dogSlots.size(), true) : !this.func_75135_a(itemstack1, this.field_75151_b.size() - this.dogSlots.size(), this.field_75151_b.size(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }
}

