/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.stats.Stats;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class BreedGoal
extends Goal {
    private static final EntityPredicate breedPredicate = new EntityPredicate().func_221013_a(8.0).func_221008_a().func_221011_b().func_221014_c().func_221009_d();
    private final AnimalEntity animal;
    private final Class<? extends AnimalEntity> mateClass;
    private final World world;
    private final double moveSpeed;
    protected AnimalEntity targetMate;
    private int spawnBabyDelay;

    public BreedGoal(AnimalEntity animal, double speedIn) {
        this(animal, speedIn, animal.getClass());
    }

    public BreedGoal(AnimalEntity animal, double moveSpeed, Class<? extends AnimalEntity> mateClass) {
        this.animal = animal;
        this.world = animal.field_70170_p;
        this.mateClass = mateClass;
        this.moveSpeed = moveSpeed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.animal.func_70880_s()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.animal.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.animal.func_70646_bf());
        this.animal.func_70661_as().func_75497_a((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.animal.func_70068_e((Entity)this.targetMate) < 9.0) {
            this.spawnBaby();
        }
    }

    @Nullable
    private AnimalEntity getNearbyMate() {
        List entities = this.world.func_175647_a(this.mateClass, this.animal.func_174813_aQ().func_186662_g(8.0), this::filterEntities);
        return (AnimalEntity)EntityUtil.getClosestTo((Entity)this.animal, entities);
    }

    private boolean filterEntities(AnimalEntity entity) {
        return breedPredicate.func_221015_a((LivingEntity)this.animal, (LivingEntity)entity) && this.animal.func_70878_b(entity);
    }

    protected void spawnBaby() {
        AgeableEntity ageableentity = this.animal.func_90011_a((AgeableEntity)this.targetMate);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((MobEntity)this.animal, (MobEntity)this.targetMate, ageableentity);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        ageableentity = event.getChild();
        if (cancelled) {
            this.animal.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.animal.func_70875_t();
            this.targetMate.func_70875_t();
            return;
        }
        if (ageableentity != null) {
            ServerPlayerEntity serverplayerentity = this.animal.func_191993_do();
            if (serverplayerentity == null && this.targetMate.func_191993_do() != null) {
                serverplayerentity = this.targetMate.func_191993_do();
            }
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this.animal, this.targetMate, ageableentity);
            }
            this.animal.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.animal.func_70875_t();
            this.targetMate.func_70875_t();
            ageableentity.func_70873_a(-24000);
            ageableentity.func_70012_b(this.animal.func_226277_ct_(), this.animal.func_226278_cu_(), this.animal.func_226281_cx_(), 0.0f, 0.0f);
            this.world.func_217376_c((Entity)ageableentity);
            this.world.func_72960_a((Entity)this.animal, (byte)18);
            if (this.world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                this.world.func_217376_c((Entity)new ExperienceOrbEntity(this.world, this.animal.func_226277_ct_(), this.animal.func_226278_cu_(), this.animal.func_226281_cx_(), this.animal.func_70681_au().nextInt(7) + 1));
            }
        }
    }
}

