/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggySerializers;
import doggytalents.DoggyTags;
import doggytalents.DoggyTalents2;
import doggytalents.api.enu.WetSource;
import doggytalents.api.feature.DataKey;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.feature.InteractHandler;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.screen.DogInfoScreen;
import doggytalents.common.config.ConfigValues;
import doggytalents.common.entity.ai.BerserkerModeGoal;
import doggytalents.common.entity.ai.BreedGoal;
import doggytalents.common.entity.ai.DogBegGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoal;
import doggytalents.common.entity.ai.DogWanderGoal;
import doggytalents.common.entity.ai.FetchGoal;
import doggytalents.common.entity.ai.FindWaterGoal;
import doggytalents.common.entity.ai.GuardModeGoal;
import doggytalents.common.entity.ai.MoveToBlockGoal;
import doggytalents.common.entity.ai.OwnerHurtByTargetGoal;
import doggytalents.common.entity.ai.OwnerHurtTargetGoal;
import doggytalents.common.entity.serializers.DimensionDependantArg;
import doggytalents.common.entity.stats.StatsTracker;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.util.BackwardsComp;
import doggytalents.common.util.Cache;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.DataSerializerEntry;

public class DogEntity
extends AbstractDogEntity {
    private static final DataParameter<Optional<ITextComponent>> LAST_KNOWN_NAME = EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)DataSerializers.field_200544_f);
    private static final DataParameter<Byte> DOG_FLAGS = EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> HUNGER_INT = EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<String> CUSTOM_SKIN = EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> SIZE = EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<ItemStack> BONE_VARIANT = EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final Cache<DataParameter<List<AccessoryInstance>>> ACCESSORIES = Cache.make(() -> EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)((DataSerializerEntry)DoggySerializers.ACCESSORY_SERIALIZER.get()).getSerializer()));
    private static final Cache<DataParameter<List<TalentInstance>>> TALENTS = Cache.make(() -> EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)((DataSerializerEntry)DoggySerializers.TALENT_SERIALIZER.get()).getSerializer()));
    private static final Cache<DataParameter<DogLevel>> DOG_LEVEL = Cache.make(() -> EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)((DataSerializerEntry)DoggySerializers.DOG_LEVEL_SERIALIZER.get()).getSerializer()));
    private static final Cache<DataParameter<EnumGender>> GENDER = Cache.make(() -> EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)((DataSerializerEntry)DoggySerializers.GENDER_SERIALIZER.get()).getSerializer()));
    private static final Cache<DataParameter<EnumMode>> MODE = Cache.make(() -> EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)((DataSerializerEntry)DoggySerializers.MODE_SERIALIZER.get()).getSerializer()));
    private static final Cache<DataParameter<DimensionDependantArg<Optional<BlockPos>>>> DOG_BED_LOCATION = Cache.make(() -> EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)((DataSerializerEntry)DoggySerializers.BED_LOC_SERIALIZER.get()).getSerializer()));
    private static final Cache<DataParameter<DimensionDependantArg<Optional<BlockPos>>>> DOG_BOWL_LOCATION = Cache.make(() -> EntityDataManager.func_187226_a(DogEntity.class, (IDataSerializer)((DataSerializerEntry)DoggySerializers.BED_LOC_SERIALIZER.get()).getSerializer()));
    private final Cache<Integer> spendablePoints = Cache.make(this::getSpendablePointsInternal);
    private final List<IDogAlteration> alterations = new ArrayList<IDogAlteration>(4);
    private final List<IDogFoodHandler> foodHandlers = new ArrayList<IDogFoodHandler>(4);
    public final Map<Integer, Object> objects = new HashMap<Integer, Object>();
    public final StatsTracker statsTracker = new StatsTracker();
    private int hungerTick;
    private int prevHungerTick;
    private int healingTick;
    private int prevHealingTick;
    private float headRotationCourse;
    private float headRotationCourseOld;
    private WetSource wetSource;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    protected boolean dogJumping;
    protected float jumpPower;
    protected BlockPos targetBlock;

    public static final void initDataParameters() {
        ACCESSORIES.get();
        TALENTS.get();
        DOG_LEVEL.get();
        GENDER.get();
        MODE.get();
        DOG_BED_LOCATION.get();
        DOG_BOWL_LOCATION.get();
    }

    public DogEntity(EntityType<? extends DogEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70903_f(false);
        this.setGender(EnumGender.random(this.func_70681_au()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ACCESSORIES.get(), new ArrayList(4));
        this.field_70180_af.func_187214_a(TALENTS.get(), new ArrayList(4));
        this.field_70180_af.func_187214_a(LAST_KNOWN_NAME, Optional.empty());
        this.field_70180_af.func_187214_a(DOG_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(GENDER.get(), (Object)EnumGender.UNISEX);
        this.field_70180_af.func_187214_a(MODE.get(), (Object)EnumMode.DOCILE);
        this.field_70180_af.func_187214_a(HUNGER_INT, (Object)Float.valueOf(60.0f));
        this.field_70180_af.func_187214_a(CUSTOM_SKIN, (Object)"");
        this.field_70180_af.func_187214_a(DOG_LEVEL.get(), (Object)new DogLevel(0, 0));
        this.field_70180_af.func_187214_a(SIZE, (Object)3);
        this.field_70180_af.func_187214_a(BONE_VARIANT, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(DOG_BED_LOCATION.get(), new DimensionDependantArg(() -> DataSerializers.field_187201_k));
        this.field_70180_af.func_187214_a(DOG_BOWL_LOCATION.get(), new DimensionDependantArg(() -> DataSerializers.field_187201_k));
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveToBlockGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new DogWanderGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new FetchGoal(this, 1.0, 32.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new DogFollowOwnerGoal(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new DogBegGoal(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
        this.field_70715_bh.func_75776_a(6, new BerserkerModeGoal<MonsterEntity>(this, MonsterEntity.class, false));
        this.field_70715_bh.func_75776_a(6, (Goal)new GuardModeGoal(this, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_70909_n() ? 20.0 : 8.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(JUMP_STRENGTH).func_111128_a((double)0.42f);
        this.func_110140_aT().func_111150_b(CRIT_CHANCE).func_111128_a((double)0.01f);
        this.func_110140_aT().func_111150_b(CRIT_BONUS).func_111128_a(1.0);
    }

    public void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && this.func_110143_aJ() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    @Override
    public float func_70599_aP() {
        return 0.4f;
    }

    public boolean isDogWet() {
        return this.wetSource != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float partialTicks) {
        return 0.75f + MathHelper.func_219799_g((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) / 2.0f * 0.25f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float partialTicks, float p_70923_2_) {
        float f = (MathHelper.func_219799_g((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.headRotationCourseOld, (float)this.headRotationCourse) * 0.15f * (float)Math.PI;
    }

    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public float getTailRotation() {
        return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - this.func_110143_aJ()) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    @Override
    public float getWagAngle(float limbSwing, float limbSwingAmount, float partialTickTime) {
        return MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public double func_70033_W() {
        return this.func_184187_bx() instanceof PlayerEntity ? 0.5 : 0.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S()) {
            this.headRotationCourseOld = this.headRotationCourse;
            this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
            boolean inWater = this.func_70090_H();
            boolean inRain = inWater ? false : this.func_70026_G();
            boolean inBubbleColumn = this.func_209512_q();
            if (inWater || inRain || inBubbleColumn) {
                this.isShaking = false;
                this.timeWolfIsShaking = 0.0f;
                this.prevTimeWolfIsShaking = 0.0f;
                if (this.wetSource == null) {
                    this.wetSource = WetSource.of(inWater, inBubbleColumn, inRain);
                }
            } else if ((this.wetSource != null || this.isShaking) && this.isShaking) {
                if (this.timeWolfIsShaking == 0.0f) {
                    this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
                this.timeWolfIsShaking += 0.05f;
                if (this.prevTimeWolfIsShaking >= 2.0f) {
                    if (this.wetSource != null) {
                        for (IDogAlteration alter2 : this.alterations) {
                            alter2.onShakingDry(this, this.wetSource);
                        }
                    }
                    this.wetSource = null;
                    this.isShaking = false;
                    this.prevTimeWolfIsShaking = 0.0f;
                    this.timeWolfIsShaking = 0.0f;
                }
                if (this.timeWolfIsShaking > 0.4f) {
                    float f = (float)this.func_226278_cu_();
                    int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3d vec3d = this.func_213322_ci();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                        float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)f1, (double)(f + 0.8f), this.func_226281_cx_() + (double)f2, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 40 == 0) {
                DogLocationStorage.get(this.field_70170_p).getOrCreateData(this).update(this);
                if (this.func_70902_q() != null) {
                    this.setOwnersName(this.func_70902_q().func_200200_C_());
                }
            }
        }
        this.alterations.forEach(alter -> alter.tick(this));
    }

    public void func_70636_d() {
        DimensionType dimKey;
        Optional<BlockPos> bowlPos;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.wetSource != null && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (!this.field_70170_p.field_72995_K) {
            ActionResult<Integer> result;
            if (!ConfigValues.DISABLE_HUNGER) {
                this.prevHungerTick = this.hungerTick++;
                if (this.func_184207_aI() || !this.func_70906_o()) {
                    // empty if block
                }
                for (IDogAlteration alter2 : this.alterations) {
                    result = alter2.hungerTick(this, this.hungerTick - this.prevHungerTick);
                    if (!result.func_188397_a().func_226247_b_()) continue;
                    this.hungerTick = (Integer)result.func_188398_b() + this.prevHungerTick;
                }
                if (this.hungerTick > 400) {
                    this.setDogHunger(this.getDogHunger() - 1.0f);
                    this.hungerTick -= 400;
                }
            }
            this.prevHealingTick = this.healingTick;
            this.healingTick += 8;
            if (this.func_70906_o()) {
                this.healingTick += 4;
            }
            for (IDogAlteration alter2 : this.alterations) {
                result = alter2.healingTick(this, this.healingTick - this.prevHealingTick);
                if (!result.func_188397_a().func_226247_b_()) continue;
                this.healingTick = (Integer)result.func_188398_b() + this.prevHealingTick;
            }
            if (this.healingTick >= 6000) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    DoggyTalents2.LOGGER.debug("Heal:");
                    this.func_70691_i(1.0f);
                }
                this.healingTick = 0;
            }
        }
        if (ConfigValues.DIRE_PARTICLES && this.field_70170_p.field_72995_K && this.getLevel().isDireDog()) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_() - 0.25, this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.field_70173_aa % 50 == 0 && (bowlPos = this.getBowlPos(dimKey = this.field_70170_p.func_201675_m().func_186058_p())).isPresent() && this.field_70170_p.func_175667_e(bowlPos.get()) && this.field_70170_p.func_180495_p(bowlPos.get()).func_177230_c() != DoggyBlocks.FOOD_BOWL.get()) {
            this.setBowlPos(dimKey, Optional.empty());
        }
        this.alterations.forEach(alter -> alter.livingTick(this));
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        Optional<IDogFoodHandler> foodHandler;
        ItemStack stack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (stack.func_77973_b() == Items.field_151055_y && this.canInteract((LivingEntity)player)) {
                if (this.field_70170_p.field_72995_K) {
                    DogInfoScreen.open(this);
                }
                return true;
            }
        } else if (stack.func_77973_b() == Items.field_151103_aS || stack.func_77973_b() == DoggyItems.TRAINING_TREAT.get()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_175505_a(player, stack);
                if (stack.func_77973_b() == DoggyItems.TRAINING_TREAT.get() || this.field_70146_Z.nextInt(3) == 0) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(20.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if ((foodHandler = FoodHandler.getMatch(this, stack, (Entity)player)).isPresent()) {
            return foodHandler.get().consume(this, stack, (Entity)player);
        }
        ActionResultType interactResult = InteractHandler.getMatch(this, stack, player, hand);
        if (interactResult.func_226246_a_()) {
            return true;
        }
        if (interactResult == ActionResultType.FAIL) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.processInteract(this, this.field_70170_p, player, hand);
            if (result.func_226246_a_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        boolean flag = super.func_184645_a(player, hand);
        if (!flag || this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
            }
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            return true;
        }
        return flag;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.canBeRiddenInWater(this, rider);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.canBeRiddenInWater(rider);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.canTrample(this, state, pos, fallDistance);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.canTrample(state, pos, fallDistance);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.onLivingFall(this, distance, damageMultiplier);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_225503_b_(distance, damageMultiplier);
    }

    public int func_82143_as() {
        return super.func_82143_as();
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        EffectInstance effectInst = this.func_70660_b(Effects.field_76430_j);
        float f = effectInst == null ? 0.0f : (float)(effectInst.func_76458_c() + 1);
        distance -= f;
        for (IDogAlteration alter : this.alterations) {
            ActionResult<Float> result = alter.calculateFallDistance(this, distance);
            if (!result.func_188397_a().func_226247_b_()) continue;
            distance = ((Float)result.func_188398_b()).floatValue();
            break;
        }
        return MathHelper.func_76123_f((float)((distance - 3.0f - f) * damageMultiplier));
    }

    public boolean func_70648_aU() {
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.canBreatheUnderwater(this);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_70648_aU();
    }

    protected int func_70682_h(int air) {
        for (IDogAlteration alter : this.alterations) {
            ActionResult<Integer> result = alter.decreaseAirSupply(this, air);
            if (!result.func_188397_a().func_226247_b_()) continue;
            return (Integer)result.func_188398_b();
        }
        return super.func_70682_h(air);
    }

    protected int func_207300_l(int currentAir) {
        currentAir += 4;
        for (IDogAlteration alter : this.alterations) {
            ActionResult<Integer> result = alter.determineNextAir(this, currentAir);
            if (!result.func_188397_a().func_226247_b_()) continue;
            currentAir = (Integer)result.func_188398_b();
            break;
        }
        return Math.min(currentAir, this.func_205010_bg());
    }

    public boolean func_213336_c(LivingEntity target) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.canAttack((AbstractDogEntity)this, target);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_213336_c(target);
    }

    public boolean func_213358_a(EntityType<?> entityType) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.canAttack((AbstractDogEntity)this, entityType);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_213358_a(entityType);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.shouldAttackEntity(this, target, owner);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        if (target instanceof CreeperEntity || target instanceof GhastEntity) {
            return false;
        }
        if (target instanceof WolfEntity) {
            WolfEntity wolfentity = (WolfEntity)target;
            return !wolfentity.func_70909_n() || wolfentity.func_70902_q() != owner;
        }
        if (target instanceof DogEntity) {
            DogEntity dogEntity = (DogEntity)target;
            return !dogEntity.func_70909_n() || dogEntity.func_70902_q() != owner;
        }
        if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
            return false;
        }
        if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
            return false;
        }
        return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        for (IDogAlteration alter : this.alterations) {
            ActionResult<Float> result = alter.attackEntityFrom((AbstractDogEntity)this, source, amount);
            if (result.func_188397_a() == ActionResultType.FAIL) {
                return false;
            }
            amount = ((Float)result.func_188398_b()).floatValue();
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity instanceof PlayerEntity && !this.canPlayersAttack()) {
            return false;
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity target) {
        boolean flag;
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.attackEntityAsMob(this, target);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        IAttributeInstance attackDamageInst = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        Set critModifiers = null;
        if (this.func_110148_a(CRIT_CHANCE).func_111126_e() > this.func_70681_au().nextDouble()) {
            critModifiers = this.func_110148_a(CRIT_BONUS).func_225505_c_();
            critModifiers.forEach(arg_0 -> ((IAttributeInstance)attackDamageInst).func_111121_a(arg_0));
        }
        int damage = (int)attackDamageInst.func_111126_e();
        if (critModifiers != null) {
            critModifiers.forEach(arg_0 -> ((IAttributeInstance)attackDamageInst).func_111124_b(arg_0));
        }
        if (flag = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)damage)) {
            this.func_174815_a((LivingEntity)this, target);
            this.statsTracker.increaseDamageDealt(damage);
            if (critModifiers != null) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71452_i.func_199282_a(target, (IParticleData)ParticleTypes.field_197614_g));
            }
        }
        return flag;
    }

    public void func_70074_a(LivingEntity entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        this.statsTracker.incrementKillCount((Entity)entityLivingIn);
    }

    public boolean func_184583_d(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.canBlockDamageSource(this, source);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_184583_d(source);
    }

    public void func_70015_d(int second) {
        for (IDogAlteration alter : this.alterations) {
            ActionResult<Integer> result = alter.setFire(this, second);
            if (!result.func_188397_a().func_226247_b_()) continue;
            second = (Integer)result.func_188398_b();
        }
        super.func_70015_d(second);
    }

    public boolean func_70045_F() {
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.isImmuneToFire(this);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_70045_F();
    }

    public boolean func_180431_b(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.isInvulnerableTo(this, source);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_180431_b(source);
    }

    public boolean func_190530_aW() {
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.isInvulnerable(this);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_190530_aW();
    }

    public boolean func_70687_e(EffectInstance effectIn) {
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.isPotionApplicable(this, effectIn);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_70687_e(effectIn);
    }

    public void func_184221_a(UUID uniqueIdIn) {
        UUID oldUniqueId = this.func_110124_au();
        if (uniqueIdIn.equals(oldUniqueId)) {
            return;
        }
        super.func_184221_a(uniqueIdIn);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            DogLocationStorage.get(this.field_70170_p).remove(oldUniqueId);
            DogLocationStorage.get(this.field_70170_p).getOrCreateData(this).update(this);
        }
    }

    public void func_193101_c(PlayerEntity player) {
        super.func_193101_c(player);
        this.setOwnersName(player.func_200200_C_());
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public void func_184754_b(@Nullable UUID uuid) {
        super.func_184754_b(uuid);
        if (uuid == null) {
            this.setOwnersName((ITextComponent)null);
        }
    }

    public boolean func_85031_j(Entity entityIn) {
        if (entityIn instanceof PlayerEntity && !this.canPlayersAttack()) {
            return true;
        }
        for (IDogAlteration alter : this.alterations) {
            ActionResultType result = alter.hitByEntity(this, entityIn);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)DoggyItems.DOGGY_CHARM.get());
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(DoggyTags.BREEDING_ITEMS);
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof DogEntity)) {
            return false;
        }
        DogEntity entitydog = (DogEntity)otherAnimal;
        if (!entitydog.func_70909_n()) {
            return false;
        }
        if (entitydog.func_70906_o()) {
            return false;
        }
        if (ConfigValues.DOG_GENDER && !this.getGender().canMateWith(entitydog.getGender())) {
            return false;
        }
        return this.func_70880_s() && entitydog.func_70880_s();
    }

    public AgeableEntity func_90011_a(AgeableEntity partner) {
        DogEntity child = (DogEntity)((EntityType)DoggyEntityTypes.DOG.get()).func_200721_a(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            child.func_184754_b(uuid);
            child.func_70903_f(true);
        }
        if (partner instanceof DogEntity && ConfigValues.PUPS_GET_PARENT_LEVELS) {
            child.setLevel(this.getLevel().combine(((DogEntity)partner).getLevel()));
        }
        return child;
    }

    public boolean func_94059_bO() {
        return ConfigValues.ALWAYS_SHOW_DOG_NAME && this.func_145818_k_() || super.func_94059_bO();
    }

    public float func_213355_cm() {
        if (this.func_70631_g_()) {
            return 0.5f;
        }
        return (float)this.getDogSize() * 0.3f + 0.1f;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        for (IDogAlteration alter : this.alterations) {
            LazyOptional<T> result = alter.getCapability(this, cap, side);
            if (result == null) continue;
            return result;
        }
        return super.getCapability(cap, side);
    }

    public Entity func_212321_a(DimensionType dimType) {
        Entity transportedEntity = super.func_212321_a(dimType);
        if (transportedEntity instanceof DogEntity) {
            DogLocationStorage.get(this.field_70170_p).getOrCreateData(this).update((DogEntity)transportedEntity);
        }
        return transportedEntity;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    public void revive() {
        super.revive();
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ != 19 || this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            // empty if block
        }
        super.func_70609_aI();
    }

    public void func_70645_a(DamageSource cause) {
        this.wetSource = null;
        this.isShaking = false;
        this.prevTimeWolfIsShaking = 0.0f;
        this.timeWolfIsShaking = 0.0f;
        this.alterations.forEach(alter -> alter.onDeath(this, cause));
        super.func_70645_a(cause);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            DogRespawnStorage.get(this.field_70170_p).putData(this);
            DoggyTalents2.LOGGER.debug("Saved dog as they died {}", (Object)this);
            DogLocationStorage.get(this.field_70170_p).remove(this);
        }
    }

    public void func_213337_cE() {
        super.func_213337_cE();
        this.alterations.forEach(alter -> alter.dropInventory(this));
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (!keepData) {
            this.alterations.forEach(alter -> alter.invalidateCapabilities(this));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        DimensionDependantArg bowlsData;
        super.func_213281_b(compound);
        ListNBT talentList = new ListNBT();
        List<TalentInstance> talents = this.getTalentMap();
        for (int i = 0; i < talents.size(); ++i) {
            CompoundNBT talentTag = new CompoundNBT();
            talents.get(i).writeInstance(this, talentTag);
            talentList.add((Object)talentTag);
        }
        compound.func_218657_a("talents", (INBT)talentList);
        ListNBT accessoryList = new ListNBT();
        List<AccessoryInstance> accessories = this.getAccessories();
        for (int i = 0; i < accessories.size(); ++i) {
            CompoundNBT accessoryTag = new CompoundNBT();
            accessories.get(i).writeInstance(accessoryTag);
            accessoryList.add((Object)accessoryTag);
        }
        compound.func_218657_a("accessories", (INBT)accessoryList);
        compound.func_74778_a("mode", this.getMode().getSaveName());
        compound.func_74778_a("dogGender", this.getGender().getSaveName());
        compound.func_74776_a("dogHunger", this.getDogHunger());
        this.getOwnersName().ifPresent(comp -> NBTUtil.putTextComponent(compound, "lastKnownOwnerName", comp));
        compound.func_74778_a("customSkinHash", this.getSkinHash());
        compound.func_74757_a("willObey", this.willObeyOthers());
        compound.func_74757_a("friendlyFire", this.canPlayersAttack());
        compound.func_74768_a("dogSize", this.getDogSize());
        compound.func_74768_a("level_normal", this.getLevel().getLevel(DogLevel.Type.NORMAL));
        compound.func_74768_a("level_dire", this.getLevel().getLevel(DogLevel.Type.DIRE));
        NBTUtil.writeItemStack(compound, "fetchItem", this.getBoneVariant());
        DimensionDependantArg bedsData = (DimensionDependantArg)this.field_70180_af.func_187225_a(DOG_BED_LOCATION.get());
        if (!bedsData.isEmpty()) {
            ListNBT bedsList = new ListNBT();
            for (Map.Entry entry : bedsData.entrySet()) {
                CompoundNBT bedNBT = new CompoundNBT();
                NBTUtil.putResourceLocation(bedNBT, "dim", entry.getKey().getRegistryName());
                NBTUtil.putBlockPos(bedNBT, "pos", (Optional)entry.getValue());
                bedsList.add((Object)bedNBT);
            }
            compound.func_218657_a("beds", (INBT)bedsList);
        }
        if (!(bowlsData = (DimensionDependantArg)this.field_70180_af.func_187225_a(DOG_BOWL_LOCATION.get())).isEmpty()) {
            ListNBT bowlsList = new ListNBT();
            for (Map.Entry entry : bowlsData.entrySet()) {
                CompoundNBT bowlsNBT = new CompoundNBT();
                NBTUtil.putResourceLocation(bowlsNBT, "dim", entry.getKey().getRegistryName());
                NBTUtil.putBlockPos(bowlsNBT, "pos", (Optional)entry.getValue());
                bowlsList.add((Object)bowlsNBT);
            }
            compound.func_218657_a("bowls", (INBT)bowlsList);
        }
        this.statsTracker.writeAdditional(compound);
        this.alterations.forEach(alter -> alter.onWrite(this, compound));
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        List<TalentInstance> talentMap = this.getTalentMap();
        talentMap.clear();
        if (compound.func_150297_b("talents", 9)) {
            ListNBT talentList = compound.func_150295_c("talents", 10);
            for (int i = 0; i < talentList.size(); ++i) {
                TalentInstance.readInstance(this, talentList.func_150305_b(i)).ifPresent(talentMap::add);
            }
        } else {
            BackwardsComp.readTalentMapping(compound, talentMap);
        }
        this.markDataParameterDirty(TALENTS.get(), false);
        List<AccessoryInstance> accessories = this.getAccessories();
        accessories.clear();
        if (compound.func_150297_b("accessories", 9)) {
            ListNBT accessoryList = compound.func_150295_c("accessories", 10);
            for (int i = 0; i < accessoryList.size(); ++i) {
                AccessoryInstance.readInstance(accessoryList.func_150305_b(i)).ifPresent(accessories::add);
            }
        } else {
            BackwardsComp.readAccessories(compound, accessories);
        }
        this.markDataParameterDirty(ACCESSORIES.get(), false);
        this.recalculateAlterationsCache();
        this.spendablePoints.markForRefresh();
        for (TalentInstance entry : talentMap) {
            entry.init(this);
        }
        this.setGender(EnumGender.bySaveName(compound.func_74779_i("dogGender")));
        if (compound.func_150297_b("mode", 8)) {
            this.setMode(EnumMode.bySaveName(compound.func_74779_i("mode")));
        } else {
            BackwardsComp.readMode(compound, this::setMode);
        }
        if (compound.func_150297_b("customSkinHash", 8)) {
            this.setSkinHash(compound.func_74779_i("customSkinHash"));
        } else {
            BackwardsComp.readDogTexture(compound, this::setSkinHash);
        }
        if (compound.func_150297_b("fetchItem", 10)) {
            this.setBoneVariant(NBTUtil.readItemStack(compound, "fetchItem"));
        } else {
            BackwardsComp.readHasBone(compound, this::setBoneVariant);
        }
        this.setHungerDirectly(compound.func_74760_g("dogHunger"));
        this.setOwnersName(NBTUtil.getTextComponent(compound, "lastKnownOwnerName"));
        this.setWillObeyOthers(compound.func_74767_n("willObey"));
        this.setCanPlayersAttack(compound.func_74767_n("friendlyFire"));
        if (compound.func_150297_b("dogSize", 99)) {
            this.setDogSize(compound.func_74762_e("dogSize"));
        }
        if (compound.func_150297_b("level_normal", 99)) {
            this.getLevel().setLevel(DogLevel.Type.NORMAL, compound.func_74762_e("level_normal"));
            this.markDataParameterDirty(DOG_LEVEL.get());
        }
        if (compound.func_150297_b("level_dire", 99)) {
            this.getLevel().setLevel(DogLevel.Type.DIRE, compound.func_74762_e("level_dire"));
            this.markDataParameterDirty(DOG_LEVEL.get());
        }
        DimensionDependantArg<Optional<BlockPos>> bedsData = ((DimensionDependantArg)this.field_70180_af.func_187225_a(DOG_BED_LOCATION.get())).copyEmpty();
        if (compound.func_150297_b("beds", 9)) {
            ListNBT bedsList = compound.func_150295_c("beds", 10);
            for (int i = 0; i < bedsList.size(); ++i) {
                CompoundNBT bedNBT = bedsList.func_150305_b(i);
                ResourceLocation loc = NBTUtil.getResourceLocation(bedNBT, "dim");
                Optional type = Registry.field_212622_k.func_218349_b(loc);
                if (type.isPresent()) {
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bedNBT, "pos");
                    bedsData.put((DimensionType)type.get(), pos);
                    continue;
                }
                DoggyTalents2.LOGGER.warn("Failed loading from NBT. Could not find dimension {}", (Object)loc);
            }
        } else {
            BackwardsComp.readBedLocations(compound, bedsData);
        }
        this.field_70180_af.func_187227_b(DOG_BED_LOCATION.get(), bedsData);
        DimensionDependantArg<Optional<BlockPos>> bowlsData = ((DimensionDependantArg)this.field_70180_af.func_187225_a(DOG_BOWL_LOCATION.get())).copyEmpty();
        if (compound.func_150297_b("bowls", 9)) {
            ListNBT bowlsList = compound.func_150295_c("bowls", 10);
            for (int i = 0; i < bowlsList.size(); ++i) {
                CompoundNBT bowlsNBT = bowlsList.func_150305_b(i);
                ResourceLocation loc = NBTUtil.getResourceLocation(bowlsNBT, "dim");
                Optional type = Registry.field_212622_k.func_218349_b(loc);
                if (type.isPresent()) {
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bowlsNBT, "pos");
                    bowlsData.put((DimensionType)type.get(), pos);
                    continue;
                }
                DoggyTalents2.LOGGER.warn("Failed loading from NBT. Could not find dimension {}", (Object)loc);
            }
        } else {
            BackwardsComp.readBowlLocations(compound, bowlsData);
        }
        this.field_70180_af.func_187227_b(DOG_BOWL_LOCATION.get(), bowlsData);
        this.statsTracker.readAdditional(compound);
        this.alterations.forEach(alter -> alter.onRead(this, compound));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (TALENTS.get().equals(key) || ACCESSORIES.get().equals(key)) {
            this.recalculateAlterationsCache();
        }
        if (TALENTS.get().equals(key)) {
            for (TalentInstance inst : this.getTalentMap()) {
                inst.init(this);
            }
            this.spendablePoints.markForRefresh();
        }
        if (DOG_LEVEL.get().equals(key)) {
            this.spendablePoints.markForRefresh();
        }
        if (ACCESSORIES.get().equals(key) && this.field_70170_p.field_72995_K) {
            this.getAccessories().sort(AccessoryInstance.RENDER_SORTER);
        }
        if (SIZE.equals(key)) {
            this.func_213323_x_();
        }
    }

    public void recalculateAlterationsCache() {
        this.alterations.clear();
        this.foodHandlers.clear();
        for (AccessoryInstance inst : this.getAccessories()) {
            if (inst instanceof IDogAlteration) {
                this.alterations.add((IDogAlteration)((Object)inst));
            }
            if (!(inst instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)inst));
        }
        List<TalentInstance> talents = this.getTalentMap();
        this.alterations.addAll(talents);
        for (TalentInstance inst : talents) {
            if (!(inst instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)inst));
        }
    }

    @Override
    public boolean canInteract(LivingEntity livingEntity) {
        return this.willObeyOthers() || this.func_152114_e(livingEntity);
    }

    @Override
    public List<AccessoryInstance> getAccessories() {
        return (List)this.field_70180_af.func_187225_a(ACCESSORIES.get());
    }

    @Override
    public boolean addAccessory(@Nonnull AccessoryInstance accessoryInst) {
        List<AccessoryInstance> accessories = this.getAccessories();
        AccessoryType type = accessoryInst.getAccessory().getType();
        List filtered = accessories.stream().filter(inst -> type == inst.getAccessory().getType()).collect(Collectors.toList());
        if (filtered.size() >= type.numberToPutOn()) {
            return false;
        }
        accessories.add(accessoryInst);
        this.markDataParameterDirty(ACCESSORIES.get());
        return true;
    }

    @Override
    public List<AccessoryInstance> removeAccessories() {
        ArrayList removed = Lists.newArrayList(this.getAccessories());
        this.getAccessories().clear();
        this.markDataParameterDirty(ACCESSORIES.get());
        return removed;
    }

    public Optional<AccessoryInstance> getAccessory(AccessoryType typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory().getType() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<AccessoryInstance> getAccessory(Accessory typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<ITextComponent> getOwnersName() {
        return (Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME);
    }

    public void setOwnersName(@Nullable ITextComponent comp) {
        this.setOwnersName(Optional.ofNullable(comp));
    }

    public void setOwnersName(Optional<ITextComponent> collar) {
        this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, collar);
    }

    public EnumGender getGender() {
        return (EnumGender)((Object)this.field_70180_af.func_187225_a(GENDER.get()));
    }

    public void setGender(EnumGender collar) {
        this.field_70180_af.func_187227_b(GENDER.get(), (Object)collar);
    }

    @Override
    public EnumMode getMode() {
        return (EnumMode)((Object)this.field_70180_af.func_187225_a(MODE.get()));
    }

    public boolean isMode(EnumMode ... modes) {
        EnumMode mode = this.getMode();
        for (EnumMode test : modes) {
            if (mode != test) continue;
            return true;
        }
        return false;
    }

    public void setMode(EnumMode collar) {
        this.field_70180_af.func_187227_b(MODE.get(), (Object)collar);
    }

    public Optional<BlockPos> getBedPos() {
        return this.getBedPos(this.field_70170_p.func_201675_m().func_186058_p());
    }

    public Optional<BlockPos> getBedPos(DimensionType dim) {
        return ((DimensionDependantArg)this.field_70180_af.func_187225_a(DOG_BED_LOCATION.get())).getOrDefault(dim, Optional.empty());
    }

    public void setBedPos(@Nullable BlockPos pos) {
        this.setBedPos(this.field_70170_p.func_201675_m().func_186058_p(), pos);
    }

    public void setBedPos(DimensionType dim, @Nullable BlockPos pos) {
        this.setBedPos(dim, WorldUtil.toImmutable(pos));
    }

    public void setBedPos(DimensionType dim, Optional<BlockPos> pos) {
        this.field_70180_af.func_187227_b(DOG_BED_LOCATION.get(), ((DimensionDependantArg)this.field_70180_af.func_187225_a(DOG_BED_LOCATION.get())).copy().set(dim, pos));
    }

    public Optional<BlockPos> getBowlPos() {
        return this.getBowlPos(this.field_70170_p.func_201675_m().func_186058_p());
    }

    public Optional<BlockPos> getBowlPos(DimensionType dim) {
        return ((DimensionDependantArg)this.field_70180_af.func_187225_a(DOG_BOWL_LOCATION.get())).getOrDefault(dim, Optional.empty());
    }

    public void setBowlPos(@Nullable BlockPos pos) {
        this.setBowlPos(this.field_70170_p.func_201675_m().func_186058_p(), pos);
    }

    public void setBowlPos(DimensionType dim, @Nullable BlockPos pos) {
        this.setBowlPos(dim, WorldUtil.toImmutable(pos));
    }

    public void setBowlPos(DimensionType dim, Optional<BlockPos> pos) {
        this.field_70180_af.func_187227_b(DOG_BOWL_LOCATION.get(), ((DimensionDependantArg)this.field_70180_af.func_187225_a(DOG_BOWL_LOCATION.get())).copy().set(dim, pos));
    }

    @Override
    public float getMaxHunger() {
        float maxHunger = ConfigValues.DEFAULT_MAX_HUNGER;
        for (IDogAlteration alter : this.alterations) {
            ActionResult<Float> result = alter.getMaxHunger(this, maxHunger);
            if (!result.func_188397_a().func_226247_b_()) continue;
            maxHunger = ((Float)result.func_188398_b()).floatValue();
        }
        return maxHunger;
    }

    @Override
    public float getDogHunger() {
        return ((Float)this.field_70180_af.func_187225_a(HUNGER_INT)).floatValue();
    }

    @Override
    public void addHunger(float add) {
        this.setDogHunger(this.getDogHunger() + add);
    }

    @Override
    public void setDogHunger(float hunger) {
        float diff = hunger - this.getDogHunger();
        for (IDogAlteration alter : this.alterations) {
            ActionResult<Float> result = alter.setDogHunger(this, hunger, diff);
            if (!result.func_188397_a().func_226247_b_()) continue;
            hunger = ((Float)result.func_188398_b()).floatValue();
            diff = hunger - this.getDogHunger();
        }
        this.setHungerDirectly(MathHelper.func_76131_a((float)hunger, (float)0.0f, (float)this.getMaxHunger()));
    }

    private void setHungerDirectly(float hunger) {
        this.field_70180_af.func_187227_b(HUNGER_INT, (Object)Float.valueOf(hunger));
    }

    public boolean hasCustomSkin() {
        return !Strings.isNullOrEmpty((String)this.getSkinHash());
    }

    public String getSkinHash() {
        return (String)this.field_70180_af.func_187225_a(CUSTOM_SKIN);
    }

    public void setSkinHash(String hash) {
        if (hash == null) {
            hash = "";
        }
        this.field_70180_af.func_187227_b(CUSTOM_SKIN, (Object)hash);
    }

    @Override
    public DogLevel getLevel() {
        return (DogLevel)this.field_70180_af.func_187225_a(DOG_LEVEL.get());
    }

    public void setLevel(DogLevel level) {
        this.field_70180_af.func_187227_b(DOG_LEVEL.get(), (Object)level);
    }

    @Override
    public void increaseLevel(DogLevel.Type typeIn) {
        this.getLevel().incrementLevel(typeIn);
        this.markDataParameterDirty(DOG_LEVEL.get());
    }

    @Override
    public void setDogSize(int value) {
        this.field_70180_af.func_187227_b(SIZE, (Object)((byte)Math.min(5, Math.max(1, value))));
    }

    @Override
    public int getDogSize() {
        return ((Byte)this.field_70180_af.func_187225_a(SIZE)).byteValue();
    }

    public void setBoneVariant(ItemStack stack) {
        this.field_70180_af.func_187227_b(BONE_VARIANT, (Object)stack);
    }

    public ItemStack getBoneVariant() {
        return (ItemStack)this.field_70180_af.func_187225_a(BONE_VARIANT);
    }

    @Nullable
    public IThrowableItem getThrowableItem() {
        Item item = ((ItemStack)this.field_70180_af.func_187225_a(BONE_VARIANT)).func_77973_b();
        return item instanceof IThrowableItem ? (IThrowableItem)item : null;
    }

    public boolean hasBone() {
        return !this.getBoneVariant().func_190926_b();
    }

    private boolean getDogFlag(int bit) {
        return ((Byte)this.field_70180_af.func_187225_a(DOG_FLAGS) & bit) != 0;
    }

    private void setDogFlag(int bits, boolean flag) {
        byte c = (Byte)this.field_70180_af.func_187225_a(DOG_FLAGS);
        this.field_70180_af.func_187227_b(DOG_FLAGS, (Object)((byte)(flag ? c | bits : c & ~bits)));
    }

    public void setBegging(boolean begging) {
        this.setDogFlag(1, begging);
    }

    public boolean isBegging() {
        return this.getDogFlag(1);
    }

    public void setWillObeyOthers(boolean obeyOthers) {
        this.setDogFlag(2, obeyOthers);
    }

    public boolean willObeyOthers() {
        return this.getDogFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setDogFlag(4, flag);
    }

    public boolean canPlayersAttack() {
        return this.getDogFlag(4);
    }

    public void set8Flag(boolean collar) {
        this.setDogFlag(8, collar);
    }

    public boolean get8Flag() {
        return this.getDogFlag(8);
    }

    public void setHasSunglasses(boolean sunglasses) {
        this.setDogFlag(16, sunglasses);
    }

    public boolean hasSunglasses() {
        return this.getDogFlag(16);
    }

    public void setLyingDown(boolean lying) {
        this.setDogFlag(32, lying);
    }

    public boolean isLyingDown() {
        return this.getDogFlag(32);
    }

    public void set64Flag(boolean lying) {
        this.setDogFlag(64, lying);
    }

    public boolean get64Flag() {
        return this.getDogFlag(64);
    }

    public List<TalentInstance> getTalentMap() {
        return (List)this.field_70180_af.func_187225_a(TALENTS.get());
    }

    public void setTalentMap(List<TalentInstance> map) {
        this.field_70180_af.func_187227_b(TALENTS.get(), map);
    }

    public ActionResultType setTalentLevel(Talent talent, int level) {
        if (0 > level || level > talent.getMaxLevel()) {
            return ActionResultType.FAIL;
        }
        List<TalentInstance> activeTalents = this.getTalentMap();
        TalentInstance inst = null;
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talent)) continue;
            inst = activeInst;
            break;
        }
        if (inst == null) {
            if (level == 0) {
                return ActionResultType.PASS;
            }
            inst = talent.getDefault(level);
            activeTalents.add(inst);
            inst.init(this);
        } else {
            int previousLevel = inst.level();
            if (previousLevel == level) {
                return ActionResultType.PASS;
            }
            inst.setLevel(level);
            inst.set(this, previousLevel);
            if (level == 0) {
                activeTalents.remove(inst);
            }
        }
        this.markDataParameterDirty(TALENTS.get());
        DoggyTalents2.LOGGER.debug("Set talent {} to level {}", (Object)talent.getRegistryName(), (Object)level);
        return ActionResultType.SUCCESS;
    }

    public <T> void markDataParameterDirty(DataParameter<T> key) {
        this.markDataParameterDirty(key, true);
    }

    public <T> void markDataParameterDirty(DataParameter<T> key, boolean notify) {
        if (notify) {
            this.func_184206_a(key);
        }
        EntityDataManager.DataEntry dataentry = this.field_70180_af.func_187219_c(key);
        dataentry.func_187208_a(true);
        this.field_70180_af.field_187237_f = true;
    }

    @Override
    public void markAccessoriesDirty() {
        this.markDataParameterDirty(ACCESSORIES.get());
    }

    @Override
    public Optional<TalentInstance> getTalent(Talent talentIn) {
        List<TalentInstance> activeTalents = this.getTalentMap();
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talentIn)) continue;
            return Optional.of(activeInst);
        }
        return Optional.empty();
    }

    @Override
    public int getLevel(Talent talentIn) {
        return this.getTalent(talentIn).map(TalentInstance::level).orElse(0);
    }

    @Override
    public <T> void setData(DataKey<T> key, T value) {
        if (key.isFinal() && this.hasData(key)) {
            throw new RuntimeException("Key is final but was tried to be set again.");
        }
        this.objects.put(key.getIndex(), value);
    }

    @Override
    public <T> void setDataIfEmpty(DataKey<T> key, T value) {
        if (!this.hasData(key)) {
            this.objects.put(key.getIndex(), value);
        }
    }

    @Override
    public <T> T getData(DataKey<T> key) {
        return (T)this.objects.get(key.getIndex());
    }

    @Override
    public <T> T getDataOrGet(DataKey<T> key, Supplier<T> other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other.get();
    }

    @Override
    public <T> T getDataOrDefault(DataKey<T> key, T other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other;
    }

    @Override
    public <T> boolean hasData(DataKey<T> key) {
        return this.objects.containsKey(key.getIndex());
    }

    @Override
    public void untame() {
        this.func_70903_f(false);
        this.field_70699_by.func_75499_g();
        this.field_70911_d.func_75270_a(false);
        this.func_70606_j(8.0f);
        this.getTalentMap().clear();
        this.markDataParameterDirty(TALENTS.get());
        this.func_184754_b(null);
        this.setWillObeyOthers(false);
        this.setMode(EnumMode.DOCILE);
        DoggyTalents2.LOGGER.debug("Untamed dog");
    }

    public boolean canSpendPoints(int amount) {
        return this.getSpendablePoints() >= amount || this.getAccessory((Accessory)DoggyAccessories.GOLDEN_COLLAR.get()).isPresent();
    }

    private final int getSpendablePointsInternal() {
        int totalPoints = 15 + this.getLevel().getLevel(DogLevel.Type.NORMAL) + this.getLevel().getLevel(DogLevel.Type.DIRE);
        for (TalentInstance entry : this.getTalentMap()) {
            totalPoints -= entry.getTalent().getCummulativeCost(entry.level());
        }
        return totalPoints;
    }

    public int getSpendablePoints() {
        return this.spendablePoints.get();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    public boolean func_70067_L() {
        return super.func_70067_L();
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI() && super.func_70104_M();
    }

    public boolean func_184186_bw() {
        return super.func_184186_bw() && this.canInteract((LivingEntity)this.func_184179_bs());
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public void setJumpPower(int jumpPowerIn) {
        this.jumpPower = 1.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void func_213352_e(Vec3d positionIn) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF()) {
                double changeY;
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                this.field_70138_W = 1.0f;
                float straf = livingentity.field_70702_br * 0.7f;
                float foward = livingentity.field_191988_bg;
                if (foward <= 0.0f) {
                    foward *= 0.5f;
                }
                if (this.jumpPower > 0.0f && !this.isDogJumping() && this.field_70122_E) {
                    double jumpValue = this.func_110148_a(JUMP_STRENGTH).func_111126_e() * (double)this.func_226269_ah_() * (double)this.jumpPower;
                    if (this.func_70644_a(Effects.field_76430_j)) {
                        jumpValue += (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f);
                    }
                    Vec3d vec3d = this.func_213322_ci();
                    this.func_213293_j(vec3d.field_72450_a, jumpValue, vec3d.field_72449_c);
                    this.setDogJumping(true);
                    this.field_70160_al = true;
                    if (foward > 0.0f) {
                        float amount = 0.4f;
                        float compX = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float compZ = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * compX * this.jumpPower), 0.0, (double)(0.4f * compZ * this.jumpPower)));
                    }
                    this.jumpPower = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f);
                    super.func_213352_e(new Vec3d((double)straf, positionIn.field_72448_b, (double)foward));
                    this.field_70716_bi = 0;
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.jumpPower = 0.0f;
                    this.setDogJumping(false);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double changeX = this.func_226277_ct_() - this.field_70169_q;
                float f4 = MathHelper.func_76133_a((double)(changeX * changeX + (changeY = this.func_226281_cx_() - this.field_70166_s) * changeY)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70138_W = 0.5f;
                this.field_70747_aH = 0.02f;
                super.func_213352_e(positionIn);
            }
            this.addMovementStat(this.func_226277_ct_() - this.field_70169_q, this.func_226278_cu_() - this.field_70167_r, this.func_226281_cx_() - this.field_70166_s);
        }
    }

    public void addMovementStat(double xD, double yD, double zD) {
        int j;
        if (this.func_184207_aI()) {
            j = Math.round(MathHelper.func_76133_a((double)(xD * xD + zD * zD)) * 100.0f);
            this.statsTracker.increaseDistanceRidden(j);
        }
        if (!this.func_184218_aH()) {
            if (this.func_213290_a(FluidTags.field_206959_a, true)) {
                j = Math.round(MathHelper.func_76133_a((double)(xD * xD + yD * yD + zD * zD)) * 100.0f);
                if (j > 0) {
                    this.statsTracker.increaseDistanceOnWater(j);
                }
            } else if (this.func_70090_H()) {
                int k = Math.round(MathHelper.func_76133_a((double)(xD * xD + zD * zD)) * 100.0f);
                if (k > 0) {
                    this.statsTracker.increaseDistanceInWater(k);
                }
            } else if (this.field_70122_E) {
                int l = Math.round(MathHelper.func_76133_a((double)(xD * xD + zD * zD)) * 100.0f);
                if (l > 0) {
                    if (this.func_70051_ag()) {
                        this.statsTracker.increaseDistanceSprint(l);
                    } else if (this.func_213453_ef()) {
                        this.statsTracker.increaseDistanceSneaking(l);
                    } else {
                        this.statsTracker.increaseDistanceWalk(l);
                    }
                }
            } else {
                int n = Math.round(MathHelper.func_76133_a((double)(xD * xD + zD * zD)) * 100.0f);
            }
        }
    }

    @Override
    public TranslationTextComponent getTranslationKey(Function<EnumGender, String> function) {
        return new TranslationTextComponent((String)function.apply((Object)(ConfigValues.DOG_GENDER ? this.getGender() : EnumGender.UNISEX)), new Object[0]);
    }

    @Override
    public boolean isLying() {
        boolean onBed;
        boolean ownerSleeping;
        LivingEntity owner = this.func_70902_q();
        boolean bl = ownerSleeping = owner != null && owner.func_70608_bn();
        if (ownerSleeping) {
            return true;
        }
        Block blockBelow = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c();
        boolean bl2 = onBed = blockBelow == DoggyBlocks.DOG_BED.get() || BlockTags.field_219747_F.func_199685_a_((Object)blockBelow);
        return onBed;
    }

    @Override
    public List<IDogFoodHandler> getFoodHandlers() {
        return this.foodHandlers;
    }

    public void setTargetBlock(BlockPos pos) {
        this.targetBlock = pos;
    }

    public BlockPos getTargetBlock() {
        return this.targetBlock;
    }
}

