/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTalents2;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.tileentity.PlacedTileEntity;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class DogBedTileEntity
extends PlacedTileEntity {
    private ICasingMaterial casingType = null;
    private IBeddingMaterial beddingType = null;
    public static ModelProperty<ICasingMaterial> CASING = new ModelProperty();
    public static ModelProperty<IBeddingMaterial> BEDDING = new ModelProperty();
    public static ModelProperty<Direction> FACING = new ModelProperty();
    @Deprecated
    @Nullable
    private DogEntity dog;
    @Nullable
    private UUID dogUUID;
    @Nullable
    private ITextComponent name;
    @Nullable
    private ITextComponent ownerName;

    public DogBedTileEntity() {
        super((TileEntityType)DoggyTileEntityTypes.DOG_BED.get());
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.casingType = NBTUtil.getRegistryValue(compound, "casingId", DoggyTalentsAPI.CASING_MATERIAL);
        this.beddingType = NBTUtil.getRegistryValue(compound, "beddingId", DoggyTalentsAPI.BEDDING_MATERIAL);
        this.dogUUID = NBTUtil.getUniqueId(compound, "ownerId");
        this.name = NBTUtil.getTextComponent(compound, "name");
        this.ownerName = NBTUtil.getTextComponent(compound, "ownerName");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        NBTUtil.putRegistryValue(compound, "casingId", this.casingType);
        NBTUtil.putRegistryValue(compound, "beddingId", this.beddingType);
        NBTUtil.putUniqueId(compound, "ownerId", this.dogUUID);
        NBTUtil.putTextComponent(compound, "name", this.name);
        NBTUtil.putTextComponent(compound, "ownerName", this.ownerName);
        return compound;
    }

    public void setCasing(ICasingMaterial casingType) {
        this.casingType = casingType;
        this.func_70296_d();
        this.requestModelDataUpdate();
    }

    public void setBedding(IBeddingMaterial beddingType) {
        this.beddingType = beddingType;
        this.func_70296_d();
        this.requestModelDataUpdate();
    }

    public ICasingMaterial getCasing() {
        return this.casingType;
    }

    public IBeddingMaterial getBedding() {
        return this.beddingType;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(CASING, (Object)this.casingType).withInitial(BEDDING, (Object)this.beddingType).withInitial(FACING, (Object)Direction.NORTH).build();
    }

    public void setOwner(@Nullable DogEntity owner) {
        this.setOwner(owner == null ? null : owner.func_110124_au());
        this.ownerName = owner == null ? null : owner.func_200200_C_();
        this.dog = owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.dog = null;
        this.dogUUID = owner;
        this.func_70296_d();
        DoggyTalents2.LOGGER.debug("Set bed owner to {}", (Object)owner);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.dogUUID;
    }

    @Nullable
    public DogEntity getOwner() {
        return WorldUtil.getCachedEntity(this.field_145850_b, DogEntity.class, this.dog, this.dogUUID);
    }

    @Nullable
    public ITextComponent getBedName() {
        return this.name;
    }

    @Nullable
    public ITextComponent getOwnerName() {
        return this.ownerName;
    }

    public boolean shouldDisplayName(LivingEntity camera) {
        return true;
    }

    public void setBedName(@Nullable ITextComponent nameIn) {
        this.name = nameIn;
        this.func_70296_d();
    }

    public void setOwnerName(@Nullable ITextComponent nameIn) {
        this.ownerName = nameIn;
        this.func_70296_d();
    }
}

