/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common;

import doggytalents.DoggyItems;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.common.block.tileentity.FoodBowlTileEntity;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.PackPuppyContainer;
import doggytalents.common.inventory.container.TreatBagContainer;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

public class Screens {
    public static void openPackPuppyScreen(ServerPlayerEntity player, AbstractDogEntity dogIn) {
        if (dogIn.func_70089_S()) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new PackPuppyContainerProvider(dogIn), buf -> buf.writeInt(dogIn.func_145782_y()));
        }
    }

    public static void openDogInventoriesScreen(ServerPlayerEntity player, List<DogEntity> dogIn) {
        if (!dogIn.isEmpty()) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new DogInventoriesContainerProvider(dogIn), buf -> {
                buf.writeInt(dogIn.size());
                for (DogEntity dog : dogIn) {
                    buf.writeInt(dog.func_145782_y());
                }
            });
        }
    }

    public static void openFoodBowlScreen(ServerPlayerEntity player, FoodBowlTileEntity foodBowl) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)foodBowl, (BlockPos)foodBowl.func_174877_v());
    }

    public static void openTreatBagScreen(ServerPlayerEntity player, ItemStack stackIn, int slotId) {
        if (stackIn.func_77973_b() == DoggyItems.TREAT_BAG.get()) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new TreatBagContainerProvider(stackIn, slotId), buf -> {
                buf.func_150787_b(slotId);
                buf.func_150788_a(stackIn);
            });
        }
    }

    public static class TreatBagContainerProvider
    implements INamedContainerProvider {
        private ItemStack stack;
        private int slotId;

        public TreatBagContainerProvider(ItemStack stackIn, int slotId) {
            this.stack = stackIn;
            this.slotId = slotId;
        }

        public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
            return new TreatBagContainer(windowId, inventory, this.slotId, this.stack);
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.doggytalents.treat_bag", new Object[0]);
        }
    }

    public static class DogInventoriesContainerProvider
    implements INamedContainerProvider {
        private List<DogEntity> dogs;

        public DogInventoriesContainerProvider(List<DogEntity> dogIn) {
            this.dogs = dogIn;
        }

        public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
            IntArray array = new IntArray(this.dogs.size());
            for (int i = 0; i < array.func_221478_a(); ++i) {
                array.func_221477_a(i, this.dogs.get(i).func_145782_y());
            }
            return new DogInventoriesContainer(windowId, inventory, array);
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.doggytalents.dog_inventories", new Object[0]);
        }
    }

    public static class PackPuppyContainerProvider
    implements INamedContainerProvider {
        private AbstractDogEntity dog;

        public PackPuppyContainerProvider(AbstractDogEntity dogIn) {
            this.dog = dogIn;
        }

        public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
            return new PackPuppyContainer(windowId, inventory, this.dog);
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.doggytalents.pack_puppy", new Object[0]);
        }
    }
}

