/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.google.common.collect.Lists;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyTalents2;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.Talent;
import doggytalents.client.DogTextureManager;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.common.config.ConfigValues;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogModeData;
import doggytalents.common.network.packet.data.DogNameData;
import doggytalents.common.network.packet.data.DogObeyData;
import doggytalents.common.network.packet.data.DogTalentData;
import doggytalents.common.network.packet.data.DogTextureData;
import doggytalents.common.network.packet.data.FriendlyFireData;
import doggytalents.common.network.packet.data.SendSkinData;
import doggytalents.common.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class DogInfoScreen
extends Screen {
    public final DogEntity dog;
    public final PlayerEntity player;
    private int currentPage = 0;
    private int maxPages = 1;
    private List<Widget> talentWidgets = new ArrayList<Widget>(16);
    private Button leftBtn;
    private Button rightBtn;
    private List<Talent> talentList;
    private List<ResourceLocation> customSkinList;
    public int textureIndex;

    public DogInfoScreen(DogEntity dog, PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("doggytalents.screen.dog.title", new Object[0]));
        this.dog = dog;
        this.player = player;
        this.talentList = DoggyTalentsAPI.TALENTS.getValues().stream().sorted(Comparator.comparing(t -> I18n.func_135052_a((String)t.getTranslationKey(), (Object[])new Object[0]))).collect(Collectors.toList());
        this.customSkinList = DogTextureManager.INSTANCE.getAll();
        this.textureIndex = this.customSkinList.indexOf(DogTextureManager.INSTANCE.getTextureLoc(dog.getSkinHash()));
        this.textureIndex = this.textureIndex >= 0 ? this.textureIndex : 0;
    }

    public static void open(DogEntity dog) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((Screen)new DogInfoScreen(dog, (PlayerEntity)mc.field_71439_g));
    }

    public void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        int topX = this.width / 2;
        int topY = this.height / 2;
        TextFieldWidget nameTextField = new TextFieldWidget(this.font, topX - 100, topY + 50, 200, 20, "");
        nameTextField.func_212954_a(text -> PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogNameData(this.dog.func_145782_y(), (String)text)));
        nameTextField.func_146195_b(false);
        nameTextField.func_146203_f(32);
        if (this.dog.func_145818_k_()) {
            nameTextField.func_146180_a(this.dog.func_200201_e().func_150261_e());
        }
        this.addButton((Widget)nameTextField);
        if (this.dog.func_152114_e((LivingEntity)this.player)) {
            Button obeyBtn = new Button(this.width - 64, topY + 77, 42, 20, String.valueOf(this.dog.willObeyOthers()), btn -> {
                btn.setMessage(String.valueOf(!this.dog.willObeyOthers()));
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogObeyData(this.dog.func_145782_y(), !this.dog.willObeyOthers()));
            });
            this.addButton((Widget)obeyBtn);
        }
        Button attackPlayerBtn = new Button(this.width - 64, topY - 5, 42, 20, String.valueOf(this.dog.canPlayersAttack()), button -> {
            button.setMessage(String.valueOf(!this.dog.canPlayersAttack()));
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new FriendlyFireData(this.dog.func_145782_y(), !this.dog.canPlayersAttack()));
        });
        this.addButton((Widget)attackPlayerBtn);
        Button addBtn = new Button(this.width - 42, topY + 30, 20, 20, "+", btn -> {
            ++this.textureIndex;
            this.textureIndex %= this.customSkinList.size();
            ResourceLocation rl = this.customSkinList.get(this.textureIndex);
            this.setDogTexture(rl);
        });
        Button lessBtn = new Button(this.width - 64, topY + 30, 20, 20, "-", btn -> {
            this.textureIndex += this.customSkinList.size() - 1;
            this.textureIndex %= this.customSkinList.size();
            ResourceLocation rl = this.customSkinList.get(this.textureIndex);
            this.setDogTexture(rl);
        });
        this.addButton((Widget)addBtn);
        this.addButton((Widget)lessBtn);
        Button modeBtn = new Button(topX + 40, topY + 25, 60, 20, I18n.func_135052_a((String)this.dog.getMode().getUnlocalisedName(), (Object[])new Object[0]), button -> {
            EnumMode mode = this.dog.getMode().nextMode();
            if (mode == EnumMode.WANDERING && !this.dog.getBowlPos().isPresent()) {
                button.setMessage(TextFormatting.RED + I18n.func_135052_a((String)mode.getUnlocalisedName(), (Object[])new Object[0]));
            } else {
                button.setMessage(I18n.func_135052_a((String)mode.getUnlocalisedName(), (Object[])new Object[0]));
            }
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogModeData(this.dog.func_145782_y(), mode));
        }){

            public void renderToolTip(int mouseX, int mouseY) {
                ArrayList<String> list = new ArrayList<String>();
                String str = I18n.func_135052_a((String)DogInfoScreen.this.dog.getMode().getUnlocalisedInfo(), (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, DogInfoScreen.this.font));
                if (DogInfoScreen.this.dog.getMode() == EnumMode.WANDERING) {
                    if (DogInfoScreen.this.dog.getBowlPos().isPresent()) {
                        double distance = DogInfoScreen.this.dog.func_180425_c().func_177951_i((Vec3i)DogInfoScreen.this.dog.getBowlPos().get());
                        if (distance > 256.0) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"dog.mode.docile.distance", (Object[])new Object[]{(int)Math.sqrt(distance)}));
                        } else {
                            list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"dog.mode.docile.bowl", (Object[])new Object[]{(int)Math.sqrt(distance)}));
                        }
                    } else {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"dog.mode.docile.nobowl", (Object[])new Object[0]));
                    }
                }
                DogInfoScreen.this.renderTooltip(list, mouseX, mouseY, DogInfoScreen.this.font);
            }
        };
        this.addButton((Widget)modeBtn);
        int size = DoggyTalentsAPI.TALENTS.getKeys().size();
        int perPage = Math.max(MathHelper.func_76128_c((double)((double)(this.height - 10) / 21.0)) - 2, 1);
        this.currentPage = 0;
        this.recalculatePage(perPage);
        if (perPage < size) {
            this.leftBtn = new Button(25, perPage * 21 + 10, 20, 20, "<", btn -> {
                this.currentPage = Math.max(0, this.currentPage - 1);
                btn.active = this.currentPage > 0;
                this.rightBtn.active = true;
                this.recalculatePage(perPage);
            }){

                public void renderToolTip(int mouseX, int mouseY) {
                    ArrayList list = Lists.newArrayList((Object[])new String[]{TextFormatting.ITALIC + I18n.func_135052_a((String)"doggui.prevpage", (Object[])new Object[0])});
                    DogInfoScreen.this.renderTooltip(list, mouseX, mouseY, DogInfoScreen.this.font);
                }
            };
            this.leftBtn.active = false;
            this.rightBtn = new Button(48, perPage * 21 + 10, 20, 20, ">", btn -> {
                this.currentPage = Math.min(this.maxPages - 1, this.currentPage + 1);
                btn.active = this.currentPage < this.maxPages - 1;
                this.leftBtn.active = true;
                this.recalculatePage(perPage);
            }){

                public void renderToolTip(int mouseX, int mouseY) {
                    ArrayList list = Lists.newArrayList((Object[])new String[]{TextFormatting.ITALIC + I18n.func_135052_a((String)"doggui.nextpage", (Object[])new Object[0])});
                    DogInfoScreen.this.renderTooltip(list, mouseX, mouseY, DogInfoScreen.this.font);
                }
            };
            this.addButton((Widget)this.leftBtn);
            this.addButton((Widget)this.rightBtn);
        }
    }

    private void setDogTexture(ResourceLocation rl) {
        if (ConfigValues.SEND_SKIN) {
            try {
                byte[] data = DogTextureManager.INSTANCE.getResourceBytes(rl);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new SendSkinData(this.dog.func_145782_y(), data));
            }
            catch (IOException e) {
                DoggyTalents2.LOGGER.error("Was unable to get resource data for {}, {}", (Object)rl, (Object)e);
            }
        } else {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTextureData(this.dog.func_145782_y(), DogTextureManager.INSTANCE.getTextureHash(rl)));
        }
    }

    private void recalculatePage(int perPage) {
        int index;
        this.talentWidgets.forEach(this::removeWidget);
        this.talentWidgets.clear();
        this.maxPages = MathHelper.func_76143_f((double)((double)this.talentList.size() / (double)perPage));
        for (int i = 0; i < perPage && (index = this.currentPage * perPage + i) < this.talentList.size(); ++i) {
            Talent talent = this.talentList.get(index);
            TalentButton button = new TalentButton(25, 10 + i * 21, 20, 20, "+", talent, btn -> {
                int level = this.dog.getLevel(talent);
                if (level < talent.getMaxLevel() && this.dog.canSpendPoints(talent.getLevelCost(level + 1))) {
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTalentData(this.dog.func_145782_y(), talent));
                }
            }){

                public void renderToolTip(int mouseX, int mouseY) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(TextFormatting.GREEN + I18n.func_135052_a((String)this.talent.getTranslationKey(), (Object[])new Object[0]));
                    if (this.active) {
                        list.add("Level: " + DogInfoScreen.this.dog.getLevel(this.talent));
                        list.add(TextFormatting.GRAY + "--------------------------------");
                        list.addAll(ScreenUtil.splitInto(I18n.func_135052_a((String)this.talent.getInfoTranslationKey(), (Object[])new Object[0]), 200, DogInfoScreen.this.font));
                    } else {
                        list.add(TextFormatting.RED + "Talent disabled");
                    }
                    DogInfoScreen.this.renderTooltip(list, mouseX, mouseY, DogInfoScreen.this.font);
                }
            };
            button.active = !ConfigValues.DISABLED_TALENTS.contains((Object)talent);
            this.talentWidgets.add((Widget)button);
            this.addButton((Widget)button);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int topX = this.width / 2;
        int topY = this.height / 2;
        this.renderBackground();
        String health = Util.format1DP(this.dog.func_110143_aJ());
        String healthMax = Util.format1DP(this.dog.func_110138_aP());
        String speedValue = Util.format2DP(this.dog.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        String ageValue = Util.format2DP(this.dog.func_70874_b());
        String ageRel = I18n.func_135052_a((String)(this.dog.func_70631_g_() ? "doggui.age.baby" : "doggui.age.adult"), (Object[])new Object[0]);
        String ageString = ageValue + " " + ageRel;
        String tamedString = "";
        if (this.dog.func_70909_n()) {
            if (this.dog.func_152114_e((LivingEntity)this.player)) {
                tamedString = I18n.func_135052_a((String)"doggui.owner.you", (Object[])new Object[0]);
            } else if (this.dog.getOwnersName().isPresent()) {
                tamedString = this.dog.getOwnersName().get().func_150254_d();
            }
        }
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.speed", (Object[])new Object[0]) + " " + speedValue, (float)(this.width - 160), (float)(topY - 100), 0xFFFFFF);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.owner", (Object[])new Object[0]) + " " + tamedString, (float)(this.width - 160), (float)(topY - 90), 0xFFFFFF);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.age", (Object[])new Object[0]) + " " + ageString, (float)(this.width - 160), (float)(topY - 80), 0xFFFFFF);
        if (ConfigValues.DOG_GENDER) {
            this.font.func_211126_b(I18n.func_135052_a((String)"doggui.gender", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)this.dog.getGender().getUnlocalisedName(), (Object[])new Object[0]), (float)(this.width - 160), (float)(topY - 70), 0xFFFFFF);
        }
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.newname", (Object[])new Object[0]), (float)(topX - 100), (float)(topY + 38), 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.level", (Object[])new Object[0]) + " " + this.dog.getLevel().getLevel(DogLevel.Type.NORMAL), (float)(topX - 65), (float)(topY + 75), 16716025);
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.leveldire", (Object[])new Object[0]) + " " + this.dog.getLevel().getLevel(DogLevel.Type.DIRE), (float)topX, (float)(topY + 75), 16716025);
        if (this.dog.getAccessory((Accessory)DoggyAccessories.GOLDEN_COLLAR.get()).isPresent()) {
            this.font.func_211126_b(TextFormatting.GOLD + "Unlimited Points", (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        } else {
            this.font.func_211126_b(I18n.func_135052_a((String)"doggui.pointsleft", (Object[])new Object[0]) + " " + this.dog.getSpendablePoints(), (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        }
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.textureindex", (Object[])new Object[0]), (float)(this.width - 80), (float)(topY + 20), 0xFFFFFF);
        this.font.func_211126_b(this.dog.getSkinHash().substring(0, Math.min(this.dog.getSkinHash().length(), 10)), (float)(this.width - 73), (float)(topY + 54), 0xFFFFFF);
        if (this.dog.func_152114_e((LivingEntity)this.player)) {
            this.font.func_211126_b(I18n.func_135052_a((String)"doggui.obeyothers", (Object[])new Object[0]), (float)(this.width - 76), (float)(topY + 67), 0xFFFFFF);
        }
        this.font.func_211126_b(I18n.func_135052_a((String)"doggui.friendlyfire", (Object[])new Object[0]), (float)(this.width - 76), (float)(topY - 15), 0xFFFFFF);
        this.buttons.forEach(widget -> {
            if (widget instanceof TalentButton) {
                TalentButton talBut = (TalentButton)((Object)widget);
                this.font.func_211126_b(I18n.func_135052_a((String)talBut.talent.getTranslationKey(), (Object[])new Object[0]), (float)(talBut.x + 25), (float)(talBut.y + 7), 0xFFFFFF);
            }
        });
        super.render(mouseX, mouseY, partialTicks);
        for (Widget widget2 : this.buttons) {
            if (!widget2.isHovered()) continue;
            widget2.renderToolTip(mouseX, mouseY);
            break;
        }
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected <T extends Widget> T removeWidget(T widgetIn) {
        this.buttons.remove(widgetIn);
        this.children.remove(widgetIn);
        return widgetIn;
    }

    private static class TalentButton
    extends Button {
        protected Talent talent;

        private TalentButton(int x, int y, int widthIn, int heightIn, String buttonText, Talent talent, Consumer<TalentButton> onPress) {
            super(x, y, widthIn, heightIn, buttonText, button -> onPress.accept((TalentButton)button));
            this.talent = talent;
        }
    }
}

