/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyTalents2;
import doggytalents.client.block.model.DogBedModel;
import doggytalents.client.screen.widget.DogInventoryButton;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.OpenDogScreenData;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientEventHandler {
    public static void onModelBakeEvent(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        try {
            ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey(DoggyBlocks.DOG_BED.get());
            ResourceLocation unbakedModelLoc = new ResourceLocation(resourceLocation.func_110624_b(), "block/" + resourceLocation.func_110623_a());
            BlockModel model = (BlockModel)event.getModelLoader().func_209597_a(unbakedModelLoc);
            DogBedModel customModel = new DogBedModel(event.getModelLoader(), model, model.func_228813_a_((ModelBakery)event.getModelLoader(), model, ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X180_Y180, unbakedModelLoc, true));
            ((DogBedBlock)DoggyBlocks.DOG_BED.get()).func_176194_O().func_177619_a().forEach(state -> modelRegistry.put(BlockModelShapes.func_209554_c((BlockState)state), customModel));
            modelRegistry.put(new ModelResourceLocation(resourceLocation, "inventory"), customModel);
        }
        catch (Exception e) {
            DoggyTalents2.LOGGER.warn("Could not get base Dog Bed model. Reverting to default textures...");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onInputEvent(InputUpdateEvent event) {
        if (event.getMovementInput().field_78901_c) {
            DogEntity dog;
            Entity entity = event.getPlayer().func_184187_bx();
            if (event.getPlayer().func_184218_aH() && entity instanceof DogEntity && (dog = (DogEntity)entity).canJump()) {
                dog.setJumpPower(100);
            }
        }
    }

    @SubscribeEvent
    public void onScreenInit(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen screen = event.getGui();
        if (screen instanceof InventoryScreen || screen instanceof CreativeScreen) {
            boolean creative = screen instanceof CreativeScreen;
            Minecraft mc = Minecraft.func_71410_x();
            int width = mc.func_228018_at_().func_198107_o();
            int height = mc.func_228018_at_().func_198087_p();
            int sizeX = creative ? 195 : 176;
            int sizeY = creative ? 136 : 166;
            int guiLeft = (width - sizeX) / 2;
            int guiTop = (height - sizeY) / 2;
            int x = guiLeft + (creative ? 36 : sizeX / 2 - 10);
            int y = guiTop + (creative ? 7 : 48);
            event.addWidget((Widget)new DogInventoryButton(x, y, screen, btn -> {
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new OpenDogScreenData());
                btn.active = false;
            }));
        }
    }

    @SubscribeEvent
    public void onScreenDrawForeground(GuiContainerEvent.DrawForeground event) {
        ContainerScreen screen = event.getGuiContainer();
        if (screen instanceof InventoryScreen || screen instanceof CreativeScreen) {
            boolean creative = screen instanceof CreativeScreen;
            DogInventoryButton btn = null;
            for (Widget widget : screen.buttons) {
                if (!(widget instanceof DogInventoryButton)) continue;
                btn = (DogInventoryButton)widget;
                break;
            }
            if (btn.visible && btn.isHovered()) {
                RecipeBookGui recipeBook;
                Minecraft mc = Minecraft.func_71410_x();
                int width = mc.func_228018_at_().func_198107_o();
                int height = mc.func_228018_at_().func_198087_p();
                int sizeX = creative ? 195 : 176;
                int sizeY = creative ? 136 : 166;
                int guiLeft = (width - sizeX) / 2;
                int guiTop = (height - sizeY) / 2;
                if (!creative && (recipeBook = ((InventoryScreen)screen).func_194310_f()).func_191878_b()) {
                    guiLeft += 76;
                }
                RenderSystem.translated((double)(-guiLeft), (double)(-guiTop), (double)0.0);
                btn.renderToolTip(event.getMouseX(), event.getMouseY());
                RenderSystem.translated((double)guiLeft, (double)guiTop, (double)0.0);
            }
        }
    }

    public void drawSelectionBox(MatrixStack matrixStackIn, PlayerEntity player, float particleTicks, AxisAlignedBB boundingBox) {
        RenderSystem.disableAlphaTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f);
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.disableTexture();
        Vec3d vec3d = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double d0 = vec3d.func_82615_a();
        double d1 = vec3d.func_82617_b();
        double d2 = vec3d.func_82616_c();
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStackIn, (IVertexBuilder)buf, (AxisAlignedBB)boundingBox.func_72317_d(-d0, -d1, -d2), (float)1.0f, (float)1.0f, (float)0.0f, (float)0.8f);
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTHMOUNT) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && mc.field_71439_g.func_184187_bx() instanceof DogEntity) {
                DogEntity dog = (DogEntity)mc.field_71439_g.func_184187_bx();
                int width = mc.func_228018_at_().func_198107_o();
                int height = mc.func_228018_at_().func_198087_p();
                RenderSystem.pushMatrix();
                mc.func_110434_K().func_110577_a(Screen.GUI_ICONS_LOCATION);
                RenderSystem.enableBlend();
                int left = width / 2 + 91;
                int top = height - ForgeIngameGui.right_height;
                ForgeIngameGui.right_height += 10;
                int level = MathHelper.func_76143_f((double)((double)(dog.getDogHunger() / dog.getMaxHunger()) * 20.0));
                for (int i = 0; i < 10; ++i) {
                    int idx = i * 2 + 1;
                    int x = left - i * 8 - 9;
                    int y = top;
                    int icon = 16;
                    int backgound = 12;
                    mc.field_71456_v.blit(x, y, 16 + backgound * 9, 27, 9, 9);
                    if (idx < level) {
                        mc.field_71456_v.blit(x, y, icon + 36, 27, 9, 9);
                        continue;
                    }
                    if (idx != level) continue;
                    mc.field_71456_v.blit(x, y, icon + 45, 27, 9, 9);
                }
                RenderSystem.disableBlend();
                RenderSystem.enableBlend();
                left = width / 2 + 91;
                top = height - ForgeIngameGui.right_height;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                int l6 = dog.func_70086_ai();
                int j7 = dog.func_205010_bg();
                if (dog.func_208600_a(FluidTags.field_206959_a) || l6 < j7) {
                    int air = dog.func_70086_ai();
                    int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
                    int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
                    for (int i = 0; i < full + partial; ++i) {
                        mc.field_71456_v.blit(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
                    }
                    ForgeIngameGui.right_height += 10;
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.popMatrix();
            }
        }
    }
}

