/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.google.common.collect.ImmutableList;
import doggytalents.api.inferface.AbstractDogEntity;
import net.minecraft.client.renderer.entity.model.TintedAgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class DogModel<T extends AbstractDogEntity>
extends TintedAgeableModel<T> {
    public ModelRenderer head;
    public ModelRenderer body;
    public ModelRenderer legBackRight;
    public ModelRenderer legBackLeft;
    public ModelRenderer legFrontRight;
    public ModelRenderer legFrontLeft;
    public ModelRenderer tail;
    public ModelRenderer mane;

    public DogModel() {
        this(0.0f);
    }

    public DogModel(float scaleFactor) {
        float f1 = 13.5f;
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_228301_a_(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scaleFactor);
        this.head.func_78793_a(-1.0f, f1, -7.0f);
        this.body = new ModelRenderer((Model)this, 18, 14);
        this.body.func_228301_a_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scaleFactor);
        this.body.func_78793_a(0.0f, 14.0f, 2.0f);
        this.mane = new ModelRenderer((Model)this, 21, 0);
        this.mane.func_228301_a_(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scaleFactor);
        this.mane.func_78793_a(-1.0f, 14.0f, 2.0f);
        this.legBackRight = new ModelRenderer((Model)this, 0, 18);
        this.legBackRight.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scaleFactor);
        this.legBackRight.func_78793_a(-2.5f, 16.0f, 7.0f);
        this.legBackLeft = new ModelRenderer((Model)this, 0, 18);
        this.legBackLeft.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scaleFactor);
        this.legBackLeft.func_78793_a(0.5f, 16.0f, 7.0f);
        this.legFrontRight = new ModelRenderer((Model)this, 0, 18);
        this.legFrontRight.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scaleFactor);
        this.legFrontRight.func_78793_a(-2.5f, 16.0f, -4.0f);
        this.legFrontLeft = new ModelRenderer((Model)this, 0, 18);
        this.legFrontLeft.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scaleFactor);
        this.legFrontLeft.func_78793_a(0.5f, 16.0f, -4.0f);
        this.tail = new ModelRenderer((Model)this, 9, 18);
        this.tail.func_228301_a_(-0.5f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scaleFactor);
        this.tail.func_78793_a(-0.5f, 12.0f, 8.0f);
        this.tail.func_78784_a(45, 0).func_228300_a_(0.0f, 0.0f, 0.0f, 2.0f, 3.0f, 1.0f).func_78793_a(90.0f, 0.0f, 0.0f);
        this.tail.func_78784_a(43, 19).func_228300_a_(-1.0f, 0.0f, -2.0f, 3.0f, 10.0f, 3.0f).func_78793_a(-1.0f, 12.0f, 8.0f);
        this.head.func_78784_a(16, 14).func_228301_a_(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, scaleFactor);
        this.head.func_78784_a(16, 14).func_228301_a_(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, scaleFactor);
        this.head.func_78784_a(52, 0).func_228301_a_(-3.0f, -3.0f, -1.5f, 1.0f, 5.0f, 3.0f, scaleFactor);
        this.head.func_78784_a(52, 0).func_228301_a_(4.0f, -3.0f, -1.5f, 1.0f, 5.0f, 3.0f, scaleFactor);
        this.head.func_78784_a(18, 0).func_228301_a_(-2.8f, -3.5f, -1.0f, 2.0f, 1.0f, 2.0f, scaleFactor);
        this.head.func_78784_a(18, 0).func_228301_a_(2.8f, -3.5f, -1.0f, 2.0f, 1.0f, 2.0f, scaleFactor);
        this.head.func_78784_a(0, 10).func_228301_a_(-0.5f, 0.0f, -5.0f, 3.0f, 3.0f, 4.0f, scaleFactor);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.legBackRight, (Object)this.legBackLeft, (Object)this.legFrontRight, (Object)this.legFrontLeft, (Object)this.tail, (Object)this.mane);
    }

    public void setLivingAnimations(T dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.field_78796_g = dog.getWagAngle(limbSwing, limbSwingAmount, partialTickTime);
        if (dog.func_70906_o()) {
            if (dog.isLying()) {
                this.head.func_78793_a(-1.0f, 19.5f, -7.0f);
                this.body.func_78793_a(0.0f, 20.0f, 2.0f);
                this.body.field_78795_f = 1.5707964f;
                this.mane.func_78793_a(-1.0f, 20.0f, -2.0f);
                this.mane.field_78795_f = this.body.field_78795_f;
                this.tail.func_78793_a(-1.0f, 18.0f, 8.0f);
                this.legBackRight.func_78793_a(-4.5f, 23.0f, 7.0f);
                this.legBackRight.field_78795_f = -1.5707964f;
                this.legBackLeft.func_78793_a(2.5f, 23.0f, 7.0f);
                this.legBackLeft.field_78795_f = -1.5707964f;
                this.legFrontRight.func_78793_a(-4.5f, 23.0f, -4.0f);
                this.legFrontRight.field_78795_f = -1.5707964f;
                this.legFrontLeft.func_78793_a(2.5f, 23.0f, -4.0f);
                this.legFrontLeft.field_78795_f = -1.5707964f;
            } else {
                if (dog.isLying()) {
                    // empty if block
                }
                this.head.func_78793_a(-1.0f, 13.5f, -7.0f);
                this.mane.func_78793_a(-1.0f, 16.0f, -3.0f);
                this.mane.field_78795_f = 1.2566371f;
                this.mane.field_78796_g = 0.0f;
                this.body.func_78793_a(0.0f, 18.0f, 0.0f);
                this.body.field_78795_f = 0.7853982f;
                this.tail.func_78793_a(-0.5f, 21.0f, 6.0f);
                this.legBackRight.func_78793_a(-2.5f, 22.0f, 2.0f);
                this.legBackRight.field_78795_f = 4.712389f;
                this.legBackLeft.func_78793_a(0.5f, 22.0f, 2.0f);
                this.legBackLeft.field_78795_f = 4.712389f;
                this.legFrontRight.field_78795_f = 5.811947f;
                this.legFrontRight.func_78793_a(-2.49f, 17.0f, -4.0f);
                this.legFrontLeft.field_78795_f = 5.811947f;
                this.legFrontLeft.func_78793_a(0.51f, 17.0f, -4.0f);
                this.head.func_78793_a(-1.0f, 13.5f, -7.0f);
                this.legFrontRight.field_78796_g = 0.0f;
                this.legFrontLeft.field_78796_g = 0.0f;
            }
        } else {
            this.body.func_78793_a(0.0f, 14.0f, 2.0f);
            this.body.field_78795_f = 1.5707964f;
            this.mane.func_78793_a(-1.0f, 14.0f, -3.0f);
            this.mane.field_78795_f = this.body.field_78795_f;
            this.tail.func_78793_a(-0.5f, 12.0f, 8.0f);
            this.legBackRight.func_78793_a(-2.5f, 16.0f, 7.0f);
            this.legBackLeft.func_78793_a(0.5f, 16.0f, 7.0f);
            this.legFrontRight.func_78793_a(-2.5f, 16.0f, -4.0f);
            this.legFrontLeft.func_78793_a(0.5f, 16.0f, -4.0f);
            this.legBackRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.legBackLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.legFrontRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.legFrontLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.head.func_78793_a(-1.0f, 13.5f, -7.0f);
            this.legFrontRight.field_78796_g = 0.0f;
            this.legFrontLeft.field_78796_g = 0.0f;
        }
        this.head.field_78808_h = dog.getInterestedAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
        this.mane.field_78808_h = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.field_78808_h = dog.getShakeAngle(partialTickTime, -0.16f);
        this.tail.field_78808_h = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void setRotationAngles(T dogIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * (dogIn.func_70906_o() && dogIn.isLying() ? 0.005f : (float)Math.PI / 180);
        this.tail.field_78795_f = ageInTicks;
    }
}

