/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.inferface;

import com.google.common.base.Function;
import doggytalents.api.feature.EnumGender;
import doggytalents.api.feature.IDog;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class AbstractDogEntity
extends TameableEntity
implements IDog {
    public static final IAttribute JUMP_STRENGTH = new RangedAttribute((IAttribute)null, "generic.jumpStrength", 0.0, 0.0, 8.0).func_111112_a(true);
    public static final IAttribute CRIT_CHANCE = new RangedAttribute((IAttribute)null, "generic.critChance", 0.0, 0.0, 1.0);
    public static final IAttribute CRIT_BONUS = new RangedAttribute((IAttribute)null, "generic.critBonus", 0.0, 0.0, 1.0);

    protected AbstractDogEntity(EntityType<? extends TameableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void setAttributeModifier(IAttribute attribute, UUID modifierUUID, BiFunction<AbstractDogEntity, UUID, AttributeModifier> modifierGenerator) {
        AttributeModifier newModifier;
        IAttributeInstance attributeInst = this.func_110148_a(attribute);
        AttributeModifier currentModifier = attributeInst.func_111127_a(modifierUUID);
        if (currentModifier != null) {
            attributeInst.func_188479_b(modifierUUID);
        }
        if ((newModifier = modifierGenerator.apply(this, modifierUUID)) != null) {
            attributeInst.func_111121_a(newModifier);
        }
    }

    public void removeAttributeModifier(IAttribute attribute, UUID modifierUUID) {
        this.func_110148_a(attribute).func_188479_b(modifierUUID);
    }

    @Override
    public AbstractDogEntity getDog() {
        return this;
    }

    public float func_70599_aP() {
        return super.func_70599_aP();
    }

    public void func_70908_e(boolean play) {
        super.func_70908_e(play);
    }

    public void consumeItemFromStack(@Nullable Entity entity, ItemStack stack) {
        if (entity instanceof PlayerEntity) {
            super.func_175505_a((PlayerEntity)entity, stack);
        } else {
            stack.func_190918_g(1);
        }
    }

    public abstract TranslationTextComponent getTranslationKey(Function<EnumGender, String> var1);

    public TranslationTextComponent getGenderPronoun() {
        return this.getTranslationKey((Function<EnumGender, String>)((Function)EnumGender::getUnlocalisedPronoun));
    }

    public TranslationTextComponent getGenderSubject() {
        return this.getTranslationKey((Function<EnumGender, String>)((Function)EnumGender::getUnlocalisedSubject));
    }

    public TranslationTextComponent getGenderTitle() {
        return this.getTranslationKey((Function<EnumGender, String>)((Function)EnumGender::getUnlocalisedTitle));
    }

    public TranslationTextComponent getGenderTip() {
        return this.getTranslationKey((Function<EnumGender, String>)((Function)EnumGender::getUnlocalisedTip));
    }

    public TranslationTextComponent getGenderName() {
        return this.getTranslationKey((Function<EnumGender, String>)((Function)EnumGender::getUnlocalisedName));
    }
}

