/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.render;

import com.davenonymous.bonsaitrees2.util.Logz;
import com.davenonymous.libnonymous.render.MultiblockBlockModel;
import com.davenonymous.libnonymous.utils.GsonHelper;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class TreeModels {
    private static HashMap<ResourceLocation, MultiblockBlockModel> treeModels;

    public static void init() {
        Collection resources = Minecraft.func_71410_x().func_195551_G().func_199003_a("models/tree", p -> p.endsWith(".json"));
        ArrayList<MultiblockBlockModel> models = new ArrayList<MultiblockBlockModel>();
        for (ResourceLocation resource : resources) {
            try {
                InputStream is = Minecraft.func_71410_x().func_195551_G().func_199002_a(resource).func_199027_b();
                MultiblockBlockModel model = (MultiblockBlockModel)GsonHelper.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(is)), MultiblockBlockModel.class);
                if (model != null) {
                    models.add(model);
                    continue;
                }
                Logz.warn("Unable to read model from: {}", resource);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        treeModels = new HashMap();
        for (MultiblockBlockModel model : models) {
            if (treeModels.containsKey(model.id)) {
                Logz.warn("Duplicate model for tree: {}.", model.id);
            }
            treeModels.put(model.id, model);
        }
        Logz.info("Found {} tree models.", models.size());
    }

    @Nullable
    public static MultiblockBlockModel get(ResourceLocation treeId) {
        return treeModels.get(treeId);
    }
}

