/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.compat.jei;

import com.davenonymous.bonsaitrees2.BonsaiTrees2;
import com.davenonymous.bonsaitrees2.config.Config;
import com.davenonymous.bonsaitrees2.registry.SoilCompatibility;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingDrop;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees2.registry.soil.SoilInfo;
import com.davenonymous.bonsaitrees2.render.TreeModels;
import com.davenonymous.libnonymous.render.MultiblockBlockModel;
import com.davenonymous.libnonymous.render.MultiblockBlockModelRenderer;
import com.davenonymous.libnonymous.render.RenderTickCounter;
import com.davenonymous.libnonymous.utils.TickTimeHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.AmbientOcclusionStatus;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;
import org.lwjgl.opengl.GL11;

public class BonsaiRecipeWrapper
implements IRecipeCategoryExtension,
ITooltipCallback<ItemStack> {
    SaplingInfo sapling;
    public float[] slotChances;
    public Map<ResourceLocation, Float> tickModifiers;

    public BonsaiRecipeWrapper(SaplingInfo sapling) {
        this.sapling = sapling;
    }

    public void drawInfo(int recipeWidth, int recipeHeight, double mouseX, double mouseY) {
        MultiblockBlockModel model = TreeModels.get(this.sapling.func_199560_c());
        if (model == null) {
            return;
        }
        float angle = (float)RenderTickCounter.renderTicks * 45.0f / 128.0f;
        RenderSystem.pushMatrix();
        RenderSystem.enableAlphaTest();
        RenderSystem.alphaFunc((int)516, (float)0.1f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableFog();
        RenderSystem.disableLighting();
        RenderHelper.func_74518_a();
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        RenderSystem.enableAlphaTest();
        if (Minecraft.func_71379_u()) {
            RenderSystem.shadeModel((int)7425);
        } else {
            RenderSystem.shadeModel((int)7424);
        }
        RenderSystem.disableRescaleNormal();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)216.5f);
        RenderSystem.translatef((float)50.0f, (float)20.0f, (float)0.0f);
        RenderSystem.rotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        double scale = model.getScaleRatio(true);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        double progress = 40.0;
        RenderSystem.scaled((double)progress, (double)progress, (double)progress);
        RenderSystem.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.translatef((float)((float)(model.width + 1) / -2.0f), (float)((float)(model.height + 1) / -2.0f), (float)((float)(model.depth + 1) / -2.0f));
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(AtlasTexture.field_110575_b);
        textureManager.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        GL11.glFrontFace((int)2304);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)builder);
        AmbientOcclusionStatus before = Minecraft.func_71410_x().field_71474_y.field_74348_k;
        Minecraft.func_71410_x().field_71474_y.field_74348_k = AmbientOcclusionStatus.OFF;
        MultiblockBlockModelRenderer.renderModel((MultiblockBlockModel)model, (MatrixStack)new MatrixStack(), (IRenderTypeBuffer)buffer, (int)0xFF0000, (int)OverlayTexture.field_229196_a_, (IWorldReader)BonsaiTrees2.proxy.getClientWorld(), (BlockPos)BonsaiTrees2.proxy.getClientPlayer().func_180425_c());
        Minecraft.func_71410_x().field_71474_y.field_74348_k = before;
        textureManager.func_110577_a(AtlasTexture.field_110575_b);
        textureManager.func_229267_b_(AtlasTexture.field_110575_b).restoreLastBlurMipmap();
        buffer.func_228461_a_();
        GL11.glFrontFace((int)2305);
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    public void onTooltip(int slot, boolean isInput, ItemStack stack, List<String> tooltip) {
        if (stack.func_190926_b()) {
            return;
        }
        if (isInput) {
            if (slot == 0) {
                String timeToGrow = TickTimeHelper.getDuration((int)this.sapling.baseTicks);
                tooltip.add(tooltip.size() - 1, TextFormatting.YELLOW + I18n.func_135052_a((String)"bonsaitrees.jei.category.sapling.growtime", (Object[])new Object[]{timeToGrow}));
            }
            if (slot == 1) {
                float tickModifier = this.tickModifiers.getOrDefault(stack.func_77973_b().getRegistryName(), Float.valueOf(1.0f)).floatValue();
                String timeToGrow = TickTimeHelper.getDuration((int)((int)((float)this.sapling.baseTicks * tickModifier)));
                tooltip.add(tooltip.size() - 1, TextFormatting.YELLOW + I18n.func_135052_a((String)"bonsaitrees.jei.category.sapling.soiltime", (Object[])new Object[]{timeToGrow}));
            }
        } else if (((Boolean)Config.SHOW_CHANCE_IN_JEI.get()).booleanValue()) {
            tooltip.add(tooltip.size() - 1, TextFormatting.YELLOW + I18n.func_135052_a((String)"bonsaitrees.jei.category.growing.chance", (Object[])new Object[]{(int)(this.slotChances[slot - 2] * 100.0f)}));
        }
    }

    public void setIngredients(IIngredients iIngredients) {
        ArrayList<List<Object>> inputs = new ArrayList<List<Object>>();
        inputs.add(Collections.singletonList(this.sapling.ingredient.func_193365_a()[0]));
        this.tickModifiers = new HashMap<ResourceLocation, Float>();
        ArrayList<ItemStack> soilStacks = new ArrayList<ItemStack>();
        for (SoilInfo soil : SoilCompatibility.INSTANCE.getValidSoilsForSapling(this.sapling)) {
            ItemStack representation = soil.ingredient.func_193365_a()[0];
            this.tickModifiers.put(representation.func_77973_b().getRegistryName(), Float.valueOf(soil.getTickModifier()));
            soilStacks.add(representation);
        }
        inputs.add(soilStacks);
        iIngredients.setInputLists(VanillaTypes.ITEM, inputs);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.slotChances = new float[this.sapling.drops.size()];
        int slot = 0;
        for (SaplingDrop drop : this.sapling.drops) {
            ItemStack dropStack = drop.resultStack.func_77946_l();
            dropStack.func_190920_e(drop.rolls);
            drops.add(dropStack);
            this.slotChances[slot] = drop.chance;
            ++slot;
        }
        iIngredients.setOutputs(VanillaTypes.ITEM, drops);
    }
}

