/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees2.block;

import com.davenonymous.bonsaitrees2.block.ModObjects;
import com.davenonymous.bonsaitrees2.config.Config;
import com.davenonymous.bonsaitrees2.config.WaterLogEffect;
import com.davenonymous.bonsaitrees2.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees2.registry.soil.SoilInfo;
import com.davenonymous.libnonymous.base.BaseTileEntity;
import com.davenonymous.libnonymous.serialization.Store;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class BonsaiPotTileEntity
extends BaseTileEntity {
    @Store(sendInUpdatePackage=true)
    protected ItemStack soilStack = ItemStack.field_190927_a;
    @Store(sendInUpdatePackage=true)
    protected ItemStack saplingStack = ItemStack.field_190927_a;
    @Store(sendInUpdatePackage=true)
    protected int modelRotation = -1;
    @Store(sendInUpdatePackage=true)
    protected int growTicks;
    @Store(sendInUpdatePackage=true)
    protected int requiredTicks;
    @Store(sendInUpdatePackage=true)
    protected ResourceLocation treeId;
    public SaplingInfo saplingInfo;
    public SoilInfo soilInfo;

    public BonsaiPotTileEntity() {
        super(ModObjects.BONSAIPOT_TILE);
    }

    public BonsaiPotTileEntity(TileEntityType type) {
        super(type);
    }

    protected void updateInfoObjects() {
        this.saplingInfo = null;
        if (this.saplingStack != null && !this.saplingStack.func_190926_b()) {
            this.saplingInfo = ModObjects.saplingRecipeHelper.getSaplingInfoForItem(this.field_145850_b, this.saplingStack);
            if (this.saplingInfo != null) {
                this.treeId = this.saplingInfo.func_199560_c();
            }
        }
        this.soilInfo = null;
        if (this.soilStack != null && !this.soilStack.func_190926_b()) {
            this.soilInfo = ModObjects.soilRecipeHelper.getSoilForItem(this.field_145850_b, this.soilStack);
        }
        if (this.soilInfo != null && this.saplingInfo != null) {
            int ticks = this.saplingInfo.getRequiredTicks();
            float soilModifier = this.soilInfo.getTickModifier();
            this.requiredTicks = (int)Math.ceil((float)ticks * soilModifier);
        } else {
            this.requiredTicks = Integer.MAX_VALUE;
        }
    }

    public boolean hasSapling() {
        return this.saplingStack != null && !this.saplingStack.func_190926_b();
    }

    public ItemStack getSaplingStack() {
        return this.saplingStack.func_77946_l();
    }

    public ResourceLocation getTreeId() {
        return this.treeId;
    }

    public void setSapling(ItemStack saplingStack) {
        this.saplingStack = saplingStack.func_77946_l();
        this.growTicks = 0;
        this.modelRotation = this.field_145850_b.field_73012_v.nextInt(4);
        this.updateInfoObjects();
        this.func_70296_d();
        this.notifyClients();
    }

    public void dropSapling() {
        if (!this.hasSapling()) {
            return;
        }
        this.spawnItem(this.getSaplingStack());
        this.setSapling(ItemStack.field_190927_a);
    }

    public boolean hasSoil() {
        return this.soilStack != null && !this.soilStack.func_190926_b() && this.soilStack.func_77973_b() instanceof BlockItem;
    }

    public ItemStack getSoilStack() {
        return this.soilStack.func_77946_l();
    }

    public BlockState getSoilBlockState() {
        if (!this.hasSoil()) {
            return null;
        }
        BlockItem soilBlock = (BlockItem)this.soilStack.func_77973_b();
        return soilBlock.func_179223_d().func_176223_P();
    }

    public void setSoil(ItemStack soilStack) {
        this.soilStack = soilStack.func_77946_l();
        this.updateInfoObjects();
        this.func_70296_d();
        this.notifyClients();
    }

    public void dropSoil() {
        if (!this.hasSoil()) {
            return;
        }
        this.spawnItem(this.getSoilStack());
        this.setSoil(ItemStack.field_190927_a);
    }

    public boolean isGrowing() {
        return this.hasSapling() && this.growTicks < this.requiredTicks;
    }

    public double getProgress() {
        if (this.getSaplingStack().func_190926_b() || this.getSoilStack().func_190926_b() || this.requiredTicks == 0) {
            return 0.0;
        }
        return (double)this.growTicks / (double)this.requiredTicks;
    }

    public double getProgress(float partialTicks) {
        if (this.getSaplingStack().func_190926_b() || this.getSoilStack().func_190926_b() || this.requiredTicks == 0) {
            return 0.0;
        }
        double result = ((double)this.growTicks + (double)partialTicks) / (double)this.requiredTicks;
        if (result >= 0.999) {
            result = 1.0;
        }
        return result;
    }

    public void updateGrowth() {
        if (this.getSaplingStack().func_190926_b() || this.getSoilStack().func_190926_b()) {
            this.setGrowTicks(0);
            return;
        }
        if (this.canGrowIntoBlockAbove()) {
            if (this.getProgress() < 1.0) {
                this.setGrowTicks(this.growTicks + 1);
            }
        } else if (this.getProgress() > (double)0.3f) {
            this.setGrowTicks((int)Math.ceil((float)this.requiredTicks * 0.3f));
        }
    }

    private boolean canGrowIntoBlockAbove() {
        if (this.field_145850_b == null) {
            return false;
        }
        BlockPos upPos = this.field_174879_c.func_177984_a();
        if (this.field_145850_b.func_175623_d(upPos)) {
            return true;
        }
        BlockState blockState = this.field_145850_b.func_180495_p(upPos);
        VoxelShape collisionShape = blockState.func_196952_d((IBlockReader)this.field_145850_b, upPos);
        return collisionShape == null || collisionShape.equals(VoxelShapes.func_197880_a());
    }

    public void setGrowTicks(int growTicks) {
        this.growTicks = growTicks;
        this.func_70296_d();
    }

    public void boostProgress() {
        if (!this.isGrowing()) {
            return;
        }
        this.growTicks += this.requiredTicks / 4;
        if (this.growTicks >= this.requiredTicks) {
            this.growTicks = this.requiredTicks;
        }
        this.notifyClients();
    }

    protected void initialize() {
        super.initialize();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.modelRotation == -1) {
            this.modelRotation = this.field_145850_b.field_73012_v.nextInt(4);
        }
    }

    private void checkWaterlogged() {
        if (this.isWaterlogged()) {
            WaterLogEffect mode = (WaterLogEffect)((Object)Config.WATERLOG_EFFECT.get());
            if (mode.shouldDropLoot() && this.getProgress() >= 1.0) {
                this.dropLoot();
                this.setSapling(this.saplingStack);
            }
            if (mode == WaterLogEffect.DROP_SAPLING) {
                this.dropSapling();
            }
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.checkWaterlogged();
        this.updateGrowth();
    }

    public void dropLoot() {
        if (this.saplingInfo == null || this.soilInfo == null) {
            this.updateInfoObjects();
        }
        List<ItemStack> drops = this.saplingInfo.getRandomizedDrops(this.field_145850_b.field_73012_v);
        for (ItemStack stack : drops) {
            this.spawnItem(stack);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(1.0).func_72321_a(0.0, 1.0, 0.0);
    }
}

