/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.entity;

import com.mojang.authlib.GameProfile;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.oddities.module.TotemOfHoldingModule;

public class TotemOfHoldingEntity
extends Entity {
    private static final String TAG_ITEMS = "storedItems";
    private static final String TAG_DYING = "dying";
    private static final String TAG_OWNER = "owner";
    private static final DataParameter<Boolean> DYING = EntityDataManager.func_187226_a(TotemOfHoldingEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final int DEATH_TIME = 40;
    private int deathTicks = 0;
    private String owner;
    private List<ItemStack> storedItems = new LinkedList<ItemStack>();

    public TotemOfHoldingEntity(EntityType<? extends TotemOfHoldingEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DYING, (Object)false);
    }

    public void addItem(ItemStack stack) {
        this.storedItems.add(stack);
    }

    public void setOwner(PlayerEntity player) {
        this.owner = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).toString();
    }

    private PlayerEntity getOwnerEntity() {
        for (PlayerEntity player : this.field_70170_p.func_217369_A()) {
            String uuid = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()).toString();
            if (!uuid.equals(this.owner)) continue;
            return player;
        }
        return null;
    }

    public boolean func_85031_j(Entity e) {
        if (!this.field_70170_p.field_72995_K && e instanceof PlayerEntity) {
            PlayerEntity owner;
            PlayerEntity player = (PlayerEntity)e;
            if (!TotemOfHoldingModule.allowAnyoneToCollect && !player.func_184812_l_() && e != (owner = this.getOwnerEntity())) {
                return false;
            }
            int drops = Math.min(this.storedItems.size(), 3 + this.field_70170_p.field_73012_v.nextInt(4));
            for (int i = 0; i < drops; ++i) {
                ItemStack stack = this.storedItems.remove(0);
                if (stack.func_77973_b() instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)stack.func_77973_b();
                    EquipmentSlotType slot = armor.func_185083_B_();
                    ItemStack curr = player.func_184582_a(slot);
                    if (curr.func_190926_b()) {
                        player.func_184201_a(slot, stack);
                        stack = null;
                    } else if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)curr) == 0) {
                        player.func_184201_a(slot, stack);
                        stack = curr;
                    }
                }
                if (stack == null || player.func_191521_c(stack)) continue;
                this.func_70099_a(stack, 0.0f);
            }
            if (this.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), drops, 0.1, 0.5, 0.1, 0.0);
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197622_o, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), drops, 0.4, 0.5, 0.4, 0.0);
            }
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        PlayerEntity owner;
        super.func_70071_h_();
        if (!this.func_70089_S()) {
            return;
        }
        if (TotemOfHoldingModule.darkSoulsMode && (owner = this.getOwnerEntity()) != null && !this.field_70170_p.field_72995_K) {
            String ownerTotem = TotemOfHoldingModule.getTotemUUID(owner);
            if (!this.func_110124_au().toString().equals(ownerTotem)) {
                this.dropEverythingAndDie();
            }
        }
        if (this.storedItems.isEmpty() && !this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(DYING, (Object)true);
        }
        if (this.isDying()) {
            if (this.deathTicks > 40) {
                this.func_70106_y();
            } else {
                ++this.deathTicks;
            }
        } else if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_(), this.func_226278_cu_() + (Math.random() - 0.5) * 0.2, this.func_226281_cx_(), Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        }
    }

    private void dropEverythingAndDie() {
        if (!TotemOfHoldingModule.destroyLostItems) {
            for (ItemStack storedItem : this.storedItems) {
                this.func_70099_a(storedItem, 0.0f);
            }
        }
        this.storedItems.clear();
        this.func_70106_y();
    }

    public int getDeathTicks() {
        return this.deathTicks;
    }

    public boolean isDying() {
        return (Boolean)this.field_70180_af.func_187225_a(DYING);
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        ListNBT list = compound.func_150295_c(TAG_ITEMS, 10);
        this.storedItems = new LinkedList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT cmp = list.func_150305_b(i);
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)cmp);
            this.storedItems.add(stack);
        }
        boolean dying = compound.func_74767_n(TAG_DYING);
        this.field_70180_af.func_187227_b(DYING, (Object)dying);
        this.owner = compound.func_74779_i(TAG_OWNER);
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (ItemStack stack : this.storedItems) {
            list.add((Object)stack.serializeNBT());
        }
        compound.func_218657_a(TAG_ITEMS, (INBT)list);
        compound.func_74757_a(TAG_DYING, this.isDying());
        if (this.owner != null) {
            compound.func_74778_a(TAG_OWNER, this.owner);
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

