/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.container;

import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import vazkii.quark.oddities.module.MatrixEnchantingModule;
import vazkii.quark.oddities.tile.MatrixEnchantingTableTileEntity;

public class MatrixEnchantingContainer
extends Container {
    public final MatrixEnchantingTableTileEntity enchanter;

    public MatrixEnchantingContainer(int id, PlayerInventory playerInv, MatrixEnchantingTableTileEntity tile) {
        super(MatrixEnchantingModule.containerType, id);
        this.enchanter = tile;
        this.func_75146_a(new Slot((IInventory)tile, 0, 15, 20){

            public int func_75219_a() {
                return 1;
            }
        });
        this.func_75146_a(new Slot((IInventory)tile, 1, 15, 44){

            public boolean func_75214_a(ItemStack stack) {
                return MatrixEnchantingContainer.this.isLapis(stack);
            }
        });
        this.func_75146_a(new Slot((IInventory)tile, 2, 59, 32){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            @Nonnull
            public ItemStack func_190901_a(PlayerEntity thePlayer, @Nonnull ItemStack stack) {
                MatrixEnchantingContainer.this.finish(thePlayer, stack);
                return super.func_190901_a(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInv, k, 8 + k * 18, 142));
        }
    }

    public static MatrixEnchantingContainer fromNetwork(int windowId, PlayerInventory playerInventory, PacketBuffer buf) {
        BlockPos pos = buf.func_179259_c();
        MatrixEnchantingTableTileEntity te = (MatrixEnchantingTableTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(pos);
        return new MatrixEnchantingContainer(windowId, playerInventory, te);
    }

    private boolean isLapis(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(Tags.Items.GEMS_LAPIS);
    }

    private void finish(PlayerEntity player, ItemStack stack) {
        this.enchanter.func_70299_a(0, ItemStack.field_190927_a);
        player.func_195066_a(Stats.field_188091_Y);
        if (player instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192129_i.func_192190_a((ServerPlayerEntity)player, stack, 1);
        }
        player.field_70170_p.func_184133_a(null, this.enchanter.func_174877_v(), SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        BlockPos pos;
        World world = this.enchanter.func_145831_w();
        if (world.func_180495_p(pos = this.enchanter.func_174877_v()).func_177230_c() != Blocks.field_150381_bn) {
            return false;
        }
        return playerIn.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack originalStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if (index < 3) {
                if (!this.func_75135_a(stackInSlot, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (this.isLapis(stackInSlot)) {
                if (!this.func_75135_a(stackInSlot, 1, 2, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (((Slot)this.field_75151_b.get(0)).func_75216_d() || !((Slot)this.field_75151_b.get(0)).func_75214_a(stackInSlot)) {
                    return ItemStack.field_190927_a;
                }
                if (stackInSlot.func_77942_o()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(stackInSlot.func_77979_a(1));
                } else if (!stackInSlot.func_190926_b()) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(new ItemStack((IItemProvider)stackInSlot.func_77973_b(), 1));
                    stackInSlot.func_190918_g(1);
                }
            }
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == originalStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stackInSlot);
        }
        return originalStack;
    }
}

