/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import squeek.appleskin.ModConfig;
import squeek.appleskin.ModInfo;
import squeek.appleskin.helpers.FoodHelper;
import squeek.appleskin.helpers.KeyHelper;

@OnlyIn(value=Dist.CLIENT)
public class TooltipOverlayHandler {
    private static ResourceLocation modIcons = new ResourceLocation(ModInfo.MODID_LOWER, "textures/icons.png");
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_BOTTOM = 3;
    public static final int TOOLTIP_REAL_HEIGHT_OFFSET_TOP = -3;
    public static final int TOOLTIP_REAL_WIDTH_OFFSET_RIGHT = 3;
    private static final TextureOffsets normalBarTextureOffsets = new TextureOffsets();
    private static final TextureOffsets rottenBarTextureOffsets;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
    }

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.PostText event) {
        int x;
        String saturationText;
        int saturationBarsNeeded;
        boolean saturationOverflow;
        String hungerText;
        boolean hungerOverflow;
        FoodHelper.BasicFoodValues modifiedFoodValues;
        boolean shouldShowTooltip;
        ItemStack hoveredStack = event.getStack();
        if (hoveredStack.func_190926_b()) {
            return;
        }
        boolean bl = shouldShowTooltip = (Boolean)ModConfig.SHOW_FOOD_VALUES_IN_TOOLTIP.get() != false && KeyHelper.isShiftKeyDown() || (Boolean)ModConfig.ALWAYS_SHOW_FOOD_VALUES_TOOLTIP.get() != false;
        if (!shouldShowTooltip) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Screen gui = mc.field_71462_r;
        if (gui == null) {
            return;
        }
        if (!FoodHelper.isFood(hoveredStack)) {
            return;
        }
        ClientPlayerEntity player = mc.field_71439_g;
        int toolTipY = event.getY();
        int toolTipX = event.getX();
        int toolTipW = event.getWidth();
        int toolTipH = event.getHeight();
        FoodHelper.BasicFoodValues defaultFoodValues = FoodHelper.getDefaultFoodValues(hoveredStack);
        if (defaultFoodValues.equals(modifiedFoodValues = FoodHelper.getModifiedFoodValues(hoveredStack, (PlayerEntity)player)) && defaultFoodValues.hunger == 0) {
            return;
        }
        int biggestHunger = Math.max(defaultFoodValues.hunger, modifiedFoodValues.hunger);
        float biggestSaturationIncrement = Math.max(defaultFoodValues.getSaturationIncrement(), modifiedFoodValues.getSaturationIncrement());
        int barsNeeded = (int)Math.ceil((float)Math.abs(biggestHunger) / 2.0f);
        boolean bl2 = hungerOverflow = barsNeeded > 10;
        String string = hungerOverflow ? (biggestHunger < 0 ? -1 : 1) * barsNeeded + "x " : (hungerText = null);
        if (hungerOverflow) {
            barsNeeded = 1;
        }
        boolean bl3 = saturationOverflow = (saturationBarsNeeded = (int)Math.max(1.0, Math.ceil(Math.abs(biggestSaturationIncrement) / 2.0f))) > 10;
        String string2 = saturationOverflow ? (biggestSaturationIncrement < 0.0f ? -1 : 1) * saturationBarsNeeded + "x " : (saturationText = null);
        if (saturationOverflow) {
            saturationBarsNeeded = 1;
        }
        int toolTipBottomY = toolTipY + toolTipH + 1 + 3;
        int toolTipRightX = toolTipX + toolTipW + 1 + 3;
        boolean shouldDrawBelow = toolTipBottomY + 20 < mc.func_228018_at_().func_198087_p() - 3;
        int rightX = toolTipRightX - 3;
        int leftX = rightX - Math.max(barsNeeded * 9 + (int)((float)mc.field_71466_p.func_78256_a(hungerText) * 0.75f), saturationBarsNeeded * 6 + (int)((float)mc.field_71466_p.func_78256_a(saturationText) * 0.75f)) - 3;
        int topY = shouldDrawBelow ? toolTipBottomY : toolTipY - 20 + -3;
        int bottomY = topY + 19;
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        AbstractGui.fill((int)(leftX - 1), (int)topY, (int)(rightX + 1), (int)bottomY, (int)-267386864);
        AbstractGui.fill((int)leftX, (int)(shouldDrawBelow ? bottomY : topY - 1), (int)rightX, (int)(shouldDrawBelow ? bottomY + 1 : topY), (int)-267386864);
        AbstractGui.fill((int)leftX, (int)topY, (int)rightX, (int)bottomY, (int)0x66FFFFFF);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int startX = x = rightX - 2;
        int y = bottomY - 18;
        mc.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
        TextureOffsets offsets = FoodHelper.isRotten(hoveredStack) ? rottenBarTextureOffsets : normalBarTextureOffsets;
        for (int i = 0; i < barsNeeded * 2; i += 2) {
            x -= 9;
            if (modifiedFoodValues.hunger < 0) {
                gui.blit(x, y, offsets.containerNegativeHunger, 27, 9, 9);
            } else if (modifiedFoodValues.hunger > defaultFoodValues.hunger && defaultFoodValues.hunger <= i) {
                gui.blit(x, y, offsets.containerExtraHunger, 27, 9, 9);
            } else if (modifiedFoodValues.hunger > i + 1 || defaultFoodValues.hunger == modifiedFoodValues.hunger) {
                gui.blit(x, y, offsets.containerNormalHunger, 27, 9, 9);
            } else if (modifiedFoodValues.hunger == i + 1) {
                gui.blit(x, y, offsets.containerPartialHunger, 27, 9, 9);
            } else {
                gui.blit(x, y, offsets.containerMissingHunger, 27, 9, 9);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            gui.blit(x, y, defaultFoodValues.hunger - 1 == i ? offsets.shankMissingPartial : offsets.shankMissingFull, 27, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (modifiedFoodValues.hunger <= i) continue;
            gui.blit(x, y, modifiedFoodValues.hunger - 1 == i ? offsets.shankPartial : offsets.shankFull, 27, 9, 9);
        }
        if (hungerText != null) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.75f, (float)0.75f, (float)0.75f);
            mc.field_71466_p.func_175063_a(hungerText, (float)(x * 4 / 3 - mc.field_71466_p.func_78256_a(hungerText) + 2), (float)(y * 4 / 3 + 2), -2236963);
            RenderSystem.popMatrix();
        }
        y += 10;
        x = startX;
        float modifiedSaturationIncrement = modifiedFoodValues.getSaturationIncrement();
        float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(modIcons);
        for (int i = 0; i < saturationBarsNeeded * 2; i += 2) {
            boolean shouldBeFaded;
            float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
            x -= 6;
            boolean bl4 = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
            if (shouldBeFaded) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            }
            gui.blit(x, y, effectiveSaturationOfBar >= 1.0f ? 21 : ((double)effectiveSaturationOfBar > 0.5 ? 14 : ((double)effectiveSaturationOfBar > 0.25 ? 7 : (effectiveSaturationOfBar > 0.0f ? 0 : 28))), modifiedSaturationIncrement >= 0.0f ? 27 : 34, 7, 7);
            if (!shouldBeFaded) continue;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (saturationText != null) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.75f, (float)0.75f, (float)0.75f);
            mc.field_71466_p.func_175063_a(saturationText, (float)(x * 4 / 3 - mc.field_71466_p.func_78256_a(saturationText) + 2), (float)(y * 4 / 3 + 1), -2236963);
            RenderSystem.popMatrix();
        }
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
    }

    static {
        TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger = 43;
        TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger = 133;
        TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger = 16;
        TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger = 124;
        TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger = 34;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull = 70;
        TooltipOverlayHandler.normalBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.normalBarTextureOffsets.shankFull = 52;
        TooltipOverlayHandler.normalBarTextureOffsets.shankPartial = TooltipOverlayHandler.normalBarTextureOffsets.shankFull + 9;
        rottenBarTextureOffsets = new TextureOffsets();
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNegativeHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNegativeHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerExtraHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerExtraHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerNormalHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerNormalHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerPartialHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerPartialHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.containerMissingHunger = TooltipOverlayHandler.normalBarTextureOffsets.containerMissingHunger;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull = 106;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankMissingFull + 9;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankFull = 88;
        TooltipOverlayHandler.rottenBarTextureOffsets.shankPartial = TooltipOverlayHandler.rottenBarTextureOffsets.shankFull + 9;
    }

    static class TextureOffsets {
        int containerNegativeHunger;
        int containerExtraHunger;
        int containerNormalHunger;
        int containerPartialHunger;
        int containerMissingHunger;
        int shankMissingFull;
        int shankMissingPartial;
        int shankFull;
        int shankPartial;

        TextureOffsets() {
        }
    }
}

