/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goldenhopper.tileentity;

import com.mrcrayfish.goldenhopper.block.GoldenHopperBlock;
import com.mrcrayfish.goldenhopper.init.ModTileEntities;
import com.mrcrayfish.goldenhopper.inventory.container.GoldenHopperContainer;
import com.mrcrayfish.goldenhopper.item.GoldenHopperItemHandler;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class GoldenHopperTileEntity
extends LockableLootTileEntity
implements IHopper,
ITickableTileEntity,
ISidedInventory {
    private static final int MAX_COOLDOWN = 8;
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private int transferCooldown = -1;
    private long tickedGameTime;

    public GoldenHopperTileEntity() {
        super((TileEntityType)ModTileEntities.GOLDEN_HOPPER.get());
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        }
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory);
        }
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        return compound;
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188382_a(this.func_190576_q(), (int)index, (int)count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.goldenhopper.golden_hopper", new Object[0]);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            this.tickedGameTime = this.field_145850_b.func_82737_E();
            if (!this.isOnTransferCooldown()) {
                this.setTransferCooldown(0);
                this.updateHopper(() -> GoldenHopperTileEntity.pullItems(this));
            }
        }
    }

    private boolean updateHopper(Supplier<Boolean> supplier) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !this.isOnTransferCooldown() && ((Boolean)this.func_195044_w().func_177229_b((IProperty)GoldenHopperBlock.ENABLED)).booleanValue()) {
            boolean pulledItems = false;
            if (!this.func_191420_l()) {
                pulledItems = this.transferItemsOut();
            }
            if (!this.isFull()) {
                pulledItems |= supplier.get().booleanValue();
            }
            if (pulledItems) {
                this.setTransferCooldown(8);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean isFull() {
        return this.inventory.stream().noneMatch(stack -> stack.func_190926_b() || stack.func_190916_E() != stack.func_77976_d());
    }

    private boolean transferItemsOut() {
        if (GoldenHopperTileEntity.insertHook(this)) {
            return true;
        }
        IInventory inventory = this.getInventoryForHopperTransfer();
        if (inventory == null) {
            return false;
        }
        Direction direction = ((Direction)this.func_195044_w().func_177229_b((IProperty)GoldenHopperBlock.FACING)).func_176734_d();
        if (this.isInventoryFull(inventory, direction)) {
            return false;
        }
        for (int index = 1; index < this.func_70302_i_(); ++index) {
            if (this.func_70301_a(index).func_190926_b()) continue;
            ItemStack copy = this.func_70301_a(index).func_77946_l();
            ItemStack result = GoldenHopperTileEntity.putStackInInventoryAllSlots((IInventory)this, inventory, this.func_70298_a(index, 1), direction);
            if (result.func_190926_b()) {
                inventory.func_70296_d();
                return true;
            }
            this.func_70299_a(index, copy);
        }
        return false;
    }

    private static IntStream getSlotsStream(IInventory inventory, Direction direction) {
        return inventory instanceof ISidedInventory ? IntStream.of(((ISidedInventory)inventory).func_180463_a(direction)) : IntStream.range(0, inventory.func_70302_i_());
    }

    private boolean isInventoryFull(IInventory inventory, Direction direction) {
        return GoldenHopperTileEntity.getSlotsStream(inventory, direction).allMatch(index -> {
            ItemStack stack = inventory.func_70301_a(index);
            return stack.func_190916_E() >= stack.func_77976_d();
        });
    }

    private static boolean isInventoryEmpty(IInventory inventory, Direction direction) {
        return GoldenHopperTileEntity.getSlotsStream(inventory, direction).allMatch(index -> inventory.func_70301_a(index).func_190926_b());
    }

    public static boolean pullItems(IHopper hopper) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((IHopper)hopper);
        if (ret != null) {
            return ret;
        }
        IInventory inventory = GoldenHopperTileEntity.getSourceInventory(hopper);
        if (inventory != null) {
            Direction direction = Direction.DOWN;
            if (GoldenHopperTileEntity.isInventoryEmpty(inventory, direction)) {
                return false;
            }
            return GoldenHopperTileEntity.getSlotsStream(inventory, direction).anyMatch(index -> GoldenHopperTileEntity.pullItemFromSlot(hopper, inventory, index, direction));
        }
        for (ItemEntity entity : GoldenHopperTileEntity.getItemEntities(hopper)) {
            if (!GoldenHopperTileEntity.captureItemEntity((IInventory)hopper, entity)) continue;
            return true;
        }
        return false;
    }

    private static boolean pullItemFromSlot(IHopper hopper, IInventory inventory, int index, Direction direction) {
        ItemStack stack = inventory.func_70301_a(index);
        if (!stack.func_190926_b() && GoldenHopperTileEntity.canExtractItemFromSlot(inventory, stack, index, direction)) {
            ItemStack copy = stack.func_77946_l();
            ItemStack result = GoldenHopperTileEntity.putStackInInventoryAllSlots(inventory, (IInventory)hopper, inventory.func_70298_a(index, 1), (Direction)null);
            if (result.func_190926_b()) {
                inventory.func_70296_d();
                return true;
            }
            inventory.func_70299_a(index, copy);
        }
        return false;
    }

    public static boolean captureItemEntity(IInventory inventory, ItemEntity entity) {
        boolean captured = false;
        ItemStack copy = entity.func_92059_d().func_77946_l();
        ItemStack result = GoldenHopperTileEntity.putStackInInventoryAllSlots(null, inventory, copy, null);
        if (result.func_190926_b()) {
            captured = true;
            entity.func_70106_y();
        } else {
            entity.func_92058_a(result);
        }
        return captured;
    }

    private static ItemStack putStackInInventoryAllSlots(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.func_190926_b(); ++slot) {
            stack = GoldenHopperTileEntity.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).func_190926_b()) {
            HopperTileEntity destinationHopper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = GoldenHopperTileEntity.isEmpty(destInventory);
            if (itemstack.func_190926_b()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.field_190927_a;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)stack)) {
                int originalSize = stack.func_190916_E();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).func_190916_E();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof HopperTileEntity && !(destinationHopper = (HopperTileEntity)destination).func_174914_o()) {
                int k = 0;
                destinationHopper.func_145896_c(8 - k);
            }
        }
        return stack;
    }

    private static ItemStack putStackInInventoryAllSlots(@Nullable IInventory source, IInventory destination, ItemStack stack, @Nullable Direction direction) {
        if (destination instanceof ISidedInventory && direction != null) {
            ISidedInventory sidedInventory = (ISidedInventory)destination;
            int[] slots = sidedInventory.func_180463_a(direction);
            for (int i = 0; i < slots.length && !stack.func_190926_b(); ++i) {
                stack = GoldenHopperTileEntity.insertStack(source, (IInventory)sidedInventory, stack, slots[i], direction);
            }
        } else {
            int i = destination.func_70302_i_();
            for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
                stack = GoldenHopperTileEntity.insertStack(source, destination, stack, j, direction);
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventory, ItemStack stack, int index, @Nullable Direction side) {
        if (!inventory.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_180462_a(index, stack, side);
    }

    private static boolean canExtractItemFromSlot(IInventory inventory, ItemStack stack, int index, Direction side) {
        return !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_180461_b(index, stack, side);
    }

    private static ItemStack insertStack(@Nullable IInventory source, IInventory destination, ItemStack stack, int index, @Nullable Direction direction) {
        ItemStack slotStack = destination.func_70301_a(index);
        if (GoldenHopperTileEntity.canInsertItemInSlot(destination, stack, index, direction)) {
            boolean shouldInsert = false;
            boolean destinationEmpty = destination.func_191420_l();
            if (slotStack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
                shouldInsert = true;
            } else if (GoldenHopperTileEntity.canCombine(slotStack, stack)) {
                int remainingCount = stack.func_77976_d() - slotStack.func_190916_E();
                int shrinkCount = Math.min(stack.func_190916_E(), remainingCount);
                stack.func_190918_g(shrinkCount);
                slotStack.func_190917_f(shrinkCount);
                boolean bl = shouldInsert = shrinkCount > 0;
            }
            if (shouldInsert) {
                HopperTileEntity hopper;
                if (destinationEmpty && destination instanceof HopperTileEntity && !(hopper = (HopperTileEntity)destination).func_174914_o()) {
                    int cooldownAmount = 0;
                    if (source instanceof GoldenHopperTileEntity) {
                        GoldenHopperTileEntity goldenHopper = (GoldenHopperTileEntity)source;
                        if (hopper.getLastUpdateTime() >= goldenHopper.tickedGameTime) {
                            cooldownAmount = 1;
                        }
                    }
                    hopper.func_145896_c(8 - cooldownAmount);
                }
                destination.func_70296_d();
            }
        }
        return stack;
    }

    @Nullable
    private IInventory getInventoryForHopperTransfer() {
        Direction direction = (Direction)this.func_195044_w().func_177229_b((IProperty)GoldenHopperBlock.FACING);
        return GoldenHopperTileEntity.getInventoryAtPosition(this.func_145831_w(), this.field_174879_c.func_177972_a(direction));
    }

    @Nullable
    public static IInventory getSourceInventory(IHopper hopper) {
        return GoldenHopperTileEntity.getInventoryAtPosition(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB() + 1.0, hopper.func_96108_aC());
    }

    public static List<ItemEntity> getItemEntities(IHopper hopper) {
        return hopper.func_200100_i().func_197756_d().stream().flatMap(box -> hopper.func_145831_w().func_175647_a(ItemEntity.class, box.func_72317_d(hopper.func_96107_aA() - 0.5, hopper.func_96109_aB() - 0.5, hopper.func_96108_aC() - 0.5), EntityPredicates.field_94557_a).stream()).collect(Collectors.toList());
    }

    @Nullable
    private static IInventory getInventoryAtPosition(World world, BlockPos pos) {
        return GoldenHopperTileEntity.getInventoryAtPosition(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    @Nullable
    private static IInventory getInventoryAtPosition(World worldIn, double x, double y, double z) {
        List itemEntities;
        TileEntity tileEntity;
        ISidedInventory targetInventory = null;
        BlockPos targetPos = new BlockPos(x, y, z);
        BlockState targetState = worldIn.func_180495_p(targetPos);
        Block targetBlock = targetState.func_177230_c();
        if (targetBlock instanceof ISidedInventoryProvider) {
            targetInventory = ((ISidedInventoryProvider)targetBlock).func_219966_a(targetState, (IWorld)worldIn, targetPos);
        } else if (targetState.hasTileEntity() && (tileEntity = worldIn.func_175625_s(targetPos)) instanceof IInventory && (targetInventory = (IInventory)tileEntity) instanceof ChestTileEntity && targetBlock instanceof ChestBlock) {
            targetInventory = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)targetBlock), (BlockState)targetState, (World)worldIn, (BlockPos)targetPos, (boolean)true);
        }
        if (targetInventory == null && !(itemEntities = worldIn.func_175674_a(null, new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntityPredicates.field_96566_b)).isEmpty()) {
            targetInventory = (IInventory)itemEntities.get(worldIn.field_73012_v.nextInt(itemEntities.size()));
        }
        return targetInventory;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown > 8;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.inventory;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.inventory = itemsIn;
    }

    public void onEntityCollision(Entity entity) {
        if (entity instanceof ItemEntity) {
            BlockPos pos = this.func_174877_v();
            if (VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()))), (VoxelShape)this.func_200100_i(), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                this.updateHopper(() -> GoldenHopperTileEntity.captureItemEntity((IInventory)this, (ItemEntity)entity));
            }
        }
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new GoldenHopperContainer(id, player, (IInventory)this);
    }

    protected IItemHandler createUnSidedHandler() {
        return new GoldenHopperItemHandler(this);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 0 && (((ItemStack)this.inventory.get(0)).func_190926_b() || stack.func_77973_b() == ((ItemStack)this.inventory.get(0)).func_77973_b());
    }

    public int[] func_180463_a(Direction side) {
        return IntStream.range(1, this.inventory.size()).toArray();
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return ((ItemStack)this.inventory.get(0)).func_190926_b() || stack.func_77973_b() == ((ItemStack)this.inventory.get(0)).func_77973_b();
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index != 0;
    }

    private static boolean insertHook(GoldenHopperTileEntity hopper) {
        Direction direction = (Direction)hopper.func_195044_w().func_177229_b((IProperty)GoldenHopperBlock.FACING);
        double x = hopper.func_96107_aA() + (double)direction.func_82601_c();
        double y = hopper.func_96109_aB() + (double)direction.func_96559_d();
        double z = hopper.func_96108_aC() + (double)direction.func_82599_e();
        LazyOptional handler = VanillaInventoryCodeHooks.getItemHandler((World)hopper.func_145831_w(), (double)x, (double)y, (double)z, (Direction)direction.func_176734_d());
        return (Boolean)handler.map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            if (GoldenHopperTileEntity.isFull(itemHandler)) {
                return false;
            }
            Object destination = destinationResult.getValue();
            for (int i = 0; i < hopper.func_70302_i_(); ++i) {
                if (hopper.func_70301_a(i).func_190926_b() || !hopper.func_180461_b(i, hopper.func_70301_a(i), direction)) continue;
                ItemStack originalSlotContents = hopper.func_70301_a(i).func_77946_l();
                ItemStack insertStack = hopper.func_70298_a(i, 1);
                ItemStack remainder = GoldenHopperTileEntity.putStackInInventoryAllSlots((TileEntity)hopper, destination, itemHandler, insertStack);
                if (remainder.func_190926_b()) {
                    return true;
                }
                hopper.func_70299_a(i, originalSlotContents);
            }
            return false;
        }).orElse((Object)false);
    }

    private static boolean isFull(IItemHandler handler) {
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (!stack.func_190926_b() && stack.func_190916_E() == stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.func_190916_E() <= 0) continue;
            return false;
        }
        return true;
    }
}

