/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.world.gen;

import com.mojang.datafixers.Dynamic;
import enemeez.simplefarming.block.growable.PlantBlock;
import enemeez.simplefarming.config.DimensionConfig;
import enemeez.simplefarming.config.GenConfig;
import enemeez.simplefarming.init.ModBlocks;
import enemeez.simplefarming.util.WorldGenHelper;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WildPlantFeature
extends Feature<NoFeatureConfig> {
    private final BlockState[] plantLookup = new BlockState[]{(BlockState)ModBlocks.cumin.func_176223_P().func_206870_a((IProperty)PlantBlock.AGE, (Comparable)Integer.valueOf(3)), (BlockState)ModBlocks.quinoa.func_176223_P().func_206870_a((IProperty)PlantBlock.AGE, (Comparable)Integer.valueOf(3)), (BlockState)ModBlocks.marshmallow.func_176223_P().func_206870_a((IProperty)PlantBlock.AGE, (Comparable)Integer.valueOf(3)), (BlockState)ModBlocks.chicory.func_176223_P().func_206870_a((IProperty)PlantBlock.AGE, (Comparable)Integer.valueOf(3))};

    public WildPlantFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public BlockState getPlant(int type) {
        return this.plantLookup[type - 1];
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (random.nextInt((Integer)GenConfig.wild_plant_chance.get()) != 0 || ((List)DimensionConfig.blacklist.get()).contains(world.func_201675_m().func_186058_p().func_186068_a()) || !((List)DimensionConfig.whitelist.get()).contains(world.func_201675_m().func_186058_p().func_186068_a())) {
            return false;
        }
        int type = random.nextInt(4) + 1;
        int rolls = random.nextInt(3) + 1;
        for (int i = 0; i < rolls; ++i) {
            int offset;
            int initial;
            if (i == 0) {
                initial = (int)(Math.random() * 2.0 + 1.0);
                offset = (int)(Math.random() * 2.0 + 1.0);
                if (WorldGenHelper.checkConditions(world, pos.func_177964_d(initial).func_177985_f(offset))) {
                    this.generatePlant(world, pos.func_177964_d(initial).func_177985_f(offset), random, type);
                }
            }
            if (i == 1) {
                initial = (int)(Math.random() * 2.0 + 1.0);
                offset = (int)(Math.random() * 2.0 + 1.0);
                if (WorldGenHelper.checkConditions(world, pos.func_177970_e(initial).func_177965_g(offset))) {
                    this.generatePlant(world, pos.func_177970_e(initial).func_177965_g(offset), random, type);
                }
            }
            if (i == 2) {
                initial = (int)(Math.random() * 2.0 + 1.0);
                offset = (int)(Math.random() * 2.0 + 1.0);
                if (!WorldGenHelper.checkConditions(world, pos.func_177964_d(initial).func_177965_g(offset))) continue;
                this.generatePlant(world, pos.func_177964_d(initial).func_177965_g(offset), random, type);
                continue;
            }
            initial = (int)(Math.random() * 2.0 + 1.0);
            offset = (int)(Math.random() * 2.0 + 1.0);
            if (!WorldGenHelper.checkConditions(world, pos.func_177970_e(initial).func_177985_f(offset))) continue;
            this.generatePlant(world, pos.func_177970_e(initial).func_177985_f(offset), random, type);
        }
        return true;
    }

    public void generatePlant(IWorld world, BlockPos pos, Random random, int type) {
        world.func_180501_a(pos, this.getPlant(type), 2);
    }
}

