/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.world.gen;

import com.mojang.datafixers.Dynamic;
import enemeez.simplefarming.block.growable.OpuntiaBlock;
import enemeez.simplefarming.config.DimensionConfig;
import enemeez.simplefarming.config.GenConfig;
import enemeez.simplefarming.init.ModBlocks;
import enemeez.simplefarming.util.WorldGenHelper;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CactusCropFeature
extends Feature<NoFeatureConfig> {
    public CactusCropFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (random.nextInt((Integer)GenConfig.cactus_chance.get()) != 0 || ((List)DimensionConfig.blacklist.get()).contains(world.func_201675_m().func_186058_p().func_186068_a()) || !((List)DimensionConfig.whitelist.get()).contains(world.func_201675_m().func_186058_p().func_186068_a())) {
            return false;
        }
        if (WorldGenHelper.checkDryConditions(world, pos)) {
            CactusCropFeature.generateCactus(world, pos, random);
        }
        return true;
    }

    public static void generateCactus(IWorld world, BlockPos pos, Random rand) {
        if ((double)rand.nextFloat() < 0.5) {
            world.func_180501_a(pos, (BlockState)((BlockState)ModBlocks.cactus_crop.func_176223_P().func_206870_a((IProperty)OpuntiaBlock.AGE, (Comparable)Integer.valueOf(3))).func_206870_a((IProperty)OpuntiaBlock.FACING, (Comparable)Direction.WEST), 2);
        } else {
            world.func_180501_a(pos, (BlockState)((BlockState)ModBlocks.cactus_crop.func_176223_P().func_206870_a((IProperty)OpuntiaBlock.AGE, (Comparable)Integer.valueOf(3))).func_206870_a((IProperty)OpuntiaBlock.FACING, (Comparable)Direction.NORTH), 2);
        }
    }
}

