/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.world.gen;

import com.mojang.datafixers.Dynamic;
import enemeez.simplefarming.config.DimensionConfig;
import enemeez.simplefarming.config.GenConfig;
import enemeez.simplefarming.init.ModBlocks;
import enemeez.simplefarming.util.WorldGenHelper;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BerryBushFeature
extends Feature<NoFeatureConfig> {
    private final BlockState[] bushLookup = new BlockState[]{ModBlocks.blackberry_bush.withMaxAge(), ModBlocks.blueberry_bush.withMaxAge(), ModBlocks.raspberry_bush.withMaxAge(), ModBlocks.strawberry_bush.withMaxAge()};

    public BerryBushFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    private BlockState getBush(int type) {
        return this.bushLookup[type - 1];
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        if (random.nextInt((Integer)GenConfig.bush_chance.get()) != 0 || ((List)DimensionConfig.blacklist.get()).contains(world.func_201675_m().func_186058_p().func_186068_a()) || !((List)DimensionConfig.whitelist.get()).contains(world.func_201675_m().func_186058_p().func_186068_a())) {
            return false;
        }
        int type = random.nextInt(this.bushLookup.length) + 1;
        for (int i = 0; i < type; ++i) {
            int offset;
            int initial;
            if (i == 0) {
                initial = random.nextInt(2) + 1;
                offset = random.nextInt(2) + 1;
                if (WorldGenHelper.checkConditions(world, pos.func_177964_d(initial).func_177985_f(offset))) {
                    this.generateBush(world, pos.func_177964_d(initial).func_177985_f(offset), random, type);
                }
            }
            if (i == 1) {
                initial = random.nextInt(2) + 1;
                offset = random.nextInt(2) + 1;
                if (WorldGenHelper.checkConditions(world, pos.func_177970_e(initial).func_177965_g(offset))) {
                    this.generateBush(world, pos.func_177970_e(initial).func_177965_g(offset), random, type);
                }
            }
            if (i == 2) {
                initial = random.nextInt(2) + 1;
                offset = random.nextInt(2) + 1;
                if (!WorldGenHelper.checkConditions(world, pos.func_177964_d(initial).func_177965_g(offset))) continue;
                this.generateBush(world, pos.func_177964_d(initial).func_177965_g(offset), random, type);
                continue;
            }
            initial = random.nextInt(2) + 1;
            offset = random.nextInt(2) + 1;
            if (!WorldGenHelper.checkConditions(world, pos.func_177970_e(initial).func_177985_f(offset))) continue;
            this.generateBush(world, pos.func_177970_e(initial).func_177985_f(offset), random, type);
        }
        return true;
    }

    public void generateBush(IWorld world, BlockPos pos, Random random, int type) {
        world.func_180501_a(pos, this.getBush(type), 2);
    }
}

