/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.block.growable;

import enemeez.simplefarming.world.gen.feature.tree.FruitTreeFeature;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class SimpleSaplingBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty STAGE = BlockStateProperties.field_208137_al;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private final int verify;

    public SimpleSaplingBlock(Block.Properties properties, int verify) {
        super(properties);
        this.verify = verify;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_201696_r(pos.func_177984_a()) >= 9 && random.nextInt(7) == 0) {
            this.spawnTree(worldIn, pos, state, random);
        }
    }

    public void spawnTree(ServerWorld worldIn, BlockPos pos, BlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)STAGE), 4);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)worldIn, (Random)rand, (BlockPos)pos)) {
                return;
            }
            FruitTreeFeature.generateTree((IWorld)worldIn, pos, rand, this.verify);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return worldIn.field_73012_v.nextFloat() < 0.45f;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.spawnTree(worldIn, pos, state, rand);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STAGE});
    }
}

