/*
 * Decompiled with CFR 0.152.
 */
package enemeez.simplefarming.block.growable;

import enemeez.simplefarming.init.ModBlocks;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.LeavesBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class FruitLeavesBlock
extends LeavesBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    private final Supplier<Item> itemSupplier;
    private final Supplier<Item> saplingItemSupplier;

    public FruitLeavesBlock(Block.Properties properties, Supplier<Item> itemSupplier, Supplier<Item> saplingItemSupplier) {
        super(properties);
        this.itemSupplier = itemSupplier;
        this.saplingItemSupplier = saplingItemSupplier;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)field_208494_a, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)field_208495_b, (Comparable)Boolean.FALSE));
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.itemSupplier.get());
    }

    public ItemStack getSapling(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.saplingItemSupplier.get());
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)field_208494_a) == 7 && (Boolean)state.func_177229_b((IProperty)field_208495_b) == false || !this.isMaxAge(state);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.func_177229_b((IProperty)field_208495_b)).booleanValue() && (Integer)state.func_177229_b((IProperty)field_208494_a) == 7) {
            FruitLeavesBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            worldIn.func_217377_a(pos, false);
        } else {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (age < 7 && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private static BlockState updateDistance(BlockState state, IWorld worldIn, BlockPos pos) {
        int dist = 7;
        try (BlockPos.PooledMutable mutablePos = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : Direction.values()) {
                mutablePos.func_189533_g((Vec3i)pos).func_189536_c(direction);
                dist = Math.min(dist, FruitLeavesBlock.getDistance(worldIn.func_180495_p((BlockPos)mutablePos)) + 1);
                if (dist != 1) continue;
                break;
            }
        }
        return (BlockState)state.func_206870_a((IProperty)field_208494_a, (Comparable)Integer.valueOf(dist));
    }

    private static int getDistance(BlockState neighbor) {
        if (ModBlocks.fruit_log == neighbor.func_177230_c()) {
            return 0;
        }
        return neighbor.func_177230_c() instanceof FruitLeavesBlock ? (Integer)neighbor.func_177229_b((IProperty)field_208494_a) : 7;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return FruitLeavesBlock.updateDistance((BlockState)this.func_176223_P().func_206870_a((IProperty)field_208495_b, (Comparable)Boolean.TRUE), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{AGE});
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return !this.isMaxAge(state);
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int newAge = Math.min(7, (Integer)state.func_177229_b((IProperty)AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(newAge)), 2);
    }
}

