/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile;

import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.apiimpl.network.node.storage.FluidStorageNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.storage.FluidStorageType;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.config.IAccessType;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IPrioritizable;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.tile.data.RSSerializers;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import com.refinedmods.refinedstorage.util.FluidStorageBlockUtils;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FluidStorageTile
extends NetworkNodeTile<FluidStorageNetworkNode> {
    public static final TileDataParameter<Integer, FluidStorageTile> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer, FluidStorageTile> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, FluidStorageTile> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final TileDataParameter<AccessType, FluidStorageTile> ACCESS_TYPE = IAccessType.createParameter();
    public static final TileDataParameter<Long, FluidStorageTile> STORED = new TileDataParameter<Long, FluidStorageTile>(RSSerializers.LONG_SERIALIZER, 0L, t -> ((FluidStorageNetworkNode)t.getNode()).getStorage() != null ? (long)((FluidStorageNetworkNode)t.getNode()).getStorage().getStored() : 0L);
    private final FluidStorageType type;

    public FluidStorageTile(FluidStorageType type) {
        super(FluidStorageBlockUtils.getTileEntityType(type));
        this.type = type;
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(WHITELIST_BLACKLIST);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
    }

    public FluidStorageType getFluidStorageType() {
        return this.type;
    }

    @Override
    @Nonnull
    public FluidStorageNetworkNode createNode(World world, BlockPos pos) {
        return new FluidStorageNetworkNode(world, pos, this.type);
    }
}

