/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid.view;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.screen.grid.filtering.GridFilterParser;
import com.refinedmods.refinedstorage.screen.grid.sorting.IGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.SortingDirection;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.view.IGridView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public abstract class BaseGridView
implements IGridView {
    private final GridScreen screen;
    private boolean canCraft;
    private final IGridSorter defaultSorter;
    private final List<IGridSorter> sorters;
    private List<IGridStack> stacks = new ArrayList<IGridStack>();
    protected final Map<UUID, IGridStack> map = new HashMap<UUID, IGridStack>();

    public BaseGridView(GridScreen screen, IGridSorter defaultSorter, List<IGridSorter> sorters) {
        this.screen = screen;
        this.defaultSorter = defaultSorter;
        this.sorters = sorters;
    }

    @Override
    public List<IGridStack> getStacks() {
        return this.stacks;
    }

    @Override
    @Nullable
    public IGridStack get(UUID id) {
        return this.map.get(id);
    }

    @Override
    public void sort() {
        if (!this.screen.canSort()) {
            return;
        }
        ArrayList<IGridStack> stacks = new ArrayList<IGridStack>();
        if (this.screen.getGrid().isGridActive()) {
            stacks.addAll(this.map.values());
            IGrid grid = this.screen.getGrid();
            List<Predicate<IGridStack>> filters = GridFilterParser.getFilters(grid, this.screen.getSearchFieldText(), grid.getTabSelected() >= 0 && grid.getTabSelected() < grid.getTabs().size() ? grid.getTabs().get(grid.getTabSelected()).getFilters() : grid.getFilters());
            stacks.removeIf(stack -> {
                if (this.screen.getGrid().getViewType() != 2 && stack.isCraftable() && stack.getOtherId() != null && this.map.containsKey(stack.getOtherId())) {
                    return true;
                }
                for (Predicate filter : filters) {
                    if (filter.test(stack)) continue;
                    return true;
                }
                return false;
            });
            SortingDirection sortingDirection = grid.getSortingDirection() == 1 ? SortingDirection.DESCENDING : SortingDirection.ASCENDING;
            stacks.sort((left, right) -> this.defaultSorter.compare((IGridStack)left, (IGridStack)right, sortingDirection));
            for (IGridSorter sorter : this.sorters) {
                if (!sorter.isApplicable(grid)) continue;
                stacks.sort((left, right) -> sorter.compare((IGridStack)left, (IGridStack)right, sortingDirection));
            }
        }
        this.stacks = stacks;
        this.screen.updateScrollbar();
    }

    @Override
    public void setCanCraft(boolean canCraft) {
        this.canCraft = canCraft;
    }

    @Override
    public boolean canCraft() {
        return this.canCraft;
    }
}

