/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.PriorityScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.AccessTypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.ExactModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.TypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.WhitelistBlacklistSideButton;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class StorageScreen<T extends Container>
extends BaseScreen<T> {
    private static final int BAR_X = 8;
    private static final int BAR_Y = 54;
    private static final int BAR_WIDTH = 16;
    private static final int BAR_HEIGHT = 70;
    private final String texture;
    private final TileDataParameter<Integer, ?> typeParameter;
    private final TileDataParameter<Integer, ?> redstoneModeParameter;
    private final TileDataParameter<Integer, ?> exactModeParameter;
    private final TileDataParameter<Integer, ?> whitelistBlacklistParameter;
    private final TileDataParameter<Integer, ?> priorityParameter;
    private final TileDataParameter<AccessType, ?> accessTypeParameter;
    private final Supplier<Long> storedSupplier;
    private final Supplier<Long> capacitySupplier;

    public StorageScreen(T container, PlayerInventory inventory, ITextComponent title, String texture, @Nullable TileDataParameter<Integer, ?> typeParameter, @Nullable TileDataParameter<Integer, ?> redstoneModeParameter, @Nullable TileDataParameter<Integer, ?> exactModeParameter, @Nullable TileDataParameter<Integer, ?> whitelistBlacklistParameter, TileDataParameter<Integer, ?> priorityParameter, @Nullable TileDataParameter<AccessType, ?> accessTypeParameter, Supplier<Long> storedSupplier, Supplier<Long> capacitySupplier) {
        super(container, 176, 223, inventory, title);
        this.texture = texture;
        this.typeParameter = typeParameter;
        this.redstoneModeParameter = redstoneModeParameter;
        this.exactModeParameter = exactModeParameter;
        this.whitelistBlacklistParameter = whitelistBlacklistParameter;
        this.priorityParameter = priorityParameter;
        this.accessTypeParameter = accessTypeParameter;
        this.storedSupplier = storedSupplier;
        this.capacitySupplier = capacitySupplier;
    }

    @Override
    public void onPostInit(int x, int y) {
        if (this.redstoneModeParameter != null) {
            this.addSideButton(new RedstoneModeSideButton(this, this.redstoneModeParameter));
        }
        if (this.typeParameter != null) {
            this.addSideButton(new TypeSideButton(this, this.typeParameter));
        }
        if (this.whitelistBlacklistParameter != null) {
            this.addSideButton(new WhitelistBlacklistSideButton(this, this.whitelistBlacklistParameter));
        }
        if (this.exactModeParameter != null) {
            this.addSideButton(new ExactModeSideButton(this, this.exactModeParameter));
        }
        if (this.accessTypeParameter != null) {
            this.addSideButton(new AccessTypeSideButton(this, this.accessTypeParameter));
        }
        int buttonWidth = 10 + this.font.func_78256_a(I18n.func_135052_a((String)"misc.refinedstorage.priority", (Object[])new Object[0]));
        this.addButton(x + 169 - buttonWidth, y + 41, buttonWidth, 20, I18n.func_135052_a((String)"misc.refinedstorage.priority", (Object[])new Object[0]), true, true, btn -> this.minecraft.func_147108_a((Screen)new PriorityScreen(this, this.priorityParameter, this.field_213127_e)));
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("refinedstorage", this.texture);
        this.blit(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int barHeightNew = (int)((float)this.storedSupplier.get().longValue() / (float)this.capacitySupplier.get().longValue() * 70.0f);
        this.blit(x + 8, y + 54 + 70 - barHeightNew, 179, 70 - barHeightNew, 16, barHeightNew);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY) {
        this.renderString(7, 7, this.title.func_150254_d());
        this.renderString(7, 42, this.capacitySupplier.get() == -1L ? I18n.func_135052_a((String)"misc.refinedstorage.storage.stored_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().formatWithUnits(this.storedSupplier.get())}) : I18n.func_135052_a((String)"misc.refinedstorage.storage.stored_capacity_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().formatWithUnits(this.storedSupplier.get()), API.instance().getQuantityFormatter().formatWithUnits(this.capacitySupplier.get())}));
        this.renderString(7, 129, I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]));
        if (RenderUtils.inBounds(8, 54, 16, 70, mouseX, mouseY)) {
            int full = 0;
            if (this.capacitySupplier.get() >= 0L) {
                full = (int)((float)this.storedSupplier.get().longValue() / (float)this.capacitySupplier.get().longValue() * 100.0f);
            }
            this.renderTooltip(mouseX, mouseY, (this.capacitySupplier.get() == -1L ? I18n.func_135052_a((String)"misc.refinedstorage.storage.stored_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().format(this.storedSupplier.get())}) : I18n.func_135052_a((String)"misc.refinedstorage.storage.stored_capacity_minimal", (Object[])new Object[]{API.instance().getQuantityFormatter().format(this.storedSupplier.get()), API.instance().getQuantityFormatter().format(this.capacitySupplier.get())})) + "\n" + TextFormatting.GRAY + I18n.func_135052_a((String)"misc.refinedstorage.storage.full", (Object[])new Object[]{full}));
        }
    }
}

